/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.components;

import com.atlauncher.App;
import com.atlauncher.LogManager;
import com.atlauncher.data.Downloadable;
import com.atlauncher.data.Language;
import com.atlauncher.data.Server;
import com.atlauncher.evnt.listener.SettingsListener;
import com.atlauncher.evnt.manager.SettingsManager;
import com.atlauncher.gui.components.AbstractToolPanel;
import com.atlauncher.gui.dialogs.ProgressDialog;
import com.atlauncher.utils.Utils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class NetworkCheckerToolPanel
extends AbstractToolPanel
implements ActionListener,
SettingsListener {
    private static final long serialVersionUID = 4811953376698111667L;
    private final JLabel TITLE_LABEL = new JLabel(Language.INSTANCE.localize("tools.networkchecker"));
    private final JLabel INFO_LABEL = new JLabel("<html><p align=\"center\">" + Utils.splitMultilinedString(Language.INSTANCE.localize("tools.networkchecker.info"), 60, "<br>") + "</p></html>");

    public NetworkCheckerToolPanel() {
        this.TITLE_LABEL.setFont(this.BOLD_FONT);
        this.TOP_PANEL.add(this.TITLE_LABEL);
        this.MIDDLE_PANEL.add(this.INFO_LABEL);
        this.BOTTOM_PANEL.add(this.LAUNCH_BUTTON);
        this.LAUNCH_BUTTON.addActionListener(this);
        this.setBorder(BorderFactory.createBevelBorder(0));
        SettingsManager.addListener(this);
        this.checkLaunchButtonEnabled();
    }

    private void checkLaunchButtonEnabled() {
        this.LAUNCH_BUTTON.setEnabled(App.settings.enableLogs());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object[] options = new String[]{Language.INSTANCE.localize("common.yes"), Language.INSTANCE.localize("common.no")};
        int ret = JOptionPane.showOptionDialog(App.settings.getParent(), "<html><p align=\"center\">" + Utils.splitMultilinedString(Language.INSTANCE.localizeWithReplace("tools.networkcheckerpopup", App.settings.getServers().size() * 20 + " MB.<br/><br/>"), 75, "<br>") + "</p></html>", Language.INSTANCE.localize("tools.networkchecker"), -1, 0, null, options, options[0]);
        if (ret == 0) {
            final ProgressDialog dialog = new ProgressDialog(Language.INSTANCE.localize("tools.networkchecker"), App.settings.getServers().size(), Language.INSTANCE.localize("tools.networkchecker.running"), "Network Checker Tool Cancelled!");
            dialog.addThread(new Thread(){

                @Override
                public void run() {
                    Downloadable download;
                    dialog.setTotalTasksToDo(App.settings.getServers().size() * 5);
                    StringBuilder results = new StringBuilder();
                    for (Server server : App.settings.getServers()) {
                        results.append("Ping results to " + server.getHost() + " was " + Utils.pingAddress(server.getHost()) + "\n\n----------------\n\n");
                        dialog.doneTask();
                        results.append("Tracert to " + server.getHost() + " was " + Utils.traceRoute("www.creeperrepo.net"));
                        dialog.doneTask();
                    }
                    for (Server server : App.settings.getServers()) {
                        download = new Downloadable(server.getFileURL("launcher/json/hashes.json"), false);
                        results.append(String.format("Response code to %s was %d\n\n----------------\n\n", server.getHost(), download.getResponseCode()));
                        dialog.doneTask();
                    }
                    for (Server server : App.settings.getServers()) {
                        download = new Downloadable(server.getFileURL("ping"), false);
                        results.append(String.format("Response to ping on %s was %s\n\n----------------\n\n", server.getHost(), download.getContents()));
                        dialog.doneTask();
                    }
                    for (Server server : App.settings.getServers()) {
                        File file = new File(App.settings.getTempDir(), "20MB.test");
                        if (file.exists()) {
                            Utils.delete(file);
                        }
                        long started = System.currentTimeMillis();
                        Downloadable download2 = new Downloadable(server.getFileURL("20MB.test"), file);
                        download2.download(false);
                        long timeTaken = System.currentTimeMillis() - started;
                        float bps = file.length() / (timeTaken / 1000L);
                        float kbps = bps / 1024.0f;
                        float mbps = kbps / 1024.0f;
                        String speed = mbps < 1.0f ? (kbps < 1.0f ? String.format("%.2f B/s", Float.valueOf(bps)) : String.format("%.2f KB/s", Float.valueOf(kbps))) : String.format("%.2f MB/s", Float.valueOf(mbps));
                        results.append(String.format("Download speed to %s was %s, taking %.2f seconds to download 20MB\n\n----------------\n\n", server.getHost(), speed, (double)timeTaken / 1000.0));
                        dialog.doneTask();
                    }
                    String result = Utils.uploadPaste("ATLauncher Network Test Log", results.toString());
                    if (result.contains("http://rushmead.playat.ch/stikket/")) {
                        LogManager.info("Network Test has finished running, you can view the results at " + result);
                    } else {
                        LogManager.error("Network Test failed to submit to ATLauncher!");
                        dialog.setReturnValue(false);
                    }
                    dialog.doneTask();
                    dialog.setReturnValue(true);
                    dialog.close();
                }
            });
            dialog.start();
            if (dialog.getReturnValue() == null || !((Boolean)dialog.getReturnValue()).booleanValue()) {
                LogManager.error("Network Test failed to run!");
            } else {
                LogManager.info("Network Test ran and submitted to ATLauncher!");
                Object[] options2 = new String[]{Language.INSTANCE.localize("common.ok")};
                JOptionPane.showOptionDialog(App.settings.getParent(), "<html><p align=\"center\">" + Language.INSTANCE.localizeWithReplace("tools.networkheckercomplete", "<br/><br/>") + "</p></html>", Language.INSTANCE.localize("tools.networkchecker"), -1, 1, null, options2, options2[0]);
            }
        }
    }

    @Override
    public void onSettingsSaved() {
        this.checkLaunchButtonEnabled();
    }
}

