/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.components;

import com.atlauncher.App;
import com.atlauncher.data.Language;
import com.atlauncher.evnt.listener.SettingsListener;
import com.atlauncher.evnt.manager.SettingsManager;
import com.atlauncher.gui.components.AbstractToolPanel;
import com.atlauncher.gui.dialogs.ServerListForCheckerDialog;
import com.atlauncher.utils.Utils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class ServerCheckerToolPanel
extends AbstractToolPanel
implements ActionListener,
SettingsListener {
    private static final long serialVersionUID = 1964636496849129267L;
    private final JLabel TITLE_LABEL = new JLabel(Language.INSTANCE.localize("tools.serverchecker"));
    private final JLabel INFO_LABEL = new JLabel("<html><p align=\"center\">" + Utils.splitMultilinedString(Language.INSTANCE.localize("tools.serverchecker.info"), 60, "<br>") + "</p></html>");

    public ServerCheckerToolPanel() {
        this.TITLE_LABEL.setFont(this.BOLD_FONT);
        this.TOP_PANEL.add(this.TITLE_LABEL);
        this.MIDDLE_PANEL.add(this.INFO_LABEL);
        this.BOTTOM_PANEL.add(this.LAUNCH_BUTTON);
        this.LAUNCH_BUTTON.addActionListener(this);
        this.setBorder(BorderFactory.createBevelBorder(0));
        SettingsManager.addListener(this);
        this.checkLaunchButtonEnabled();
    }

    private void checkLaunchButtonEnabled() {
        this.LAUNCH_BUTTON.setEnabled(App.settings.enableServerChecker());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.LAUNCH_BUTTON) {
            new ServerListForCheckerDialog();
        }
    }

    @Override
    public void onSettingsSaved() {
        this.checkLaunchButtonEnabled();
    }
}

