/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.dialogs;

import com.atlauncher.App;
import com.atlauncher.data.Language;
import com.atlauncher.data.MinecraftServer;
import com.atlauncher.gui.dialogs.ProgressDialog;
import com.atlauncher.utils.MCQuery;
import com.atlauncher.utils.Utils;
import de.zh32.pingtest.QueryVersion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AddEditServerForCheckerDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 3385411077046354453L;
    private JPanel middle;
    private JPanel bottom;
    private JLabel serverNameLabel;
    private JTextField serverName;
    private JLabel serverHostLabel;
    private JTextField serverHost;
    private JLabel serverPortLabel;
    private JTextField serverPort;
    private JButton addEditButton;
    private JButton closeButton;
    private MinecraftServer serverEditing = null;

    public AddEditServerForCheckerDialog(MinecraftServer minecraftServer) {
        super(null, Language.INSTANCE.localize(minecraftServer == null ? "tools.addserver" : "tools.editserver"), Dialog.ModalityType.APPLICATION_MODAL);
        this.setSize(300, 200);
        this.setLocationRelativeTo(null);
        this.setLayout(new BorderLayout());
        this.setIconImage(Utils.getImage("/assets/image/Icon.png"));
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.setupComponents();
        if (minecraftServer != null) {
            this.serverEditing = minecraftServer;
            this.addEditButton.setText(Language.INSTANCE.localize("common.edit"));
            this.serverName.setText(minecraftServer.getName());
            this.serverHost.setText(minecraftServer.getHost());
            this.serverPort.setText(minecraftServer.getPort() + "");
        }
        this.setVisible(true);
    }

    private void setupComponents() {
        this.middle = new JPanel();
        this.middle.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 768;
        this.serverNameLabel = new JLabel(Language.INSTANCE.localize("tools.serverchecker.name") + ": ");
        this.middle.add((Component)this.serverNameLabel, gbc);
        ++gbc.gridx;
        gbc.anchor = 512;
        this.serverName = new JTextField(16);
        this.middle.add((Component)this.serverName, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.anchor = 768;
        this.serverHostLabel = new JLabel(Language.INSTANCE.localize("tools.serverchecker.ip") + ": ");
        this.middle.add((Component)this.serverHostLabel, gbc);
        ++gbc.gridx;
        gbc.anchor = 512;
        this.serverHost = new JTextField(16);
        this.middle.add((Component)this.serverHost, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.anchor = 768;
        this.serverPortLabel = new JLabel(Language.INSTANCE.localize("tools.serverchecker.port") + ": ");
        this.middle.add((Component)this.serverPortLabel, gbc);
        ++gbc.gridx;
        gbc.anchor = 512;
        this.serverPort = new JTextField(16);
        this.serverPort.setText("25565");
        this.middle.add((Component)this.serverPort, gbc);
        this.bottom = new JPanel();
        this.bottom.setLayout(new FlowLayout());
        this.addEditButton = new JButton(Language.INSTANCE.localize("common.add"));
        this.addEditButton.addActionListener(this);
        this.bottom.add(this.addEditButton);
        this.closeButton = new JButton(Language.INSTANCE.localize("common.close"));
        this.closeButton.addActionListener(this);
        this.bottom.add(this.closeButton);
        this.add((Component)this.middle, "Center");
        this.add((Component)this.bottom, "South");
    }

    public boolean isValidPort() {
        return !this.serverPort.getText().isEmpty() && Integer.parseInt(this.serverPort.getText().replaceAll("[^0-9]", "")) >= 1 && Integer.parseInt(this.serverPort.getText().replaceAll("[^0-9]", "")) <= 65535;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addEditButton) {
            if (this.serverName.getText().isEmpty() || this.serverHost.getText().isEmpty() || this.serverPort.getText().isEmpty()) {
                JOptionPane.showMessageDialog(App.settings.getParent(), Language.INSTANCE.localize("tools.serverchecker.notallfields"), Language.INSTANCE.localize("common.error"), 0);
            } else if (!this.isValidPort()) {
                JOptionPane.showMessageDialog(App.settings.getParent(), Language.INSTANCE.localize("settings.proxyportinvalid"), Language.INSTANCE.localize("common.error"), 0);
            } else {
                String name = this.serverName.getText();
                final String host = this.serverHost.getText();
                final int port = Integer.parseInt(this.serverPort.getText().replaceAll("[^0-9]", ""));
                QueryVersion qv = null;
                final ProgressDialog dialog = new ProgressDialog(Language.INSTANCE.localize("tools.serverchecker.checkingserver"), 0, Language.INSTANCE.localize("tools.serverchecker.checkingserver"), "Cancelled Server Check!");
                dialog.addThread(new Thread(){

                    @Override
                    public void run() {
                        dialog.setReturnValue((Object)MCQuery.getMinecraftServerQueryVersion(host, port));
                        dialog.close();
                    }
                });
                dialog.start();
                if (dialog.getReturnValue() != null) {
                    qv = (QueryVersion)((Object)dialog.getReturnValue());
                }
                if (qv == null) {
                    JOptionPane.showMessageDialog(App.settings.getParent(), Language.INSTANCE.localize("tools.serverchecker.couldntconnect"), Language.INSTANCE.localize("common.error"), 0);
                } else {
                    App.TOASTER.pop(Language.INSTANCE.localize(this.serverEditing == null ? "tools.serverchecker.serveradded" : "tools.serverchecker.serveredited"));
                    if (this.serverEditing == null) {
                        App.settings.addCheckingServer(new MinecraftServer(name, host, port, qv));
                    } else {
                        this.serverEditing.setName(name);
                        this.serverEditing.setHost(host);
                        this.serverEditing.setPort(port);
                        this.serverEditing.setQueryVersion(qv);
                        App.settings.saveCheckingServers();
                    }
                    this.close();
                }
            }
        } else if (e.getSource() == this.closeButton) {
            this.close();
        }
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }
}

