/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.dialogs;

import com.atlauncher.App;
import com.atlauncher.data.Language;
import com.atlauncher.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AddPackDialog
extends JDialog {
    private JPanel top;
    private JPanel middle;
    private JPanel bottom;
    private JLabel packCodeLabel;
    private JTextField packCode;
    private JButton saveButton;

    public AddPackDialog() {
        super(null, Language.INSTANCE.localize("pack.addpack"), Dialog.ModalityType.APPLICATION_MODAL);
        this.setSize(300, 150);
        this.setLocationRelativeTo(null);
        this.setLayout(new BorderLayout());
        this.setIconImage(Utils.getImage("/assets/image/Icon.png"));
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.top = new JPanel();
        this.top.add(new JLabel(Language.INSTANCE.localize("pack.addpack")));
        this.middle = new JPanel();
        this.middle.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 768;
        this.packCodeLabel = new JLabel(Language.INSTANCE.localize("pack.packcode") + ": ");
        this.middle.add((Component)this.packCodeLabel, gbc);
        ++gbc.gridx;
        gbc.anchor = 512;
        this.packCode = new JTextField(16);
        this.middle.add((Component)this.packCode, gbc);
        this.bottom = new JPanel();
        this.bottom.setLayout(new FlowLayout());
        this.saveButton = new JButton(Language.INSTANCE.localize("common.save"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (App.settings.semiPublicPackExistsFromCode(AddPackDialog.this.packCode.getText())) {
                    if (App.settings.addPack(AddPackDialog.this.packCode.getText())) {
                        JOptionPane.showMessageDialog(AddPackDialog.this, Language.INSTANCE.localize("pack.packaddedmessage"), Language.INSTANCE.localize("pack.packadded"), 1);
                    } else {
                        JOptionPane.showMessageDialog(AddPackDialog.this, Language.INSTANCE.localize("pack.packalreadyaddedmessage"), Language.INSTANCE.localize("pack.packalreadyadded"), 0);
                    }
                    AddPackDialog.this.setVisible(false);
                    AddPackDialog.this.dispose();
                } else {
                    JOptionPane.showMessageDialog(AddPackDialog.this, Language.INSTANCE.localize("pack.packdoesntexist"), Language.INSTANCE.localize("pack.packaddederror"), 0);
                }
            }
        });
        this.bottom.add(this.saveButton);
        this.add((Component)this.top, "North");
        this.add((Component)this.middle, "Center");
        this.add((Component)this.bottom, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                AddPackDialog.this.setVisible(false);
                AddPackDialog.this.dispose();
            }
        });
        this.setVisible(true);
    }
}

