/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.dialogs;

import com.atlauncher.App;
import com.atlauncher.data.Instance;
import com.atlauncher.data.Language;
import com.atlauncher.data.SyncAbstract;
import com.atlauncher.gui.CustomLineBorder;
import com.atlauncher.gui.components.CollapsiblePanel;
import com.atlauncher.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolTip;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BackupDialog
extends JDialog
implements ActionListener {
    private final Instance instance;
    private final JButton backupButton = new JButton(Language.INSTANCE.localize("common.backup"));
    private final JButton restoreButton = new JButton(Language.INSTANCE.localize("common.restore"));
    private final JButton deleteButton = new JButton(Language.INSTANCE.localize("common.delete"));
    private JList worldList;
    private JList backupList;
    private SyncAbstract selectedSync = SyncAbstract.syncList.get(App.settings.getLastSelectedSync());

    public BackupDialog(Instance inst) {
        super(App.settings.getParent(), Language.INSTANCE.localize("backup.dialog.title"));
        this.instance = inst;
        this.setSize(320, 420);
        this.setLocationRelativeTo(App.settings.getParent());
        this.setLayout(new BorderLayout());
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.requestFocus();
        JPanel backupPanel = this.createBackupPanel();
        JPanel restorePanel = this.createRestorePanel();
        JPanel settingsPanel = this.createSettingsPanel();
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(Language.INSTANCE.localize("common.backup"), null, backupPanel);
        tabbedPane.addTab(Language.INSTANCE.localize("common.restore"), null, restorePanel);
        tabbedPane.addTab(Language.INSTANCE.localize("tabs.settings"), null, settingsPanel);
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                File[] files;
                List<String> list = BackupDialog.this.selectedSync.getBackupsForInstance(BackupDialog.this.instance);
                if (list == null) {
                    BackupDialog.this.backupList.setListData(new String[0]);
                } else {
                    BackupDialog.this.backupList.setListData(list.toArray(new String[list.size()]));
                }
                list = new ArrayList<String>();
                if (BackupDialog.this.instance.getSavesDirectory().exists() && BackupDialog.this.instance.getSavesDirectory().exists() && (files = BackupDialog.this.instance.getSavesDirectory().listFiles()) != null) {
                    for (File file : files) {
                        if (!file.isDirectory() || file.getName().equals("NEI")) continue;
                        list.add(file.getName());
                    }
                }
                if (list.size() == 0) {
                    BackupDialog.this.worldList.setListData(new String[0]);
                } else {
                    BackupDialog.this.worldList.setListData(list.toArray(new String[list.size()]));
                }
            }
        });
        this.add((Component)tabbedPane, "North");
    }

    private JPanel createBackupPanel() {
        File[] files;
        ArrayList<String> worldData = new ArrayList<String>();
        if (this.instance.getSavesDirectory().exists() && this.instance.getSavesDirectory().exists() && (files = this.instance.getSavesDirectory().listFiles()) != null) {
            for (File file : files) {
                if (!file.isDirectory() || file.getName().equals("NEI")) continue;
                worldData.add(file.getName());
            }
        }
        this.worldList = new JList<String>(worldData.toArray(new String[worldData.size()]));
        this.worldList.setSelectionMode(1);
        this.worldList.setLayoutOrientation(1);
        this.worldList.setVisibleRowCount(-1);
        this.worldList.setBorder(BorderFactory.createBevelBorder(1));
        this.worldList.setFixedCellWidth(305);
        this.worldList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    BackupDialog.this.backupButton.doClick();
                }
            }
        });
        JScrollPane listScroller = new JScrollPane(this.worldList, 20, 31);
        listScroller.setPreferredSize(new Dimension(230, 300));
        listScroller.setAlignmentX(0.0f);
        JLabel backupLabel = new JLabel(Language.INSTANCE.localize("backup.label.backupchoose"));
        backupLabel.setLabelFor(this.worldList);
        backupLabel.setHorizontalAlignment(0);
        backupLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.backupButton.setHorizontalAlignment(0);
        this.backupButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(this.backupButton);
        JPanel backupPanel = new JPanel();
        backupPanel.setLayout(new BorderLayout());
        backupPanel.add((Component)backupLabel, "North");
        backupPanel.add((Component)listScroller, "Center");
        backupPanel.add((Component)buttonPanel, "South");
        return backupPanel;
    }

    private JPanel createRestorePanel() {
        JComboBox<String> syncChoice = new JComboBox<String>();
        for (Map.Entry<String, SyncAbstract> entry : SyncAbstract.syncList.entrySet()) {
            syncChoice.addItem(entry.getKey());
        }
        syncChoice.addActionListener(this);
        syncChoice.setMaximumSize(new Dimension(100, 50));
        List<String> list = this.selectedSync.getBackupsForInstance(this.instance);
        this.backupList = list == null ? new JList() : new JList<String>(list.toArray(new String[list.size()]));
        this.backupList.setSelectionMode(1);
        this.backupList.setLayoutOrientation(1);
        this.backupList.setVisibleRowCount(-1);
        this.backupList.setBorder(BorderFactory.createBevelBorder(1));
        this.backupList.setFixedCellWidth(305);
        this.backupList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    BackupDialog.this.restoreButton.doClick();
                }
            }
        });
        JScrollPane listScroller = new JScrollPane(this.backupList, 20, 31);
        listScroller.setPreferredSize(new Dimension(230, 300));
        listScroller.setAlignmentX(0.0f);
        JLabel restoreLabel = new JLabel(Language.INSTANCE.localize("backup.label.restorechoose"));
        restoreLabel.setLabelFor(this.backupList);
        restoreLabel.setHorizontalAlignment(0);
        restoreLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setDividerSize(0);
        splitPane.setRightComponent(syncChoice);
        splitPane.setLeftComponent(restoreLabel);
        this.restoreButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(this.restoreButton);
        buttonPanel.add(this.deleteButton);
        JPanel restorePanel = new JPanel();
        restorePanel.setLayout(new BorderLayout());
        restorePanel.add((Component)splitPane, "North");
        restorePanel.add((Component)listScroller, "Center");
        restorePanel.add((Component)buttonPanel, "South");
        return restorePanel;
    }

    private JPanel createSettingsPanel() {
        JPanel settingsPanel = new JPanel();
        settingsPanel.add(new BackupGeneralSettingsPanel());
        for (Map.Entry<String, SyncAbstract> entry : SyncAbstract.syncList.entrySet()) {
            CollapsiblePanel settingPanel = entry.getValue().getSettingsPanel();
            if (settingPanel == null) continue;
            settingsPanel.add(settingPanel);
        }
        return settingsPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("Backup".equals(e.getActionCommand()) && this.worldList.getSelectedValue() != null) {
            String worldToBackup = (String)this.worldList.getSelectedValue();
            String backupName = JOptionPane.showInputDialog(this, Language.INSTANCE.localize("backup.message.backupname"), Language.INSTANCE.localize("backup.message.backupname.title"), 3);
            if (backupName != null) {
                for (Map.Entry<String, SyncAbstract> entry : SyncAbstract.syncList.entrySet()) {
                    File worldData = new File(this.instance.getSavesDirectory(), worldToBackup);
                    if (worldData.exists()) {
                        entry.getValue().backupWorld(backupName, worldData, this.instance);
                        continue;
                    }
                    JOptionPane.showMessageDialog(this, Language.INSTANCE.localize("backup.message.backupfailed.missingdirectory"), Language.INSTANCE.localize("backup.message.backupfailed.title"), 0);
                }
            }
        } else if ("Restore".equals(e.getActionCommand()) && this.backupList.getSelectedValue() != null) {
            String backupToRestore = (String)this.backupList.getSelectedValue();
            this.selectedSync.restoreBackup(backupToRestore, this.instance);
        } else if ("Delete".equals(e.getActionCommand()) && this.backupList.getSelectedValue() != null) {
            String backupToDelete = (String)this.backupList.getSelectedValue();
            if (JOptionPane.showOptionDialog(this, Language.INSTANCE.localizeWithReplace("backup.message.deleteconfirm", backupToDelete), Language.INSTANCE.localize("backup.message.deleteconfirm.title"), 2, 2, null, null, null) == 0) {
                this.selectedSync.deleteBackup(backupToDelete, this.instance);
                List<String> list = this.selectedSync.getBackupsForInstance(this.instance);
                if (list == null) {
                    this.backupList.setListData(new String[0]);
                } else {
                    this.backupList.setListData(list.toArray(new String[list.size()]));
                }
            }
        } else if (e.getSource() instanceof JComboBox) {
            String selection = (String)((JComboBox)e.getSource()).getSelectedItem();
            this.selectedSync = SyncAbstract.syncList.get(selection);
            App.settings.setLastSelectedSync(selection);
            List<String> list = this.selectedSync.getBackupsForInstance(this.instance);
            this.backupList.setListData(list.toArray(new String[list.size()]));
        }
    }

    public class BackupGeneralSettingsPanel
    extends CollapsiblePanel {
        private final GridBagConstraints gbc;

        public BackupGeneralSettingsPanel() {
            super("General");
            this.gbc = new GridBagConstraints();
            JPanel panel = super.getContentPane();
            panel.setLayout(new GridBagLayout());
            ImageIcon helpIcon = Utils.getIconImage("/assets/image/Help.png");
            panel.setMinimumSize(new Dimension(300, 10));
            panel.setSize(300, 300);
            this.gbc.gridx = 0;
            this.gbc.gridy = 0;
            this.gbc.insets = new Insets(3, 0, 3, 10);
            this.gbc.anchor = 768;
            JLabel autoBackupLabel = new JLabel(Language.INSTANCE.localize("backup.label.autobackup") + ":"){

                @Override
                public JToolTip createToolTip() {
                    JToolTip tip = super.createToolTip();
                    CustomLineBorder border = new CustomLineBorder(5, App.THEME.getHoverBorderColor(), 2);
                    tip.setBorder(border);
                    return tip;
                }
            };
            autoBackupLabel.setIcon(helpIcon);
            autoBackupLabel.setToolTipText(Language.INSTANCE.localize("backup.label.autobackup.tooltip"));
            panel.add((Component)autoBackupLabel, this.gbc);
            JCheckBox autoBackup = new JCheckBox(){

                @Override
                public JToolTip createToolTip() {
                    JToolTip tip = super.createToolTip();
                    CustomLineBorder border = new CustomLineBorder(5, App.THEME.getHoverBorderColor(), 2);
                    tip.setBorder(border);
                    return tip;
                }
            };
            autoBackup.setToolTipText(Language.INSTANCE.localize("backup.label.autobackup.tooltip"));
            autoBackup.setSelected(App.settings.getAutoBackup());
            autoBackup.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    App.settings.setAutoBackup(e.getStateChange() == 1);
                }
            });
            panel.add((Component)autoBackup, this.getGBCForField());
            JLabel notifyLabel = new JLabel(Language.INSTANCE.localize("backup.label.notify") + ":"){

                @Override
                public JToolTip createToolTip() {
                    JToolTip tip = super.createToolTip();
                    CustomLineBorder border = new CustomLineBorder(5, App.THEME.getHoverBorderColor(), 2);
                    tip.setBorder(border);
                    return tip;
                }
            };
            notifyLabel.setIcon(helpIcon);
            notifyLabel.setToolTipText(Language.INSTANCE.localize("backup.label.notify.tooltip"));
            panel.add((Component)notifyLabel, this.getGBCForLabel());
            JCheckBox notify = new JCheckBox(){

                @Override
                public JToolTip createToolTip() {
                    JToolTip tip = super.createToolTip();
                    CustomLineBorder border = new CustomLineBorder(5, App.THEME.getHoverBorderColor(), 2);
                    tip.setBorder(border);
                    return tip;
                }
            };
            notify.setToolTipText(Language.INSTANCE.localize("backup.label.notify.tooltip"));
            notify.setSelected(App.settings.getNotifyBackup());
            notify.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    App.settings.setNotifyBackup(e.getStateChange() == 1);
                }
            });
            panel.add((Component)notify, this.getGBCForField());
        }

        private GridBagConstraints getGBCForLabel() {
            this.gbc.gridx = 0;
            ++this.gbc.gridy;
            this.gbc.insets = new Insets(3, 0, 3, 10);
            this.gbc.anchor = 768;
            return this.gbc;
        }

        private GridBagConstraints getGBCForField() {
            ++this.gbc.gridx;
            this.gbc.insets = new Insets(3, 0, 3, 0);
            this.gbc.anchor = 512;
            return this.gbc;
        }
    }
}

