/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.dialogs;

import com.atlauncher.App;
import com.atlauncher.data.DisableableMod;
import com.atlauncher.data.Instance;
import com.atlauncher.data.Language;
import com.atlauncher.data.Type;
import com.atlauncher.gui.components.ModsJCheckBox;
import com.atlauncher.gui.dialogs.FileChooserDialog;
import com.atlauncher.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class EditModsDialog
extends JDialog {
    private static final long serialVersionUID = 7004414192679481818L;
    private Instance instance;
    private JPanel bottomPanel;
    private JPanel disabledModsPanel;
    private JPanel enabledModsPanel;
    private JSplitPane split;
    private JSplitPane labelsTop;
    private JSplitPane labels;
    private JSplitPane modsInPack;
    private JScrollPane scroller1;
    private JScrollPane scroller2;
    private JButton addButton;
    private JButton enableButton;
    private JButton disableButton;
    private JButton removeButton;
    private JButton closeButton;
    private JLabel topLabelLeft;
    private JLabel topLabelRight;
    private ArrayList<ModsJCheckBox> enabledMods;
    private ArrayList<ModsJCheckBox> disabledMods;

    public EditModsDialog(final Instance instance) {
        super(App.settings.getParent(), Language.INSTANCE.localizeWithReplace("instance.editingmods", instance.getName()), Dialog.ModalityType.APPLICATION_MODAL);
        this.instance = instance;
        this.setSize(550, 450);
        this.setLocationRelativeTo(App.settings.getParent());
        this.setLayout(new BorderLayout());
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                EditModsDialog.this.dispose();
            }
        });
        this.split = new JSplitPane(0);
        this.split.setDividerSize(0);
        this.split.setBorder(null);
        this.split.setEnabled(false);
        this.add((Component)this.split, "North");
        this.labelsTop = new JSplitPane(0);
        this.labelsTop.setDividerSize(0);
        this.labelsTop.setBorder(null);
        this.labelsTop.setEnabled(false);
        this.split.setLeftComponent(this.labelsTop);
        this.labels = new JSplitPane();
        this.labels.setDividerLocation(275);
        this.labels.setDividerSize(0);
        this.labels.setBorder(null);
        this.labels.setEnabled(false);
        this.split.setRightComponent(this.labels);
        this.topLabelLeft = new JLabel(Language.INSTANCE.localize("instance.enabledmods"));
        this.topLabelLeft.setHorizontalAlignment(0);
        this.labels.setLeftComponent(this.topLabelLeft);
        this.topLabelRight = new JLabel(Language.INSTANCE.localize("instance.disabledmods"));
        this.topLabelRight.setHorizontalAlignment(0);
        this.labels.setRightComponent(this.topLabelRight);
        this.modsInPack = new JSplitPane();
        this.modsInPack.setDividerLocation(275);
        this.modsInPack.setDividerSize(0);
        this.modsInPack.setBorder(null);
        this.modsInPack.setEnabled(false);
        this.add((Component)this.modsInPack, "Center");
        this.disabledModsPanel = new JPanel();
        this.disabledModsPanel.setLayout(null);
        this.disabledModsPanel.setBackground(App.THEME.getModSelectionBackgroundColor());
        this.scroller1 = new JScrollPane(this.disabledModsPanel, 22, 31);
        this.scroller1.getVerticalScrollBar().setUnitIncrement(16);
        this.scroller1.setPreferredSize(new Dimension(275, 350));
        this.modsInPack.setRightComponent(this.scroller1);
        this.enabledModsPanel = new JPanel();
        this.enabledModsPanel.setLayout(null);
        this.enabledModsPanel.setBackground(App.THEME.getModSelectionBackgroundColor());
        this.scroller2 = new JScrollPane(this.enabledModsPanel, 22, 31);
        this.scroller2.getVerticalScrollBar().setUnitIncrement(16);
        this.scroller2.setPreferredSize(new Dimension(275, 350));
        this.modsInPack.setLeftComponent(this.scroller2);
        this.bottomPanel = new JPanel();
        this.add((Component)this.bottomPanel, "South");
        this.addButton = new JButton(Language.INSTANCE.localize("instance.addmod"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDialog fcd = new FileChooserDialog(Language.INSTANCE.localize("instance.addmod"), Language.INSTANCE.localize("common.mod"), Language.INSTANCE.localize("common.add"), Language.INSTANCE.localize("instance.typeofmod"), Language.INSTANCE.localize("instance.selectmodtype"), new String[]{"Mods Folder", "Inside Minecraft.jar", "CoreMods Mod", "Texture Pack", "Resource Pack", "Shader Pack"}, new String[]{"jar", "zip", "litemod"});
                ArrayList<File> files = fcd.getChosenFiles();
                if (files != null && files.size() >= 1) {
                    boolean reload = false;
                    for (File file : files) {
                        String typeTemp = fcd.getSelectorValue();
                        Type type = null;
                        if (typeTemp.equalsIgnoreCase("Mods Folder")) {
                            type = Type.mods;
                        } else if (typeTemp.equalsIgnoreCase("Inside Minecraft.jar")) {
                            type = Type.jar;
                        } else if (typeTemp.equalsIgnoreCase("CoreMods Mod")) {
                            type = Type.coremods;
                        } else if (typeTemp.equalsIgnoreCase("Texture Pack")) {
                            type = Type.texturepack;
                        } else if (typeTemp.equalsIgnoreCase("Resource Pack")) {
                            type = Type.resourcepack;
                        } else if (typeTemp.equalsIgnoreCase("Shader Pack")) {
                            type = Type.shaderpack;
                        }
                        if (type == null) continue;
                        DisableableMod mod = new DisableableMod(file.getName(), "Custom", true, file.getName(), type, null, null, true, true);
                        if (!Utils.copyFile(file, instance.getDisabledModsDirectory())) continue;
                        instance.getInstalledMods().add(mod);
                        EditModsDialog.this.disabledMods.add(new ModsJCheckBox(mod));
                        reload = true;
                    }
                    if (reload) {
                        EditModsDialog.this.reloadPanels();
                    }
                }
            }
        });
        this.bottomPanel.add(this.addButton);
        this.enableButton = new JButton(Language.INSTANCE.localize("instance.enablemod"));
        this.enableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditModsDialog.this.enableMods();
            }
        });
        this.bottomPanel.add(this.enableButton);
        this.disableButton = new JButton(Language.INSTANCE.localize("instance.disablemod"));
        this.disableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditModsDialog.this.disableMods();
            }
        });
        this.bottomPanel.add(this.disableButton);
        this.removeButton = new JButton(Language.INSTANCE.localize("instance.removemod"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditModsDialog.this.removeMods();
            }
        });
        this.bottomPanel.add(this.removeButton);
        this.closeButton = new JButton(Language.INSTANCE.localize("common.close"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditModsDialog.this.dispose();
            }
        });
        this.bottomPanel.add(this.closeButton);
        this.loadMods();
        this.setVisible(true);
    }

    private void loadMods() {
        ModsJCheckBox checkBox;
        int i;
        List<DisableableMod> mods = this.instance.getInstalledMods();
        this.enabledMods = new ArrayList();
        this.disabledMods = new ArrayList();
        int dCount = 0;
        int eCount = 0;
        for (DisableableMod mod : mods) {
            ModsJCheckBox checkBox2 = null;
            int nameSize = this.getFontMetrics(Utils.getFont()).stringWidth(mod.getName());
            checkBox2 = new ModsJCheckBox(mod);
            if (mod.isDisabled()) {
                checkBox2.setBounds(0, dCount * 20, nameSize + 23, 20);
                this.disabledMods.add(checkBox2);
                ++dCount;
                continue;
            }
            checkBox2.setBounds(0, eCount * 20, nameSize + 23, 20);
            this.enabledMods.add(checkBox2);
            ++eCount;
        }
        for (i = 0; i < this.enabledMods.size(); ++i) {
            checkBox = this.enabledMods.get(i);
            this.enabledModsPanel.add(checkBox);
        }
        for (i = 0; i < this.disabledMods.size(); ++i) {
            checkBox = this.disabledMods.get(i);
            this.disabledModsPanel.add(checkBox);
        }
        this.enabledModsPanel.setPreferredSize(new Dimension(0, this.enabledMods.size() * 20));
        this.disabledModsPanel.setPreferredSize(new Dimension(0, this.disabledMods.size() * 20));
    }

    private void enableMods() {
        ArrayList<ModsJCheckBox> mods = new ArrayList<ModsJCheckBox>(this.disabledMods);
        for (ModsJCheckBox mod : mods) {
            if (!mod.isSelected()) continue;
            mod.getDisableableMod().enable(this.instance);
        }
        this.reloadPanels();
    }

    private void disableMods() {
        ArrayList<ModsJCheckBox> mods = new ArrayList<ModsJCheckBox>(this.enabledMods);
        for (ModsJCheckBox mod : mods) {
            if (!mod.isSelected()) continue;
            mod.getDisableableMod().disable(this.instance);
        }
        this.reloadPanels();
    }

    private void removeMods() {
        ArrayList<ModsJCheckBox> mods = new ArrayList<ModsJCheckBox>(this.enabledMods);
        for (ModsJCheckBox mod : mods) {
            if (!mod.isSelected()) continue;
            this.instance.removeInstalledMod(mod.getDisableableMod());
            this.enabledMods.remove(mod);
        }
        mods = new ArrayList<ModsJCheckBox>(this.disabledMods);
        for (ModsJCheckBox mod : mods) {
            if (!mod.isSelected()) continue;
            this.instance.removeInstalledMod(mod.getDisableableMod());
            this.disabledMods.remove(mod);
        }
        this.reloadPanels();
    }

    private void reloadPanels() {
        App.settings.saveInstances();
        this.enabledModsPanel.removeAll();
        this.disabledModsPanel.removeAll();
        this.loadMods();
        this.enabledModsPanel.repaint();
        this.disabledModsPanel.repaint();
    }
}

