/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.dialogs;

import com.atlauncher.App;
import com.atlauncher.data.Language;
import com.atlauncher.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class FileChooserDialog
extends JDialog {
    private JPanel top;
    private JPanel middle;
    private JPanel bottom;
    private JLabel nameLabel;
    private JTextField textField;
    private JLabel selectorLabel;
    private JComboBox<String> selector;
    private File[] filesChosen;
    private String[] fileOptions;
    private JButton bottomButton;
    private JButton selectButton;

    public FileChooserDialog(String title, String labelName, String bottomText, String selectorText, String selectorSelectText, String[] subOptions, String[] options) {
        super(App.settings.getParent(), title, Dialog.ModalityType.APPLICATION_MODAL);
        this.fileOptions = options;
        this.setSize(400, 175);
        this.setLocationRelativeTo(null);
        this.setLayout(new BorderLayout());
        this.setIconImage(Utils.getImage("/assets/image/Icon.png"));
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.top = new JPanel();
        this.top.add(new JLabel(title));
        this.middle = new JPanel();
        this.middle.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 768;
        this.nameLabel = new JLabel(labelName + ": ");
        this.middle.add((Component)this.nameLabel, gbc);
        ++gbc.gridx;
        gbc.anchor = 512;
        this.textField = new JTextField(16);
        this.textField.setEnabled(false);
        this.middle.add((Component)this.textField, gbc);
        ++gbc.gridx;
        gbc.anchor = 512;
        this.selectButton = new JButton(Language.INSTANCE.localize("common.select"));
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser(App.settings.getBaseDir());
                fileChooser.setMultiSelectionEnabled(true);
                fileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return "Mod Files (.jar; .zip; .litemod)";
                    }

                    @Override
                    public boolean accept(File f) {
                        if (f.isDirectory()) {
                            return true;
                        }
                        for (String ext : FileChooserDialog.this.fileOptions) {
                            if (!f.getName().endsWith(ext)) continue;
                            return true;
                        }
                        return false;
                    }
                });
                fileChooser.showOpenDialog(App.settings.getParent());
                FileChooserDialog.access$102(FileChooserDialog.this, fileChooser.getSelectedFiles());
                if (FileChooserDialog.this.filesChosen != null && FileChooserDialog.this.filesChosen.length >= 1) {
                    if (FileChooserDialog.this.filesChosen.length == 1) {
                        FileChooserDialog.this.textField.setText(FileChooserDialog.this.filesChosen[0].getAbsolutePath());
                    } else {
                        FileChooserDialog.this.textField.setText(FileChooserDialog.this.filesChosen.length + " Files Selected!");
                    }
                }
            }
        });
        this.middle.add((Component)this.selectButton, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.anchor = 768;
        this.selectorLabel = new JLabel(selectorText + ": ");
        this.middle.add((Component)this.selectorLabel, gbc);
        ++gbc.gridx;
        gbc.anchor = 512;
        this.selector = new JComboBox();
        this.selector.addItem(selectorSelectText);
        for (String item : subOptions) {
            this.selector.addItem(item);
        }
        this.middle.add(this.selector, gbc);
        this.bottom = new JPanel();
        this.bottom.setLayout(new FlowLayout());
        this.bottomButton = new JButton(bottomText);
        this.bottomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDialog.this.close();
            }
        });
        this.bottom.add(this.bottomButton);
        this.add((Component)this.top, "North");
        this.add((Component)this.middle, "Center");
        this.add((Component)this.bottom, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                FileChooserDialog.this.close();
            }
        });
        this.setVisible(true);
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    public ArrayList<File> getChosenFiles() {
        ArrayList<File> files = new ArrayList<File>();
        if (this.filesChosen == null) {
            return null;
        }
        for (File file : this.filesChosen) {
            for (String ext : this.fileOptions) {
                if (!file.getName().endsWith(ext)) continue;
                files.add(file);
            }
        }
        return files;
    }

    public String getSelectorValue() {
        if (this.selector.getSelectedIndex() == 0) {
            return null;
        }
        return (String)this.selector.getSelectedItem();
    }

    static /* synthetic */ File[] access$102(FileChooserDialog x0, File[] x1) {
        x0.filesChosen = x1;
        return x1;
    }
}

