/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.dialogs;

import com.atlauncher.App;
import com.atlauncher.data.Constants;
import com.atlauncher.data.Language;
import com.atlauncher.gui.components.ToolsPanel;
import com.atlauncher.reporter.GithubIssueReporter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public final class GithubIssueReporterDialog
extends JDialog {
    private final JTextField TITLE_FIELD = new JTextField(16);
    private final JTextArea INFO_AREA = new JTextArea(16, 16);
    private final JButton CANCEL_BUTTON = new JButton(Language.INSTANCE.localize("common.cancel"));
    private final JButton SUBMIT_BUTTON = new JButton(Language.INSTANCE.localize("common.submit"));

    public GithubIssueReporterDialog(JFrame parent) {
        super((Window)parent, "Submit a bug", Dialog.ModalityType.APPLICATION_MODAL);
        this.CANCEL_BUTTON.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GithubIssueReporterDialog.this.dispose();
            }
        });
        this.SUBMIT_BUTTON.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                App.TASKPOOL.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            GithubIssueReporter.submit(GithubIssueReporterDialog.this.TITLE_FIELD.getText() + " - " + Constants.VERSION, GithubIssueReporterDialog.this.INFO_AREA.getText());
                        }
                        catch (Exception e1) {
                            e1.printStackTrace(System.err);
                        }
                        GithubIssueReporterDialog.this.dispose();
                    }
                });
            }
        });
        this.INFO_AREA.setLineWrap(true);
        this.setLocationRelativeTo(parent);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        this.add((Component)this.TITLE_FIELD, "North");
        this.add((Component)new JScrollPane(this.INFO_AREA, 20, 31), "Center");
        this.add((Component)new ToolsPanel().add(this.CANCEL_BUTTON).add(this.SUBMIT_BUTTON), "South");
        this.pack();
    }
}

