/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.dialogs;

import com.atlauncher.App;
import com.atlauncher.data.Instance;
import com.atlauncher.data.Language;
import com.atlauncher.data.Pack;
import com.atlauncher.data.PackVersion;
import com.atlauncher.utils.Utils;
import com.atlauncher.workers.InstanceInstaller;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

public class InstanceInstallerDialog
extends JDialog {
    private static final long serialVersionUID = -6984886874482721558L;
    private boolean isReinstall = false;
    private boolean isServer = false;
    private Pack pack = null;
    private Instance instance = null;
    private JPanel top;
    private JPanel middle;
    private JPanel bottom;
    private JButton install;
    private JButton cancel;
    private JProgressBar progressBar;
    private JProgressBar subProgressBar;
    private JLabel instanceNameLabel;
    private JTextField instanceNameField;
    private JLabel versionLabel;
    private JComboBox<PackVersion> versionsDropDown;
    private ArrayList<PackVersion> versions = new ArrayList();
    private JLabel installForLabel;
    private JCheckBox installForMe;
    private boolean isCustomPack = false;

    public InstanceInstallerDialog(Object object) {
        this(object, false, false);
    }

    public InstanceInstallerDialog(Pack pack, boolean isServer) {
        this((Object)pack, false, true);
    }

    public InstanceInstallerDialog(Object object, final boolean isUpdate, final boolean isServer) {
        super(App.settings.getParent(), Dialog.ModalityType.APPLICATION_MODAL);
        if (object instanceof Pack) {
            this.pack = (Pack)object;
            this.setTitle(Language.INSTANCE.localize("common.installing") + " " + this.pack.getName());
            if (isServer) {
                this.setTitle(Language.INSTANCE.localize("common.installing") + " " + this.pack.getName() + " " + Language.INSTANCE.localize("common.server"));
                this.isServer = true;
            }
        } else {
            this.instance = (Instance)object;
            this.pack = this.instance.getRealPack();
            this.isReinstall = true;
            this.setTitle(Language.INSTANCE.localize("common.reinstalling") + " " + this.instance.getName());
        }
        this.setSize(400, 225);
        this.setLocationRelativeTo(App.settings.getParent());
        this.setLayout(new BorderLayout());
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.top = new JPanel();
        this.top.add(new JLabel((this.isReinstall ? Language.INSTANCE.localize("common.reinstalling") : Language.INSTANCE.localize("common.installing")) + " " + this.pack.getName()));
        this.middle = new JPanel();
        this.middle.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        if (!this.isServer) {
            gbc.anchor = 768;
            this.instanceNameLabel = new JLabel(Language.INSTANCE.localize("instance.name") + ": ");
            this.middle.add((Component)this.instanceNameLabel, gbc);
            ++gbc.gridx;
            gbc.anchor = 512;
            this.instanceNameField = new JTextField(17);
            this.instanceNameField.setText(this.isReinstall ? this.instance.getName() : this.pack.getName());
            if (this.isReinstall) {
                this.instanceNameField.setEnabled(false);
            }
            this.middle.add((Component)this.instanceNameField, gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
        }
        gbc.anchor = 768;
        this.versionLabel = new JLabel(Language.INSTANCE.localize("instance.versiontoinstall") + ": ");
        this.middle.add((Component)this.versionLabel, gbc);
        ++gbc.gridx;
        gbc.anchor = 512;
        this.versionsDropDown = new JComboBox();
        if (this.pack.isTester()) {
            for (PackVersion pv : this.pack.getDevVersions()) {
                if (isServer && (!isServer || !pv.getMinecraftVersion().canCreateServer())) continue;
                this.versions.add(pv);
            }
        }
        for (PackVersion pv : this.pack.getVersions()) {
            if (isServer && (!isServer || !pv.getMinecraftVersion().canCreateServer())) continue;
            this.versions.add(pv);
        }
        PackVersion forUpdate = null;
        for (PackVersion version : this.versions) {
            if (!version.isDev() && forUpdate == null) {
                forUpdate = version;
            }
            this.versionsDropDown.addItem(version);
        }
        if (isUpdate && forUpdate != null) {
            this.versionsDropDown.setSelectedItem(forUpdate);
        } else if (this.isReinstall) {
            for (PackVersion version : this.versions) {
                if (!version.versionMatches(this.instance.getVersion())) continue;
                this.versionsDropDown.setSelectedItem(version);
            }
        } else {
            for (PackVersion version : this.versions) {
                if (!version.isRecommended() || version.isDev()) continue;
                this.versionsDropDown.setSelectedItem(version);
                break;
            }
        }
        this.versionsDropDown.setPreferredSize(new Dimension(200, 25));
        this.middle.add(this.versionsDropDown, gbc);
        if (!this.isServer && !this.isReinstall) {
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.anchor = 768;
            this.installForLabel = new JLabel(Language.INSTANCE.localize("instance.installjustforme") + "? ");
            this.middle.add((Component)this.installForLabel, gbc);
            ++gbc.gridx;
            gbc.anchor = 512;
            this.installForMe = new JCheckBox();
            this.middle.add((Component)this.installForMe, gbc);
        }
        this.bottom = new JPanel();
        this.bottom.setLayout(new FlowLayout());
        this.install = new JButton(this.isReinstall ? (isUpdate ? Language.INSTANCE.localize("common.update") : Language.INSTANCE.localize("common.reinstall")) : Language.INSTANCE.localize("common.install"));
        this.install.addActionListener(new ActionListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if (!InstanceInstallerDialog.this.isReinstall && !isServer && App.settings.isInstance(InstanceInstallerDialog.this.instanceNameField.getText())) {
                    InstanceInstallerDialog.this.instance = App.settings.getInstanceByName(InstanceInstallerDialog.this.instanceNameField.getText());
                    if (!InstanceInstallerDialog.this.instance.getPackName().equalsIgnoreCase(InstanceInstallerDialog.this.pack.getName())) {
                        JOptionPane.showMessageDialog(App.settings.getParent(), "<html><p align=\"center\">" + Language.INSTANCE.localize("common.error") + "<br/><br/>" + Language.INSTANCE.localizeWithReplace("instance.alreadyinstance", InstanceInstallerDialog.this.instanceNameField.getText() + "<br/><br/>") + "</p></html>", Language.INSTANCE.localize("common.error"), 0);
                        return;
                    }
                    int ret = JOptionPane.showConfirmDialog(App.settings.getParent(), "<html><p align=\"center\">" + Language.INSTANCE.localize("common.error") + "<br/><br/>" + Language.INSTANCE.localizeWithReplace("instance.alreadyinstance1", InstanceInstallerDialog.this.instanceNameField.getText() + "<br/><br/>") + "</p></html>", Language.INSTANCE.localize("common.error"), 0);
                    if (ret != 0) {
                        return;
                    }
                    InstanceInstallerDialog.this.isReinstall = true;
                    if (InstanceInstallerDialog.this.instance == null) {
                        return;
                    }
                } else if (!InstanceInstallerDialog.this.isReinstall && !isServer && InstanceInstallerDialog.this.instanceNameField.getText().replaceAll("[^A-Za-z0-9]", "").length() == 0) {
                    JOptionPane.showMessageDialog(App.settings.getParent(), "<html><p align=\"center\">" + Language.INSTANCE.localize("common.error") + "<br/><br/>" + Language.INSTANCE.localizeWithReplace("instance.invalidname", InstanceInstallerDialog.this.instanceNameField.getText()) + "</p></html>", Language.INSTANCE.localize("common.error"), 0);
                    return;
                }
                final PackVersion version = (PackVersion)InstanceInstallerDialog.this.versionsDropDown.getSelectedItem();
                final JDialog dialog = new JDialog(App.settings.getParent(), (InstanceInstallerDialog.this.isReinstall ? Language.INSTANCE.localize("common.reinstalling") : Language.INSTANCE.localize("common.installing")) + " " + InstanceInstallerDialog.this.pack.getName() + " " + version.getVersion() + (isServer ? " " + Language.INSTANCE.localize("common.server") : ""), Dialog.ModalityType.DOCUMENT_MODAL);
                dialog.setLocationRelativeTo(App.settings.getParent());
                dialog.setSize(300, 100);
                dialog.setResizable(false);
                JPanel topPanel = new JPanel();
                topPanel.setLayout(new BorderLayout());
                final JLabel doing = new JLabel(Language.INSTANCE.localizeWithReplace("instance.startingprocess", InstanceInstallerDialog.this.isReinstall ? Language.INSTANCE.localize("common.reinstall") : Language.INSTANCE.localize("common.install")));
                doing.setHorizontalAlignment(0);
                doing.setVerticalAlignment(1);
                topPanel.add(doing);
                JPanel bottomPanel = new JPanel();
                bottomPanel.setLayout(new BorderLayout());
                InstanceInstallerDialog.this.progressBar = new JProgressBar(0, 100);
                bottomPanel.add((Component)InstanceInstallerDialog.this.progressBar, "North");
                InstanceInstallerDialog.this.progressBar.setIndeterminate(true);
                InstanceInstallerDialog.this.subProgressBar = new JProgressBar(0, 100);
                bottomPanel.add((Component)InstanceInstallerDialog.this.subProgressBar, "South");
                InstanceInstallerDialog.this.subProgressBar.setValue(0);
                InstanceInstallerDialog.this.subProgressBar.setVisible(false);
                dialog.add((Component)topPanel, "Center");
                dialog.add((Component)bottomPanel, "South");
                final InstanceInstaller instanceInstaller = new InstanceInstaller(isServer ? "" : InstanceInstallerDialog.this.instanceNameField.getText(), InstanceInstallerDialog.this.pack, version, InstanceInstallerDialog.this.isReinstall, isServer){

                    @Override
                    protected void done() {
                        String title;
                        String text;
                        int type;
                        Boolean success = false;
                        if (this.isCancelled()) {
                            type = 0;
                            text = InstanceInstallerDialog.this.pack.getName() + " " + version.getVersion() + " " + Language.INSTANCE.localize("common.wasnt") + " " + (InstanceInstallerDialog.this.isReinstall ? Language.INSTANCE.localize("common.reinstalled") : Language.INSTANCE.localize("common.installed")) + "<br/><br/>" + Language.INSTANCE.localize("instance.checkerrorlogs");
                            title = InstanceInstallerDialog.this.pack.getName() + " " + version.getVersion() + " " + Language.INSTANCE.localize("common.not") + " " + (InstanceInstallerDialog.this.isReinstall ? Language.INSTANCE.localize("common.reinstalled") : Language.INSTANCE.localize("common.installed"));
                            if (InstanceInstallerDialog.this.isReinstall && this.shouldCoruptInstance()) {
                                App.settings.setInstanceUnplayable(InstanceInstallerDialog.this.instance);
                            }
                        } else {
                            try {
                                success = (Boolean)this.get();
                            }
                            catch (InterruptedException e) {
                                App.settings.logStackTrace(e);
                            }
                            catch (ExecutionException e) {
                                App.settings.logStackTrace(e);
                            }
                            if (success.booleanValue()) {
                                type = 1;
                                text = InstanceInstallerDialog.this.pack.getName() + " " + version.getVersion() + " " + Language.INSTANCE.localize("common.hasbeen") + " " + (InstanceInstallerDialog.this.isReinstall ? Language.INSTANCE.localize("common.reinstalled") : Language.INSTANCE.localize("common.installed")) + "<br/><br/>" + (isServer ? Language.INSTANCE.localizeWithReplace("instance.finditserver", "<br/><br/>" + this.getRootDirectory().getAbsolutePath()) : Language.INSTANCE.localize("instance.findit"));
                                title = InstanceInstallerDialog.this.pack.getName() + " " + version.getVersion() + " " + Language.INSTANCE.localize("common.installed");
                                if (InstanceInstallerDialog.this.isReinstall) {
                                    InstanceInstallerDialog.this.instance.setVersion(version.getVersion());
                                    InstanceInstallerDialog.this.instance.setMinecraftVersion(version.getMinecraftVersion().getVersion());
                                    InstanceInstallerDialog.this.instance.setModsInstalled(this.getModsInstalled());
                                    InstanceInstallerDialog.this.instance.setJarOrder(this.getJarOrder());
                                    InstanceInstallerDialog.this.instance.setMemory(this.getMemory());
                                    InstanceInstallerDialog.this.instance.setPermgen(this.getPermGen());
                                    InstanceInstallerDialog.this.instance.setIsNewLaunchMethod(!this.isLegacy());
                                    InstanceInstallerDialog.this.instance.setLibrariesNeeded(this.getLibrariesNeeded());
                                    InstanceInstallerDialog.this.instance.setMinecraftArguments(this.getMinecraftArguments());
                                    InstanceInstallerDialog.this.instance.setExtraArguments(this.getExtraArguments());
                                    InstanceInstallerDialog.this.instance.setMainClass(this.getMainClass());
                                    InstanceInstallerDialog.this.instance.setAssets(version.getMinecraftVersion().getMojangVersion().getAssets());
                                    if (version.isDev()) {
                                        InstanceInstallerDialog.this.instance.setDevVersion();
                                        if (version.getHash() != null) {
                                            InstanceInstallerDialog.this.instance.setHash(version.getHash());
                                        }
                                    } else {
                                        InstanceInstallerDialog.this.instance.setNotDevVersion();
                                    }
                                    if (!InstanceInstallerDialog.this.instance.isPlayable()) {
                                        InstanceInstallerDialog.this.instance.setPlayable();
                                    }
                                } else if (!isServer) {
                                    Instance newInstance = new Instance(InstanceInstallerDialog.this.instanceNameField.getText(), InstanceInstallerDialog.this.pack.getName(), InstanceInstallerDialog.this.pack, InstanceInstallerDialog.this.installForMe.isSelected(), version.getVersion(), version.getMinecraftVersion().getVersion(), this.getMemory(), this.getPermGen(), this.getModsInstalled(), this.getJarOrder(), this.getLibrariesNeeded(), this.getExtraArguments(), this.getMinecraftArguments(), this.getMainClass(), version.getMinecraftVersion().getMojangVersion().getAssets(), version.isDev(), !version.getMinecraftVersion().isLegacy());
                                    if (version.isDev() && version.getHash() != null) {
                                        newInstance.setHash(version.getHash());
                                    }
                                    if (InstanceInstallerDialog.this.isCustomPack) {
                                        newInstance.setCustomPack(true);
                                    }
                                    App.settings.getInstances().add(newInstance);
                                }
                                App.settings.saveInstances();
                                App.settings.reloadInstancesPanel();
                                if (InstanceInstallerDialog.this.pack.isLoggingEnabled() && App.settings.enableLogs() && !version.isDev()) {
                                    if (isServer) {
                                        InstanceInstallerDialog.this.pack.addServerInstall(version.getVersion());
                                    } else if (isUpdate) {
                                        InstanceInstallerDialog.this.pack.addUpdate(version.getVersion());
                                    } else {
                                        InstanceInstallerDialog.this.pack.addInstall(version.getVersion());
                                    }
                                }
                            } else if (InstanceInstallerDialog.this.isReinstall) {
                                type = 0;
                                text = InstanceInstallerDialog.this.pack.getName() + " " + version.getVersion() + " " + Language.INSTANCE.localize("common.wasnt") + " " + Language.INSTANCE.localize("common.reinstalled") + "<br/><br/>" + (this.shouldCoruptInstance() ? Language.INSTANCE.localize("instance.nolongerplayable") : "") + "<br/><br/>" + Language.INSTANCE.localize("instance.checkerrorlogs") + "!";
                                title = InstanceInstallerDialog.this.pack.getName() + " " + version.getVersion() + " " + Language.INSTANCE.localize("common.not") + " " + Language.INSTANCE.localize("common.reinstalled");
                                if (this.shouldCoruptInstance()) {
                                    App.settings.setInstanceUnplayable(InstanceInstallerDialog.this.instance);
                                }
                            } else {
                                Utils.delete(this.getRootDirectory());
                                type = 0;
                                text = InstanceInstallerDialog.this.pack.getName() + " " + version.getVersion() + " " + Language.INSTANCE.localize("common.wasnt") + " " + Language.INSTANCE.localize("common.installed") + "<br/><br/>" + Language.INSTANCE.localize("instance.checkerrorlogs") + "!";
                                title = InstanceInstallerDialog.this.pack.getName() + " " + version.getVersion() + " " + Language.INSTANCE.localize("common.not") + " " + Language.INSTANCE.localize("common.installed");
                            }
                        }
                        dialog.dispose();
                        Utils.cleanTempDirectory();
                        JOptionPane.showMessageDialog(App.settings.getParent(), "<html><p align=\"center\">" + text + "</p></html>", title, type);
                    }
                };
                instanceInstaller.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("progress" == evt.getPropertyName()) {
                            int progress;
                            if (InstanceInstallerDialog.this.progressBar.isIndeterminate()) {
                                InstanceInstallerDialog.this.progressBar.setIndeterminate(false);
                            }
                            if ((progress = ((Integer)evt.getNewValue()).intValue()) > 100) {
                                progress = 100;
                            }
                            InstanceInstallerDialog.this.progressBar.setValue(progress);
                        } else if ("subprogress" == evt.getPropertyName()) {
                            int progress;
                            if (!InstanceInstallerDialog.this.subProgressBar.isVisible()) {
                                InstanceInstallerDialog.this.subProgressBar.setVisible(true);
                            }
                            if (InstanceInstallerDialog.this.subProgressBar.isIndeterminate()) {
                                InstanceInstallerDialog.this.subProgressBar.setIndeterminate(false);
                            }
                            String paint = null;
                            if (evt.getNewValue() instanceof Integer) {
                                progress = (Integer)evt.getNewValue();
                            } else {
                                String[] parts = (String[])evt.getNewValue();
                                progress = Integer.parseInt(parts[0]);
                                paint = parts[1];
                            }
                            if (progress >= 100) {
                                progress = 100;
                            }
                            if (progress < 0) {
                                if (InstanceInstallerDialog.this.subProgressBar.isStringPainted()) {
                                    InstanceInstallerDialog.this.subProgressBar.setStringPainted(false);
                                }
                                InstanceInstallerDialog.this.subProgressBar.setVisible(false);
                            } else {
                                if (!InstanceInstallerDialog.this.subProgressBar.isStringPainted()) {
                                    InstanceInstallerDialog.this.subProgressBar.setStringPainted(true);
                                }
                                if (paint != null) {
                                    InstanceInstallerDialog.this.subProgressBar.setString(paint);
                                }
                            }
                            InstanceInstallerDialog.this.subProgressBar.setValue(progress);
                        } else if ("subprogressint" == evt.getPropertyName()) {
                            if (InstanceInstallerDialog.this.subProgressBar.isStringPainted()) {
                                InstanceInstallerDialog.this.subProgressBar.setStringPainted(false);
                            }
                            if (!InstanceInstallerDialog.this.subProgressBar.isVisible()) {
                                InstanceInstallerDialog.this.subProgressBar.setVisible(true);
                            }
                            if (!InstanceInstallerDialog.this.subProgressBar.isIndeterminate()) {
                                InstanceInstallerDialog.this.subProgressBar.setIndeterminate(true);
                            }
                        } else if ("doing" == evt.getPropertyName()) {
                            String doingText = (String)evt.getNewValue();
                            doing.setText(doingText);
                        }
                    }
                });
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        instanceInstaller.cancel(true);
                    }
                });
                if (InstanceInstallerDialog.this.isReinstall) {
                    instanceInstaller.setInstance(InstanceInstallerDialog.this.instance);
                }
                instanceInstaller.execute();
                InstanceInstallerDialog.this.dispose();
                dialog.setVisible(true);
            }
        });
        this.cancel = new JButton(Language.INSTANCE.localize("common.cancel"));
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstanceInstallerDialog.this.dispose();
            }
        });
        this.bottom.add(this.install);
        this.bottom.add(this.cancel);
        this.add((Component)this.top, "North");
        this.add((Component)this.middle, "Center");
        this.add((Component)this.bottom, "South");
        this.setVisible(true);
    }

    public InstanceInstallerDialog(Object object, boolean isUpdate, boolean isServer, String version) {
        this(object, isUpdate, isServer);
        this.versionsDropDown.setSelectedItem(version);
    }

    public InstanceInstallerDialog(Object object, String version) {
        this(object, false, false, version);
    }

    public InstanceInstallerDialog(Pack pack, boolean isServer, String version) {
        this(pack, false, true, version);
    }

    public InstanceInstallerDialog(Object object, String version, boolean isCustom) {
        this(object, false, false, version);
        this.isCustomPack = isCustom;
    }
}

