/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.dialogs;

import com.atlauncher.App;
import com.atlauncher.LogManager;
import com.atlauncher.data.Language;
import com.atlauncher.data.Mod;
import com.atlauncher.gui.components.ModsJCheckBox;
import com.atlauncher.utils.Utils;
import com.atlauncher.workers.InstanceInstaller;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class ModsChooser
extends JDialog {
    private static final long serialVersionUID = -5309108183485463434L;
    private InstanceInstaller installer;
    private JButton selectAllButton;
    private JButton clearAllButton;
    private List<ModsJCheckBox> modCheckboxes;
    private boolean wasClosed = false;

    public ModsChooser(InstanceInstaller installerr) {
        super(App.settings.getParent(), Language.INSTANCE.localize("instance.selectmods"), Dialog.ModalityType.APPLICATION_MODAL);
        this.installer = installerr;
        this.setSize(550, 450);
        this.setIconImage(Utils.getImage("/assets/image/Icon.png"));
        this.setLocationRelativeTo(App.settings.getParent());
        this.setLayout(new BorderLayout());
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                ModsChooser.this.wasClosed = true;
                ModsChooser.this.dispose();
            }
        });
        JSplitPane split = new JSplitPane(0);
        split.setDividerSize(0);
        split.setBorder(null);
        split.setEnabled(false);
        this.add((Component)split, "North");
        JSplitPane labelsTop = new JSplitPane(0);
        labelsTop.setDividerSize(0);
        labelsTop.setBorder(null);
        labelsTop.setEnabled(false);
        split.setLeftComponent(labelsTop);
        JSplitPane labels = new JSplitPane();
        labels.setDividerLocation(275);
        labels.setDividerSize(0);
        labels.setBorder(null);
        labels.setEnabled(false);
        split.setRightComponent(labels);
        JLabel topLabelLeft = new JLabel(Language.INSTANCE.localize("instance.requiredmods"));
        topLabelLeft.setHorizontalAlignment(0);
        labels.setLeftComponent(topLabelLeft);
        JLabel topLabelRight = new JLabel(Language.INSTANCE.localize("instance.optionalmods"));
        topLabelRight.setHorizontalAlignment(0);
        labels.setRightComponent(topLabelRight);
        JSplitPane modsInPack = new JSplitPane();
        modsInPack.setDividerLocation(275);
        modsInPack.setDividerSize(0);
        modsInPack.setBorder(null);
        modsInPack.setEnabled(false);
        this.add((Component)modsInPack, "Center");
        JPanel checkBoxPanel1 = new JPanel();
        checkBoxPanel1.setLayout(null);
        checkBoxPanel1.setBackground(App.THEME.getModSelectionBackgroundColor());
        JScrollPane scroller1 = new JScrollPane(checkBoxPanel1, 22, 31);
        scroller1.getVerticalScrollBar().setUnitIncrement(16);
        scroller1.setPreferredSize(new Dimension(275, 350));
        modsInPack.setRightComponent(scroller1);
        JPanel checkBoxPanel2 = new JPanel();
        checkBoxPanel2.setLayout(null);
        checkBoxPanel2.setBackground(App.THEME.getModSelectionBackgroundColor());
        JScrollPane scroller2 = new JScrollPane(checkBoxPanel2, 22, 31);
        scroller2.getVerticalScrollBar().setUnitIncrement(16);
        scroller2.setPreferredSize(new Dimension(275, 350));
        modsInPack.setLeftComponent(scroller2);
        JPanel bottomPanel = new JPanel();
        this.add((Component)bottomPanel, "South");
        this.selectAllButton = new JButton();
        if (this.installer.hasRecommendedMods()) {
            this.selectAllButton.setText(Language.INSTANCE.localize("instance.selectrecommended"));
        } else {
            this.selectAllButton.setText(Language.INSTANCE.localize("instance.selectall"));
        }
        this.selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ModsJCheckBox check : ModsChooser.this.modCheckboxes) {
                    if (check.isCategory() || !(ModsChooser.this.installer.isServer() ? check.getMod().isServerOptional() : check.getMod().isOptional())) continue;
                    if (check.getMod().isRecommeneded()) {
                        if (check.getMod().hasGroup()) {
                            if (check.getMod().isRecommeneded() && ModsChooser.this.installer.isOnlyRecommendedInGroup(check.getMod())) {
                                check.setSelected(true);
                                check.setEnabled(true);
                                ModsChooser.this.sortOutMods(check);
                                continue;
                            }
                            if (!ModsChooser.this.installer.hasRecommendedMods()) continue;
                            check.setSelected(false);
                            continue;
                        }
                        check.setSelected(true);
                        check.setEnabled(true);
                        ModsChooser.this.sortOutMods(check);
                        continue;
                    }
                    check.setSelected(false);
                }
            }
        });
        bottomPanel.add(this.selectAllButton);
        this.clearAllButton = new JButton(Language.INSTANCE.localize("instance.clearall"));
        this.clearAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ModsJCheckBox check : ModsChooser.this.modCheckboxes) {
                    if (check.isCategory() || !(ModsChooser.this.installer.isServer() ? check.getMod().isServerOptional() : check.getMod().isOptional())) continue;
                    check.setSelected(false);
                    List linkedMods = ModsChooser.this.modsToChange(check.getMod());
                    for (Mod mod : linkedMods) {
                        for (ModsJCheckBox check1 : ModsChooser.this.modCheckboxes) {
                            if (check1.getMod() != mod) continue;
                            check1.setEnabled(false);
                        }
                    }
                }
            }
        });
        bottomPanel.add(this.clearAllButton);
        JButton installButton = new JButton(Language.INSTANCE.localize("common.install"));
        installButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModsChooser.this.dispose();
            }
        });
        bottomPanel.add(installButton);
        this.modCheckboxes = new ArrayList<ModsJCheckBox>();
        ArrayList<String> categoriesDone = new ArrayList<String>();
        int count1 = 0;
        int count2 = 0;
        int i = 0;
        while (i < this.installer.getMods().size()) {
            boolean skip = false;
            final Mod mod = this.installer.getMods().get(i);
            if (this.installer.isServer() && !mod.installOnServer()) continue;
            ModsJCheckBox checkBox = null;
            if (this.installer.isServer() ? mod.isServerOptional() : mod.isOptional()) {
                if (!mod.getCategory().isEmpty() && !categoriesDone.contains(mod.getCategory())) {
                    skip = true;
                    categoriesDone.add(mod.getCategory());
                    checkBox = new ModsJCheckBox(installerr.getCategoryName(mod.getCategory()));
                    checkBox.setBounds(0, count1 * 20, checkBox.getPreferredSize().width, 20);
                    checkBox.setEnabled(false);
                    ++count1;
                }
                if (!skip) {
                    checkBox = new ModsJCheckBox(mod);
                    checkBox.setEnabled(true);
                    if (mod.getLinked().isEmpty()) {
                        checkBox.setBounds(mod.hasCategory() ? 20 : 0, count1 * 20, checkBox.getPreferredSize().width, 20);
                    } else {
                        Mod linkedMod = this.installer.getModByName(mod.getLinked());
                        if (linkedMod == null) {
                            LogManager.error("The mod " + mod.getName() + " tried to reference a linked mod " + mod.getLinked() + " which doesn't exist!");
                            this.installer.cancel(true);
                            return;
                        }
                        if (this.installer.isServer() ? linkedMod.isServerOptional() : linkedMod.isOptional()) {
                            checkBox.setEnabled(false);
                            checkBox.setBounds(mod.hasCategory() ? 40 : 20, count1 * 20, checkBox.getPreferredSize().width, 20);
                        } else {
                            checkBox.setBounds(mod.hasCategory() ? 20 : 0, count1 * 20, checkBox.getPreferredSize().width, 20);
                        }
                        if (mod.isSelected()) {
                            checkBox.setEnabled(true);
                            checkBox.setSelected(true);
                            if (!linkedMod.isSelected()) {
                                boolean needToEnableChildren = false;
                                for (ModsJCheckBox checkbox : this.modCheckboxes) {
                                    if (!checkbox.getMod().getName().equalsIgnoreCase(mod.getLinked())) continue;
                                    checkbox.setSelected(true);
                                    needToEnableChildren = true;
                                    break;
                                }
                                if (needToEnableChildren) {
                                    for (ModsJCheckBox checkbox : this.modCheckboxes) {
                                        if (!checkbox.getMod().getLinked().equalsIgnoreCase(mod.getLinked())) continue;
                                        checkbox.setEnabled(true);
                                    }
                                }
                            }
                        } else if (linkedMod.isSelected()) {
                            checkBox.setEnabled(true);
                        }
                    }
                    if (mod.isHidden() || mod.isLibrary()) {
                        checkBox.setVisible(false);
                    } else {
                        ++count1;
                    }
                }
                if (mod.hasWarning()) {
                    final ModsJCheckBox finalCheckBox = checkBox;
                    checkBox.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            String message;
                            if (finalCheckBox.isSelected() && (message = ModsChooser.this.installer.getPack().getWarningMessage(ModsChooser.this.installer.getVersion().getVersion(), mod.getWarning())) != null) {
                                Object[] options = new String[]{Language.INSTANCE.localize("common.yes"), Language.INSTANCE.localize("common.no")};
                                int ret = JOptionPane.showOptionDialog(App.settings.getParent(), "<html>" + message + "<br/>" + Language.INSTANCE.localize("instance.warningsure") + "</html>", Language.INSTANCE.localize("instance.warning"), -1, 2, null, options, options[1]);
                                if (ret != 0) {
                                    finalCheckBox.setSelected(false);
                                }
                            }
                        }
                    });
                }
            } else {
                checkBox = new ModsJCheckBox(mod);
                checkBox.setBounds(0, count2 * 20, checkBox.getPreferredSize().width, 20);
                checkBox.setSelected(true);
                checkBox.setEnabled(false);
                if (mod.isHidden() || mod.isLibrary()) {
                    checkBox.setVisible(false);
                } else {
                    ++count2;
                }
            }
            if (!checkBox.isCategory()) {
                if (this.installer.isReinstall()) {
                    if (this.installer.wasModInstalled(mod.getName()) && (this.installer.isServer() ? mod.isServerOptional() : mod.isOptional())) {
                        checkBox.setSelected(true);
                        checkBox.setEnabled(true);
                    }
                } else if ((this.installer.isServer() ? mod.isServerOptional() : mod.isOptional()) && mod.isSelected()) {
                    checkBox.setSelected(true);
                    checkBox.setEnabled(true);
                }
                checkBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ModsJCheckBox a = (ModsJCheckBox)e.getSource();
                        ModsChooser.this.sortOutMods(a);
                    }
                });
            }
            this.modCheckboxes.add(checkBox);
            if (skip) continue;
            ++i;
        }
        for (i = 0; i < this.modCheckboxes.size(); ++i) {
            ModsJCheckBox checkBox = this.modCheckboxes.get(i);
            if (checkBox.isCategory()) {
                checkBoxPanel1.add(checkBox);
                continue;
            }
            if (this.installer.isServer() ? checkBox.getMod().isServerOptional() : checkBox.getMod().isOptional()) {
                checkBoxPanel1.add(checkBox);
                continue;
            }
            checkBoxPanel2.add(checkBox);
        }
        checkBoxPanel1.setPreferredSize(new Dimension(0, count1 * 20));
        checkBoxPanel2.setPreferredSize(new Dimension(0, count2 * 20));
    }

    private List<Mod> modsToChange(Mod mod) {
        return this.installer.getLinkedMods(mod);
    }

    private List<Mod> modsInGroup(Mod mod) {
        return this.installer.getGroupedMods(mod);
    }

    private List<Mod> modsDependancies(Mod mod) {
        return this.installer.getModsDependancies(mod);
    }

    private List<Mod> dependedMods(Mod mod) {
        return this.installer.dependedMods(mod);
    }

    private boolean hasADependancy(Mod mod) {
        return this.installer.hasADependancy(mod);
    }

    public void sortOutMods(ModsJCheckBox a) {
        block17: {
            block16: {
                if (!a.isSelected()) break block16;
                List<Mod> linkedMods = this.modsToChange(a.getMod());
                for (Mod mod : linkedMods) {
                    for (ModsJCheckBox check : this.modCheckboxes) {
                        if (check.getMod() != mod) continue;
                        check.setEnabled(true);
                    }
                }
                if (a.getMod().hasGroup()) {
                    List<Mod> groupMods = this.modsInGroup(a.getMod());
                    for (Mod mod : groupMods) {
                        for (ModsJCheckBox check : this.modCheckboxes) {
                            if (check.getMod() != mod) continue;
                            check.setSelected(false);
                        }
                    }
                }
                if (!a.getMod().hasDepends()) break block17;
                List<Mod> dependsMods = this.modsDependancies(a.getMod());
                for (Mod mod : dependsMods) {
                    for (ModsJCheckBox check : this.modCheckboxes) {
                        if (check.getMod() != mod) continue;
                        check.setSelected(true);
                    }
                }
                break block17;
            }
            List<Mod> linkedMods = this.modsToChange(a.getMod());
            for (Mod mod : linkedMods) {
                for (ModsJCheckBox check : this.modCheckboxes) {
                    if (check.getMod() != mod) continue;
                    check.setEnabled(false);
                    check.setSelected(false);
                }
            }
            if (this.hasADependancy(a.getMod())) {
                List<Mod> dependedMods = this.dependedMods(a.getMod());
                for (Mod mod : dependedMods) {
                    for (ModsJCheckBox check : this.modCheckboxes) {
                        if (check.getMod() != mod) continue;
                        check.setSelected(false);
                    }
                }
            } else if (a.getMod().hasDepends()) {
                List<Mod> dependsMods = this.modsDependancies(a.getMod());
                for (Mod mod : dependsMods) {
                    for (ModsJCheckBox check : this.modCheckboxes) {
                        if (check.getMod() != mod || !check.getMod().isLibrary()) continue;
                        check.setSelected(false);
                    }
                }
            }
        }
    }

    public List<Mod> getSelectedMods() {
        if (this.wasClosed) {
            return null;
        }
        ArrayList<Mod> mods = new ArrayList<Mod>();
        for (ModsJCheckBox check : this.modCheckboxes) {
            if (!check.isSelected()) continue;
            mods.add(check.getMod());
        }
        return mods;
    }

    public boolean wasClosed() {
        return this.wasClosed;
    }
}

