/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.dialogs;

import com.atlauncher.App;
import com.atlauncher.LogManager;
import com.atlauncher.data.Language;
import com.atlauncher.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class ProgressDialog
extends JDialog {
    private static final long serialVersionUID = -4665490255300884927L;
    private String labelText;
    private JProgressBar progressBar;
    private int max;
    private Thread thread = null;
    private String closedLogMessage;
    private Object returnValue = null;
    private int tasksToDo;
    private int tasksDone;

    public ProgressDialog(String title, int initMax, String initLabelText, String initClosedLogMessage) {
        super(App.settings.getParent(), Dialog.ModalityType.APPLICATION_MODAL);
        this.labelText = initLabelText;
        this.max = initMax;
        this.closedLogMessage = initClosedLogMessage;
        this.setDefaultCloseOperation(0);
        this.setIconImage(Utils.getImage("/assets/image/Icon.png"));
        this.setSize(300, 80);
        this.setTitle(title);
        this.setLocationRelativeTo(App.settings.getParent());
        this.setLayout(new BorderLayout());
        this.setResizable(false);
        this.progressBar = new JProgressBar();
        if (this.max <= 0) {
            this.progressBar.setIndeterminate(true);
        }
        JLabel label = new JLabel(this.labelText, 0);
        this.add((Component)label, "Center");
        this.add((Component)this.progressBar, "South");
        if (this.closedLogMessage != null) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    LogManager.error(ProgressDialog.this.closedLogMessage);
                    if (ProgressDialog.this.thread != null && ProgressDialog.this.thread.isAlive()) {
                        ProgressDialog.this.thread.interrupt();
                    }
                    ProgressDialog.this.close();
                }
            });
        }
    }

    public void addThread(Thread thread) {
        this.thread = thread;
    }

    public void start() {
        if (this.thread != null) {
            this.thread.start();
        }
        this.setVisible(true);
    }

    public void setTotalTasksToDo(int tasksToDo) {
        this.tasksToDo = tasksToDo;
        this.tasksDone = 0;
        this.progressBar.setString("0/" + this.tasksToDo + " " + Language.INSTANCE.localize("common.tasksdone"));
        this.progressBar.setStringPainted(true);
        this.progressBar.setMaximum(this.tasksToDo);
    }

    public void doneTask() {
        this.progressBar.setString(++this.tasksDone + "/" + this.tasksToDo + " " + Language.INSTANCE.localize("common.tasksdone"));
        this.progressBar.setValue(this.tasksDone);
    }

    public void setReturnValue(Object returnValue) {
        this.returnValue = returnValue;
    }

    public Object getReturnValue() {
        return this.returnValue;
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }
}

