/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.dialogs;

import com.atlauncher.App;
import com.atlauncher.LogManager;
import com.atlauncher.data.Instance;
import com.atlauncher.data.Language;
import com.atlauncher.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RenameInstanceDialog
extends JDialog {
    private JPanel top;
    private JPanel middle;
    private JPanel bottom;
    private JLabel instanceNameLabel;
    private JTextField instanceName;
    private JButton saveButton;

    public RenameInstanceDialog(final Instance instance) {
        super(null, Language.INSTANCE.localize("instance.renaminginstance"), Dialog.ModalityType.APPLICATION_MODAL);
        this.setSize(300, 150);
        this.setLocationRelativeTo(null);
        this.setLayout(new BorderLayout());
        this.setIconImage(Utils.getImage("/assets/image/Icon.png"));
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.top = new JPanel();
        this.top.add(new JLabel(Language.INSTANCE.localize("instance.renaminginstance")));
        this.middle = new JPanel();
        this.middle.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 768;
        this.instanceNameLabel = new JLabel(Language.INSTANCE.localize("instance.name") + ": ");
        this.middle.add((Component)this.instanceNameLabel, gbc);
        ++gbc.gridx;
        gbc.anchor = 512;
        this.instanceName = new JTextField(16);
        this.instanceName.setText(instance.getName());
        this.middle.add((Component)this.instanceName, gbc);
        this.bottom = new JPanel();
        this.bottom.setLayout(new FlowLayout());
        this.saveButton = new JButton(Language.INSTANCE.localize("common.save"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (App.settings.isInstance(RenameInstanceDialog.this.instanceName.getText())) {
                    JOptionPane.showMessageDialog(RenameInstanceDialog.this, Language.INSTANCE.localizeWithReplace("instance.alreadyinstance", RenameInstanceDialog.this.instanceName.getText()), Language.INSTANCE.localize("common.error"), 0);
                } else if (RenameInstanceDialog.this.instanceName.getText().replaceAll("[^A-Za-z0-9]", "").length() == 0) {
                    JOptionPane.showMessageDialog(App.settings.getParent(), "<html><p align=\"center\">" + Language.INSTANCE.localize("common.error") + "<br/><br/>" + Language.INSTANCE.localizeWithReplace("instance.invalidname", RenameInstanceDialog.this.instanceName.getText()) + "</p></html>", Language.INSTANCE.localize("common.error"), 0);
                } else {
                    if (instance.rename(RenameInstanceDialog.this.instanceName.getText())) {
                        App.settings.saveInstances();
                        App.settings.reloadInstancesPanel();
                    } else {
                        LogManager.error("Unknown Error Occured While Renaming Instance!");
                        JOptionPane.showMessageDialog(RenameInstanceDialog.this, "<html><p align=\"center\">" + Language.INSTANCE.localizeWithReplace("instance.errorrenaming", instance.getName() + "<br/><br/>") + "</p></html>", Language.INSTANCE.localize("common.error"), 0);
                    }
                    RenameInstanceDialog.this.close();
                }
            }
        });
        this.bottom.add(this.saveButton);
        this.add((Component)this.top, "North");
        this.add((Component)this.middle, "Center");
        this.add((Component)this.bottom, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                RenameInstanceDialog.this.close();
            }
        });
        this.setVisible(true);
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }
}

