/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.dialogs;

import com.atlauncher.data.Language;
import com.atlauncher.gui.dialogs.AddEditServerForCheckerDialog;
import com.atlauncher.gui.tabs.ServersForCheckerTab;
import com.atlauncher.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ServerListForCheckerDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = -1462218261978353036L;
    private final JTabbedPane TABBED_PANE = new JTabbedPane(1);
    private final JButton ADD_BUTTON = new JButton(Language.INSTANCE.localize("common.add"));
    private final JButton CLOSE_BUTTON = new JButton(Language.INSTANCE.localize("common.close"));
    private final JButton DELETE_BUTTON = new JButton(Language.INSTANCE.localize("common.delete"));
    private final JButton EDIT_BUTTON = new JButton(Language.INSTANCE.localize("common.edit"));
    private final ServersForCheckerTab SERVERS_TAB = new ServersForCheckerTab();
    private final JPanel BOTTOM_PANEL = new JPanel();

    public ServerListForCheckerDialog() {
        super(null, Language.INSTANCE.localize("tools.serverchecker"), Dialog.ModalityType.APPLICATION_MODAL);
        this.setSize(400, 500);
        this.setLocationRelativeTo(null);
        this.setLayout(new BorderLayout());
        this.setIconImage(Utils.getImage("/assets/image/Icon.png"));
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.TABBED_PANE.setBorder(BorderFactory.createBevelBorder(1));
        this.TABBED_PANE.addTab(Language.INSTANCE.localize("tools.serverchecker.servers"), this.SERVERS_TAB);
        this.SERVERS_TAB.addListSelectionListener(this);
        this.ADD_BUTTON.addActionListener(this);
        this.EDIT_BUTTON.addActionListener(this);
        this.EDIT_BUTTON.setEnabled(false);
        this.DELETE_BUTTON.addActionListener(this);
        this.DELETE_BUTTON.setEnabled(false);
        this.CLOSE_BUTTON.addActionListener(this);
        this.BOTTOM_PANEL.setLayout(new FlowLayout());
        this.BOTTOM_PANEL.add(this.ADD_BUTTON);
        this.BOTTOM_PANEL.add(this.EDIT_BUTTON);
        this.BOTTOM_PANEL.add(this.DELETE_BUTTON);
        this.BOTTOM_PANEL.add(this.CLOSE_BUTTON);
        this.add((Component)this.TABBED_PANE, "Center");
        this.add((Component)this.BOTTOM_PANEL, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                ServerListForCheckerDialog.this.close();
            }
        });
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ADD_BUTTON) {
            new AddEditServerForCheckerDialog(null);
            this.SERVERS_TAB.reloadServers();
        } else if (e.getSource() == this.EDIT_BUTTON) {
            this.SERVERS_TAB.editSelectedElement();
        } else if (e.getSource() == this.DELETE_BUTTON) {
            this.SERVERS_TAB.deleteSelectedElement();
        } else if (e.getSource() == this.CLOSE_BUTTON) {
            this.close();
        }
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            JList list = (JList)e.getSource();
            this.EDIT_BUTTON.setEnabled(list.getSelectedIndex() != -1);
            this.DELETE_BUTTON.setEnabled(list.getSelectedIndex() != -1);
        }
    }
}

