/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.dialogs;

import com.atlauncher.App;
import com.atlauncher.data.Language;
import com.atlauncher.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SetupDialog
extends JDialog {
    private static final long serialVersionUID = -2931970914611329658L;
    private JPanel top;
    private JPanel middle;
    private JPanel bottom;
    private JLabel languageLabel;
    private JComboBox<String> language;
    private JLabel enableLeaderboardsLabel;
    private JCheckBox enableLeaderboards;
    private JButton saveButton;

    public SetupDialog() {
        super(null, "ATLauncher Setup", Dialog.ModalityType.APPLICATION_MODAL);
        this.requestFocus();
        this.setSize(400, 200);
        this.setLocationRelativeTo(null);
        this.setLayout(new BorderLayout());
        this.setIconImage(Utils.getImage("/assets/image/Icon.png"));
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.top = new JPanel();
        this.top.add(new JLabel("Setting up ATLauncher"));
        this.middle = new JPanel();
        this.middle.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 768;
        this.languageLabel = new JLabel("Language: ");
        this.middle.add((Component)this.languageLabel, gbc);
        ++gbc.gridx;
        gbc.anchor = 512;
        this.language = new JComboBox<String>(Language.available());
        this.language.setSelectedItem(Language.current());
        this.middle.add(this.language, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.anchor = 768;
        this.enableLeaderboardsLabel = new JLabel("Enable Leaderboards? ");
        this.middle.add((Component)this.enableLeaderboardsLabel, gbc);
        ++gbc.gridx;
        gbc.anchor = 512;
        this.enableLeaderboards = new JCheckBox();
        this.enableLeaderboards.setSelected(true);
        this.middle.add((Component)this.enableLeaderboards, gbc);
        this.bottom = new JPanel();
        this.bottom.setLayout(new FlowLayout());
        this.saveButton = new JButton("Save");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                App.settings.setLanguage((String)SetupDialog.this.language.getSelectedItem());
                App.settings.setEnableLeaderboards(SetupDialog.this.enableLeaderboards.isSelected());
                App.settings.saveProperties();
                SetupDialog.this.setVisible(false);
                SetupDialog.this.dispose();
            }
        });
        this.bottom.add(this.saveButton);
        this.add((Component)this.top, "North");
        this.add((Component)this.middle, "Center");
        this.add((Component)this.bottom, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                System.exit(0);
            }
        });
        App.settings.setLanguage("English");
        App.settings.setEnableLeaderboards(false);
        App.settings.saveProperties();
        this.dispose();
    }
}

