/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.dialogs;

import com.atlauncher.App;
import com.atlauncher.data.Language;
import com.atlauncher.data.Mod;
import com.atlauncher.data.Pack;
import com.atlauncher.gui.card.ModCard;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public final class ViewModsDialog
extends JDialog {
    private final Pack pack;
    private final JPanel contentPanel = new JPanel(new GridBagLayout());
    private final JPanel topPanel = new JPanel(new FlowLayout(0));
    private final JTextField searchField = new JTextField(16);
    private final List<ModCard> cards = new LinkedList<ModCard>();

    public ViewModsDialog(Pack pack) {
        super(App.settings.getParent(), Language.INSTANCE.localizeWithReplace("pack.mods", pack.getName()), Dialog.ModalityType.APPLICATION_MODAL);
        this.pack = pack;
        this.setPreferredSize(new Dimension(550, 450));
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.topPanel.add(new JLabel(Language.INSTANCE.localize("common.search") + ": "));
        this.topPanel.add(this.searchField);
        this.add((Component)this.topPanel, "North");
        this.add((Component)new JScrollPane(this.contentPanel){
            {
                this.getVerticalScrollBar().setUnitIncrement(16);
            }
        }, "Center");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets.set(2, 2, 2, 2);
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                ViewModsDialog.this.reload();
            }
        });
        ArrayList<Mod> mods = this.pack.getMods(this.pack.getLatestVersion().getVersion(), false);
        Collections.sort(mods, new Comparator<Mod>(){

            @Override
            public int compare(Mod o1, Mod o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        for (Mod mod : mods) {
            ModCard card = new ModCard(mod);
            this.cards.add(card);
            this.contentPanel.add((Component)card, gbc);
            ++gbc.gridy;
        }
        this.pack();
        this.setLocationRelativeTo(App.settings.getParent());
    }

    private void reload() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets.set(2, 2, 2, 2);
        this.contentPanel.removeAll();
        for (ModCard card : this.cards) {
            boolean show = true;
            if (!this.searchField.getText().isEmpty() && !Pattern.compile(Pattern.quote(this.searchField.getText()), 2).matcher(card.mod.getName()).find()) {
                show = false;
            }
            if (!show) continue;
            this.contentPanel.add((Component)card, gbc);
            ++gbc.gridy;
        }
        this.revalidate();
        this.repaint();
    }
}

