/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.tabs;

import com.atlauncher.App;
import com.atlauncher.LogManager;
import com.atlauncher.data.Account;
import com.atlauncher.data.Language;
import com.atlauncher.data.LoginResponse;
import com.atlauncher.gui.dialogs.ProgressDialog;
import com.atlauncher.gui.tabs.Tab;
import com.atlauncher.utils.Authentication;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

public class AccountsTab
extends JPanel
implements Tab {
    private static final long serialVersionUID = 2493791137600123223L;
    private final Insets TOP_INSETS = new Insets(0, 0, 20, 0);
    private final Insets BOTTOM_INSETS = new Insets(10, 0, 0, 0);
    private final Insets LABEL_INSETS = new Insets(3, 0, 3, 10);
    private final Insets FIELD_INSETS = new Insets(3, 0, 3, 0);
    private JLabel userSkin;
    private JPanel rightPanel;
    private JPanel topPanel;
    private JComboBox<Account> accountsComboBox;
    private JLabel usernameLabel;
    private JTextField usernameField;
    private JLabel passwordLabel;
    private JPasswordField passwordField;
    private JLabel rememberLabel;
    private JCheckBox rememberField;
    private JPanel buttons;
    private JButton leftButton;
    private JButton rightButton;
    private JPanel bottomPanel;
    private JMenuItem updateSkin;
    private JPopupMenu contextMenu;
    private Account fillerAccount;

    public AccountsTab() {
        this.setLayout(new BorderLayout());
        this.rightPanel = new JPanel();
        this.rightPanel.setLayout(new BorderLayout());
        this.topPanel = new JPanel();
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.insets = this.TOP_INSETS;
        gbc.anchor = 10;
        this.fillerAccount = new Account(Language.INSTANCE.localize("account.add"));
        this.accountsComboBox = new JComboBox();
        this.accountsComboBox.addItem(this.fillerAccount);
        for (Account account : App.settings.getAccounts()) {
            this.accountsComboBox.addItem(account);
        }
        this.accountsComboBox.setSelectedIndex(0);
        this.accountsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Account account = (Account)AccountsTab.this.accountsComboBox.getSelectedItem();
                    if (AccountsTab.this.accountsComboBox.getSelectedIndex() == 0) {
                        AccountsTab.this.usernameField.setText("");
                        AccountsTab.this.passwordField.setText("");
                        AccountsTab.this.rememberField.setSelected(false);
                        AccountsTab.this.leftButton.setText(Language.INSTANCE.localize("common.add"));
                        AccountsTab.this.rightButton.setText(Language.INSTANCE.localize("common.clear"));
                    } else {
                        AccountsTab.this.usernameField.setText(account.getUsername());
                        AccountsTab.this.passwordField.setText(account.getPassword());
                        AccountsTab.this.rememberField.setSelected(account.isRemembered());
                        AccountsTab.this.leftButton.setText(Language.INSTANCE.localize("common.save"));
                        AccountsTab.this.rightButton.setText(Language.INSTANCE.localize("common.delete"));
                    }
                    AccountsTab.this.userSkin.setIcon(account.getMinecraftSkin());
                }
            }
        });
        this.bottomPanel.add(this.accountsComboBox, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.insets = this.LABEL_INSETS;
        gbc.anchor = 768;
        this.usernameLabel = new JLabel(Language.INSTANCE.localize("account.usernameemail") + ":");
        this.bottomPanel.add((Component)this.usernameLabel, gbc);
        ++gbc.gridx;
        gbc.insets = this.FIELD_INSETS;
        gbc.anchor = 512;
        this.usernameField = new JTextField(16);
        this.usernameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AccountsTab.this.leftButtonActions();
                }
            }
        });
        this.bottomPanel.add((Component)this.usernameField, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets = this.LABEL_INSETS;
        gbc.anchor = 768;
        this.passwordLabel = new JLabel(Language.INSTANCE.localize("account.password") + ":");
        this.bottomPanel.add((Component)this.passwordLabel, gbc);
        ++gbc.gridx;
        gbc.insets = this.FIELD_INSETS;
        gbc.anchor = 512;
        this.passwordField = new JPasswordField(16);
        this.passwordField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AccountsTab.this.leftButtonActions();
                }
            }
        });
        this.bottomPanel.add((Component)this.passwordField, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets = this.LABEL_INSETS;
        gbc.anchor = 768;
        this.rememberLabel = new JLabel(Language.INSTANCE.localize("account.remember") + ":");
        this.bottomPanel.add((Component)this.rememberLabel, gbc);
        ++gbc.gridx;
        gbc.insets = this.FIELD_INSETS;
        gbc.anchor = 512;
        this.rememberField = new JCheckBox();
        this.bottomPanel.add((Component)this.rememberField, gbc);
        this.rememberField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AccountsTab.this.rememberField.isSelected()) {
                    Object[] options = new String[]{Language.INSTANCE.localize("common.yes"), Language.INSTANCE.localize("common.no")};
                    int ret = JOptionPane.showOptionDialog(App.settings.getParent(), "<html><p align=\"center\">" + Language.INSTANCE.localizeWithReplace("account.rememberpasswordwarning", "<br/><br/>") + "</p></html>", Language.INSTANCE.localize("account.securitywarningtitle"), -1, 0, null, options, options[0]);
                    if (ret != 0) {
                        AccountsTab.this.rememberField.setSelected(false);
                    }
                }
            }
        });
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.insets = this.BOTTOM_INSETS;
        gbc.anchor = 10;
        this.buttons = new JPanel();
        this.buttons.setLayout(new FlowLayout());
        this.leftButton = new JButton(Language.INSTANCE.localize("common.add"));
        this.leftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccountsTab.this.leftButtonActions();
            }
        });
        this.rightButton = new JButton(Language.INSTANCE.localize("common.clear"));
        this.rightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AccountsTab.this.accountsComboBox.getSelectedIndex() == 0) {
                    AccountsTab.this.usernameField.setText("");
                    AccountsTab.this.passwordField.setText("");
                    AccountsTab.this.rememberField.setSelected(false);
                } else {
                    Account account = (Account)AccountsTab.this.accountsComboBox.getSelectedItem();
                    int res = JOptionPane.showConfirmDialog(App.settings.getParent(), Language.INSTANCE.localizeWithReplace("account.deletesure", AccountsTab.this.usernameField.getText()), Language.INSTANCE.localize("account.delete"), 0);
                    if (res == 0) {
                        App.settings.removeAccount(account);
                        AccountsTab.this.accountsComboBox.removeAllItems();
                        AccountsTab.this.accountsComboBox.addItem(AccountsTab.this.fillerAccount);
                        for (Account accountt : App.settings.getAccounts()) {
                            AccountsTab.this.accountsComboBox.addItem(accountt);
                        }
                        AccountsTab.this.accountsComboBox.setSelectedIndex(0);
                    }
                }
            }
        });
        this.buttons.add(this.leftButton);
        this.buttons.add(this.rightButton);
        this.bottomPanel.add((Component)this.buttons, gbc);
        this.rightPanel.add((Component)this.topPanel, "North");
        this.rightPanel.add((Component)this.bottomPanel, "Center");
        this.contextMenu = new JPopupMenu();
        this.updateSkin = new JMenuItem(Language.INSTANCE.localize("account.reloadskin"));
        this.updateSkin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Account account = (Account)AccountsTab.this.accountsComboBox.getSelectedItem();
                account.updateSkin();
                AccountsTab.this.userSkin.setIcon(account.getMinecraftSkin());
            }
        });
        this.contextMenu.add(this.updateSkin);
        this.userSkin = new JLabel(this.fillerAccount.getMinecraftSkin());
        this.userSkin.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (AccountsTab.this.accountsComboBox.getSelectedItem() != AccountsTab.this.fillerAccount && e.getButton() == 3) {
                    AccountsTab.this.contextMenu.show(AccountsTab.this.userSkin, e.getX(), e.getY());
                }
            }
        });
        this.userSkin.setBorder(BorderFactory.createEmptyBorder(0, 60, 0, 0));
        this.add((Component)this.userSkin, "West");
        this.add((Component)this.rightPanel, "Center");
        this.add((Component)App.settings.bottomBar, "South");
    }

    private void leftButtonActions() {
        if (App.settings.isInOfflineMode()) {
            Object[] options = new String[]{Language.INSTANCE.localize("common.ok")};
            JOptionPane.showOptionDialog(App.settings.getParent(), Language.INSTANCE.localize("account.offlinemode"), Language.INSTANCE.localize("common.offline"), -1, 0, null, options, options[0]);
        } else {
            String username = this.usernameField.getText();
            String password = new String(this.passwordField.getPassword());
            boolean remember = this.rememberField.isSelected();
            if (App.settings.isAccountByName(username) && this.accountsComboBox.getSelectedIndex() == 0) {
                Object[] options = new String[]{Language.INSTANCE.localize("common.ok")};
                JOptionPane.showOptionDialog(App.settings.getParent(), Language.INSTANCE.localize("account.exists"), Language.INSTANCE.localize("account.notadded"), -1, 0, null, options, options[0]);
                return;
            }
            LogManager.info("Logging into Minecraft!");
            final ProgressDialog dialog = new ProgressDialog(Language.INSTANCE.localize("account.loggingin"), 0, Language.INSTANCE.localize("account.loggingin"), "Aborting login for " + this.usernameField.getText());
            dialog.addThread(new Thread(){

                @Override
                public void run() {
                    LoginResponse resp = Authentication.checkAccount(AccountsTab.this.usernameField.getText(), new String(AccountsTab.this.passwordField.getPassword()));
                    dialog.setReturnValue(resp);
                    dialog.close();
                }
            });
            dialog.start();
            LoginResponse response = (LoginResponse)dialog.getReturnValue();
            if (response != null && response.hasAuth() && response.isValidAuth()) {
                Object[] options;
                Account account;
                if (this.accountsComboBox.getSelectedIndex() == 0) {
                    account = new Account(username, password, response.getAuth().getSelectedProfile().getName(), response.getAuth().getSelectedProfile().getId().toString(), remember);
                    App.settings.addAccount(account);
                    LogManager.info("Added Account " + account);
                    options = new String[]{Language.INSTANCE.localize("common.yes"), Language.INSTANCE.localize("common.no")};
                    int ret = JOptionPane.showOptionDialog(App.settings.getParent(), Language.INSTANCE.localize("account.addedswitch"), Language.INSTANCE.localize("account.added"), -1, 1, null, options, options[0]);
                    if (ret == 0) {
                        App.settings.switchAccount(account);
                    }
                } else {
                    account = (Account)this.accountsComboBox.getSelectedItem();
                    account.setUsername(username);
                    account.setMinecraftUsername(response.getAuth().getSelectedProfile().getName());
                    account.setUUID(response.getAuth().getSelectedProfile().getId().toString());
                    if (remember) {
                        account.setPassword(password);
                    }
                    account.setRemember(remember);
                    LogManager.info("Edited Account " + account);
                    options = new String[]{Language.INSTANCE.localize("common.ok")};
                    JOptionPane.showOptionDialog(App.settings.getParent(), Language.INSTANCE.localize("account.editeddone"), Language.INSTANCE.localize("account.edited"), -1, 1, null, options, options[0]);
                }
                response.save();
                App.settings.reloadAccounts();
                this.accountsComboBox.removeAllItems();
                this.accountsComboBox.addItem(this.fillerAccount);
                for (Account accountt : App.settings.getAccounts()) {
                    this.accountsComboBox.addItem(accountt);
                }
                this.accountsComboBox.setSelectedItem(account);
            } else {
                LogManager.error(response.getErrorMessage());
                Object[] options = new String[]{Language.INSTANCE.localize("common.ok")};
                JOptionPane.showOptionDialog(App.settings.getParent(), "<html><p align=\"center\">" + Language.INSTANCE.localize("account.incorrect") + "<br/><br/>" + response.getErrorMessage() + "</p></html>", Language.INSTANCE.localize("account.notadded"), -1, 0, null, options, options[0]);
            }
        }
    }

    @Override
    public String getTitle() {
        return Language.INSTANCE.localize("tabs.accounts");
    }

    @Override
    public String getIcon() {
        return "/assets/image/OldMinecraftIcon.png";
    }
}

