/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.tabs;

import com.atlauncher.App;
import com.atlauncher.data.Instance;
import com.atlauncher.data.Language;
import com.atlauncher.gui.card.InstanceCard;
import com.atlauncher.gui.card.NilCard;
import com.atlauncher.gui.tabs.Tab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class InstancesTab
extends JPanel
implements Tab {
    private static final long serialVersionUID = -969812552965390610L;
    private JPanel topPanel;
    private JButton clearButton;
    private JTextField searchBox;
    private JButton searchButton;
    private JCheckBox hasUpdate;
    private JLabel hasUpdateLabel;
    private String searchText = null;
    private boolean isUpdate = false;
    private JPanel panel;
    private JScrollPane scrollPane;
    private int currentPosition = 0;

    public InstancesTab() {
        this.setLayout(new BorderLayout());
        this.loadContent(false);
    }

    public void loadContent(boolean keepFilters) {
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new FlowLayout(0));
        this.clearButton = new JButton(Language.INSTANCE.localize("common.clear"));
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstancesTab.this.searchBox.setText("");
                InstancesTab.this.hasUpdate.setSelected(false);
                InstancesTab.this.reload();
            }
        });
        this.topPanel.add(this.clearButton);
        this.searchBox = new JTextField(16);
        if (keepFilters) {
            this.searchBox.setText(this.searchText);
        }
        this.searchBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    InstancesTab.this.reload();
                }
            }
        });
        this.topPanel.add(this.searchBox);
        this.searchButton = new JButton(Language.INSTANCE.localize("common.search"));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstancesTab.this.reload();
            }
        });
        this.topPanel.add(this.searchButton);
        this.hasUpdate = new JCheckBox();
        this.hasUpdate.setSelected(this.isUpdate);
        this.hasUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstancesTab.this.reload();
            }
        });
        this.topPanel.add(this.hasUpdate);
        this.hasUpdateLabel = new JLabel(Language.INSTANCE.localize("instance.hasupdate"));
        this.topPanel.add(this.hasUpdateLabel);
        this.add((Component)this.topPanel, "North");
        this.panel = new JPanel();
        this.scrollPane = new JScrollPane(this.panel, 20, 31);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.add((Component)this.scrollPane, "Center");
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        int count = 0;
        for (Instance instance : App.settings.getInstancesSorted()) {
            if (!instance.canPlay()) continue;
            if (keepFilters) {
                boolean showInstance = true;
                if (this.searchText != null && !Pattern.compile(Pattern.quote(this.searchText), 2).matcher(instance.getName()).find()) {
                    showInstance = false;
                }
                if (this.isUpdate && !instance.hasUpdate()) {
                    showInstance = false;
                }
                if (!showInstance) continue;
                this.panel.add((Component)new InstanceCard(instance), gbc);
                ++gbc.gridy;
                ++count;
                continue;
            }
            this.panel.add((Component)new InstanceCard(instance), gbc);
            ++gbc.gridy;
            ++count;
        }
        if (count == 0) {
            this.panel.add((Component)new NilCard(Language.INSTANCE.localizeWithReplace("instance.nodisplay", "\n\n")), gbc);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InstancesTab.this.scrollPane.getVerticalScrollBar().setValue(InstancesTab.this.currentPosition);
            }
        });
    }

    public void reload() {
        this.currentPosition = this.scrollPane.getVerticalScrollBar().getValue();
        this.searchText = this.searchBox.getText();
        this.isUpdate = this.hasUpdate.isSelected();
        if (this.searchText.isEmpty()) {
            this.searchText = null;
        }
        this.removeAll();
        this.loadContent(true);
        this.validate();
        this.repaint();
        this.searchBox.requestFocus();
    }

    @Override
    public String getTitle() {
        return Language.INSTANCE.localize("tabs.instances");
    }

    @Override
    public String getIcon() {
        return "/assets/image/OldMinecraftIcon.png";
    }
}

