/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.tabs;

import com.atlauncher.App;
import com.atlauncher.data.Language;
import com.atlauncher.gui.tabs.Tab;
import com.atlauncher.gui.theme.Theme;
import com.atlauncher.utils.Resources;
import com.atlauncher.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;

public class NewsTab
extends JPanel
implements Tab {
    private static final long serialVersionUID = 4616284541226058793L;
    private final HTMLEditorKit NEWS_KIT = new HTMLEditorKit(){
        {
            this.setStyleSheet(Resources.makeStyleSheet("news"));
        }
    };
    private final ContextMenu NEWS_MENU = new ContextMenu();
    private final JEditorPane NEWS_PANE = new JEditorPane("text/html;charset=UTF-8", ""){
        {
            this.setEditable(false);
            this.setEditorKit(NewsTab.this.NEWS_KIT);
            this.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        Utils.openBrowser(e.getURL());
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (NewsTab.this.NEWS_PANE.getSelectedText() != null && e.getButton() == 3) {
                        NewsTab.this.NEWS_MENU.show(NewsTab.this.NEWS_PANE, e.getX(), e.getY());
                    }
                }
            });
        }
    };

    public NewsTab() {
        super(new BorderLayout());
        this.add((Component)new JScrollPane(this.NEWS_PANE, 20, 31), "Center");
        this.reload();
    }

    public void reload() {
        this.NEWS_PANE.setText("");
        this.NEWS_PANE.setText(App.settings.getNewsHTML());
        this.NEWS_PANE.setCaretPosition(0);
        this.NEWS_PANE.setFont(Theme.DEFAULT_THEME.getDefaultFont());
    }

    @Override
    public String getTitle() {
        return Language.INSTANCE.localize("tabs.news");
    }

    @Override
    public String getIcon() {
        return "/assets/image/OldMinecraftIcon.png";
    }

    private final class ContextMenu
    extends JPopupMenu {
        private final JMenuItem COPY_ITEM = new JMenuItem(Language.INSTANCE.localize("common.copy"));

        public ContextMenu() {
            this.COPY_ITEM.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StringSelection text = new StringSelection(NewsTab.this.NEWS_PANE.getSelectedText());
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(text, null);
                }
            });
        }
    }
}

