/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.tabs;

import com.atlauncher.App;
import com.atlauncher.data.Language;
import com.atlauncher.data.Pack;
import com.atlauncher.evnt.listener.TabChangeListener;
import com.atlauncher.evnt.manager.TabChangeManager;
import com.atlauncher.gui.LauncherFrame;
import com.atlauncher.gui.card.NilCard;
import com.atlauncher.gui.card.PackCard;
import com.atlauncher.gui.dialogs.AddPackDialog;
import com.atlauncher.gui.tabs.Tab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public final class PacksTab
extends JPanel
implements Tab {
    private final JPanel topPanel = new JPanel(new FlowLayout(0));
    private final JPanel contentPanel = new JPanel(new GridBagLayout());
    private final JPanel bottomPanel = new JPanel(new FlowLayout(1));
    private final JButton addButton = new JButton(Language.INSTANCE.localize("pack.addpack"));
    private final JButton clearButton = new JButton(Language.INSTANCE.localize("common.clear"));
    private final JButton expandAllButton = new JButton("Expand All");
    private final JButton collapseAllButton = new JButton("Collapse All");
    private final JTextField searchField = new JTextField(16);
    private final JCheckBox serversBox = new JCheckBox(Language.INSTANCE.localize("pack.cancreateserver"));
    private final JCheckBox privateBox = new JCheckBox(Language.INSTANCE.localize("pack.privatepacksonly"));
    private final JCheckBox searchDescBox = new JCheckBox("Search Description");
    private List<PackCard> cards = new LinkedList<PackCard>();

    public PacksTab() {
        super(new BorderLayout());
        this.topPanel.setLayout(new FlowLayout(0));
        this.contentPanel.setLayout(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(this.contentPanel, 20, 31);
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.add((Component)scrollPane, "Center");
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.bottomPanel, "South");
        this.setupTopPanel();
        this.preload();
        TabChangeManager.addListener(new TabChangeListener(){

            @Override
            public void on() {
                PacksTab.this.searchField.setText("");
                PacksTab.this.serversBox.setSelected(false);
                PacksTab.this.privateBox.setSelected(false);
                PacksTab.this.searchDescBox.setSelected(false);
            }
        });
        this.collapseAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Component comp : PacksTab.this.contentPanel.getComponents()) {
                    if (!(comp instanceof PackCard)) continue;
                    ((PackCard)comp).setCollapsed(true);
                }
            }
        });
        this.expandAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Component comp : PacksTab.this.contentPanel.getComponents()) {
                    if (!(comp instanceof PackCard)) continue;
                    ((PackCard)comp).setCollapsed(false);
                }
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new AddPackDialog();
                PacksTab.this.reload();
            }
        });
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PacksTab.this.searchField.setText("");
                PacksTab.this.searchDescBox.setSelected(false);
                PacksTab.this.serversBox.setSelected(false);
                PacksTab.this.privateBox.setSelected(false);
                PacksTab.this.reload();
            }
        });
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                PacksTab.this.reload();
            }
        });
        this.privateBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PacksTab.this.reload();
            }
        });
        this.serversBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PacksTab.this.reload();
            }
        });
        this.searchDescBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PacksTab.this.reload();
            }
        });
    }

    private void setupTopPanel() {
        this.topPanel.add(this.addButton);
        this.topPanel.add(this.clearButton);
        this.topPanel.add(this.searchField);
        this.topPanel.add(this.serversBox);
        this.topPanel.add(this.privateBox);
        this.topPanel.add(this.searchDescBox);
        this.bottomPanel.add(this.expandAllButton);
        this.bottomPanel.add(this.collapseAllButton);
    }

    private void preload() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        List<Pack> packs = App.settings.sortPacksAlphabetically() ? App.settings.getPacksSortedAlphabetically() : App.settings.getPacksSortedPositionally();
        int count = 0;
        for (Pack pack : packs) {
            if (!pack.canInstall()) continue;
            PackCard card = new PackCard(pack);
            this.cards.add(card);
            this.contentPanel.add((Component)card, gbc);
            ++gbc.gridy;
            ++count;
        }
        if (count == 0) {
            this.contentPanel.add((Component)new NilCard(Language.INSTANCE.localizeWithReplace("pack.nodisplay", "\n\n")), gbc);
        }
    }

    private void load(boolean keep) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        int count = 0;
        for (PackCard card : this.cards) {
            boolean show = true;
            Pack pack = card.getPack();
            if (!keep) continue;
            if (!this.searchField.getText().isEmpty() && !Pattern.compile(Pattern.quote(this.searchField.getText()), 2).matcher(pack.getName()).find()) {
                show = false;
            }
            if (this.searchDescBox.isSelected() && Pattern.compile(Pattern.quote(this.searchField.getText()), 2).matcher(pack.getDescription()).find()) {
                show = true;
            }
            if (this.serversBox.isSelected() && !pack.canCreateServer()) {
                show = false;
            }
            if (this.privateBox.isSelected() && !pack.isPrivate()) {
                show = false;
            }
            if (!show) continue;
            this.contentPanel.add((Component)card, gbc);
            ++gbc.gridy;
            ++count;
        }
        ((LauncherFrame)App.settings.getParent()).updateTitle("Packs - " + count);
        if (count == 0) {
            this.contentPanel.add((Component)new NilCard(Language.INSTANCE.localizeWithReplace("pack.nodisplay", "\n\n")), gbc);
        }
    }

    public void reload() {
        this.contentPanel.removeAll();
        this.load(true);
        this.revalidate();
        this.repaint();
    }

    @Override
    public String getTitle() {
        return Language.INSTANCE.localize("tabs.packs");
    }

    @Override
    public String getIcon() {
        return "/assets/image/OldMinecraftIcon.png";
    }
}

