/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.tabs;

import com.atlauncher.App;
import com.atlauncher.data.Language;
import com.atlauncher.data.MinecraftServer;
import com.atlauncher.gui.dialogs.AddEditServerForCheckerDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ListSelectionListener;

public class ServersForCheckerTab
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 3385411077046354453L;
    private final JPopupMenu CONTEXT_MENU = new JPopupMenu();
    private final JMenuItem EDIT_BUTTON = new JMenuItem(Language.INSTANCE.localize("common.edit"));
    private final JMenuItem DELETE_BUTTON = new JMenuItem(Language.INSTANCE.localize("common.delete"));
    private DefaultListModel<MinecraftServer> listModel;
    private JList serverList;

    public ServersForCheckerTab() {
        this.setLayout(new BorderLayout());
        this.EDIT_BUTTON.addActionListener(this);
        this.DELETE_BUTTON.addActionListener(this);
        this.CONTEXT_MENU.add(this.EDIT_BUTTON);
        this.CONTEXT_MENU.add(this.DELETE_BUTTON);
        this.listModel = new DefaultListModel();
        for (MinecraftServer server : App.settings.getCheckingServers()) {
            this.listModel.addElement(server);
        }
        this.serverList = new JList<MinecraftServer>(this.listModel);
        this.serverList.setSelectionMode(0);
        this.serverList.setSelectionModel(new DefaultListSelectionModel(){
            private static final long serialVersionUID = -88997910673981243L;

            @Override
            public void setSelectionInterval(int index0, int index1) {
                if (index0 == index1 && this.isSelectedIndex(index0)) {
                    this.removeSelectionInterval(index0, index0);
                    return;
                }
                super.setSelectionInterval(index0, index1);
            }

            @Override
            public void addSelectionInterval(int index0, int index1) {
                if (index0 == index1) {
                    if (this.isSelectedIndex(index0)) {
                        this.removeSelectionInterval(index0, index0);
                        return;
                    }
                    super.addSelectionInterval(index0, index1);
                }
            }
        });
        this.serverList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                super.keyTyped(e);
                if (e.getKeyChar() == '\u007f') {
                    ServersForCheckerTab.this.deleteSelectedElement();
                }
            }
        });
        this.serverList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    ServersForCheckerTab.this.CONTEXT_MENU.show(ServersForCheckerTab.this.serverList, e.getX(), e.getY());
                }
            }
        });
        this.add((Component)this.serverList, "Center");
    }

    public void editSelectedElement() {
        if (this.serverList.getSelectedIndex() != -1) {
            new AddEditServerForCheckerDialog((MinecraftServer)this.serverList.getSelectedValue());
            this.reloadServers();
        }
    }

    public void deleteSelectedElement() {
        if (this.serverList.getSelectedIndex() != -1) {
            MinecraftServer selectedValue = (MinecraftServer)this.serverList.getSelectedValue();
            App.settings.removeCheckingServer(selectedValue);
            this.listModel.removeElement(selectedValue);
            this.reloadServers();
        }
    }

    public void reloadServers() {
        this.listModel.removeAllElements();
        for (MinecraftServer server : App.settings.getCheckingServers()) {
            this.listModel.addElement(server);
        }
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.serverList.addListSelectionListener(listener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.EDIT_BUTTON) {
            this.editSelectedElement();
        } else if (e.getSource() == this.DELETE_BUTTON) {
            this.deleteSelectedElement();
        }
    }
}

