/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.tabs;

import com.atlauncher.App;
import com.atlauncher.data.Language;
import com.atlauncher.evnt.listener.RelocalizationListener;
import com.atlauncher.evnt.manager.RelocalizationManager;
import com.atlauncher.evnt.manager.SettingsManager;
import com.atlauncher.gui.tabs.Tab;
import com.atlauncher.gui.tabs.settings.GeneralSettingsTab;
import com.atlauncher.gui.tabs.settings.JavaSettingsTab;
import com.atlauncher.gui.tabs.settings.LoggingSettingsTab;
import com.atlauncher.gui.tabs.settings.NetworkSettingsTab;
import com.atlauncher.gui.tabs.settings.ToolsSettingsTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class SettingsTab
extends JPanel
implements Tab,
RelocalizationListener {
    private final GeneralSettingsTab generalSettingsTab = new GeneralSettingsTab();
    private final JavaSettingsTab javaSettingsTab = new JavaSettingsTab();
    private final NetworkSettingsTab networkSettingsTab = new NetworkSettingsTab();
    private final LoggingSettingsTab loggingSettingsTab = new LoggingSettingsTab();
    private final ToolsSettingsTab toolsSettingsTab = new ToolsSettingsTab();
    private final List<Tab> tabs = Arrays.asList(this.generalSettingsTab, this.javaSettingsTab, this.networkSettingsTab, this.loggingSettingsTab, this.toolsSettingsTab);
    private JTabbedPane tabbedPane;
    private JPanel bottomPanel;
    private JButton saveButton = new JButton(Language.INSTANCE.localize("common.save"));

    public SettingsTab() {
        RelocalizationManager.addListener(this);
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setBackground(App.THEME.getBaseColor());
        this.tabbedPane.setFont(App.THEME.getDefaultFont().deriveFont(17.0f));
        for (Tab tab : this.tabs) {
            this.tabbedPane.addTab(tab.getTitle(), (JPanel)((Object)tab));
        }
        this.tabbedPane.setBackground(App.THEME.getTabBackgroundColor());
        this.tabbedPane.setOpaque(true);
        this.add((Component)this.tabbedPane, "Center");
        this.bottomPanel = new JPanel();
        this.bottomPanel.add(this.saveButton);
        this.add((Component)this.bottomPanel, "South");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (SettingsTab.this.javaSettingsTab.isValidJavaPath() && SettingsTab.this.javaSettingsTab.isValidJavaParamaters() && SettingsTab.this.networkSettingsTab.isValidConcurrentConnections() && SettingsTab.this.networkSettingsTab.isValidProxyPort() && SettingsTab.this.networkSettingsTab.canConnectWithProxy() && SettingsTab.this.toolsSettingsTab.isValidServerCheckerWait()) {
                    boolean reloadTheme = SettingsTab.this.generalSettingsTab.needToReloadTheme();
                    boolean reloadLocalizationTable = SettingsTab.this.generalSettingsTab.reloadLocalizationTable();
                    boolean reloadPacksPanel = SettingsTab.this.generalSettingsTab.needToReloadPacksPanel();
                    boolean restartServerChecker = SettingsTab.this.toolsSettingsTab.needToRestartServerChecker();
                    SettingsTab.this.generalSettingsTab.save();
                    SettingsTab.this.javaSettingsTab.save();
                    SettingsTab.this.networkSettingsTab.save();
                    SettingsTab.this.loggingSettingsTab.save();
                    SettingsTab.this.toolsSettingsTab.save();
                    App.settings.saveProperties();
                    SettingsManager.post();
                    if (reloadLocalizationTable) {
                        RelocalizationManager.post();
                    }
                    if (reloadPacksPanel) {
                        App.settings.reloadPacksPanel();
                    }
                    if (restartServerChecker) {
                        App.settings.startCheckingServers();
                    }
                    if (reloadTheme) {
                        App.settings.restartLauncher();
                    }
                    App.TOASTER.pop("Settings Saved");
                }
            }
        });
    }

    @Override
    public String getTitle() {
        return Language.INSTANCE.localize("tabs.settings");
    }

    @Override
    public String getIcon() {
        return "/assets/image/OldMinecraftIcon.png";
    }

    @Override
    public void onRelocalization() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            this.tabbedPane.setTitleAt(i, this.tabs.get(i).getTitle());
        }
        this.saveButton.setText(Language.INSTANCE.localize("common.save"));
    }
}

