/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.tabs.settings;

import com.atlauncher.App;
import com.atlauncher.data.Language;
import com.atlauncher.evnt.listener.RelocalizationListener;
import com.atlauncher.evnt.manager.RelocalizationManager;
import com.atlauncher.gui.components.JLabelWithHover;
import com.atlauncher.gui.tabs.settings.AbstractSettingsTab;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class GeneralSettingsTab
extends AbstractSettingsTab
implements RelocalizationListener {
    private JLabelWithHover languageLabel;
    private JComboBox<String> language;
    private JLabelWithHover themeLabel;
    private JComboBox<String> theme;
    private JLabelWithHover themeLabelRestart;
    private JPanel themeLabelPanel;
    private JLabelWithHover dateFormatLabel;
    private JComboBox<String> dateFormat;
    private JLabelWithHover advancedBackupLabel;
    private JCheckBox advancedBackup;
    private JLabelWithHover sortPacksAlphabeticallyLabel;
    private JCheckBox sortPacksAlphabetically;
    private JLabelWithHover keepLauncherOpenLabel;
    private JCheckBox keepLauncherOpen;
    private JLabelWithHover enableConsoleLabel;
    private JCheckBox enableConsole;
    private JLabelWithHover enableTrayIconLabel;
    private JCheckBox enableTrayIcon;
    private JLabelWithHover enablePackTagsLabel;
    private JCheckBox enablePackTags;

    public GeneralSettingsTab() {
        RelocalizationManager.addListener(this);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.insets = this.LABEL_INSETS;
        this.gbc.anchor = 768;
        this.languageLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.language") + ":", (Icon)this.HELP_ICON, Language.INSTANCE.localize("settings.languagehelp"));
        this.add((Component)this.languageLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS;
        this.gbc.anchor = 512;
        this.language = new JComboBox<String>(Language.available());
        this.language.setSelectedItem(Language.current());
        this.add(this.language, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = this.LABEL_INSETS;
        this.gbc.anchor = 768;
        this.dateFormatLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.dateformat") + ":", (Icon)this.HELP_ICON, Language.INSTANCE.localize("settings.dateformathelp"));
        this.add((Component)this.dateFormatLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS;
        this.gbc.anchor = 512;
        this.dateFormat = new JComboBox();
        this.dateFormat.addItem("dd/M/yyy");
        this.dateFormat.addItem("M/dd/yyy");
        this.dateFormat.addItem("yyy/M/dd");
        this.dateFormat.setSelectedItem(App.settings.getDateFormat());
        this.add(this.dateFormat, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = this.LABEL_INSETS;
        this.gbc.anchor = 768;
        this.advancedBackupLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.advancedbackup") + "?", (Icon)this.HELP_ICON, "<html>" + Language.INSTANCE.localizeWithReplace("settings.advancedbackuphelp", "<br/>") + "</html>");
        this.add((Component)this.advancedBackupLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS;
        this.gbc.anchor = 512;
        this.advancedBackup = new JCheckBox();
        if (App.settings.isAdvancedBackupsEnabled()) {
            this.advancedBackup.setSelected(true);
        }
        this.add((Component)this.advancedBackup, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = this.LABEL_INSETS;
        this.gbc.anchor = 768;
        this.sortPacksAlphabeticallyLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.sortpacksalphabetically") + "?", (Icon)this.HELP_ICON, Language.INSTANCE.localize("settings.sortpacksalphabeticallyhelp"));
        this.add((Component)this.sortPacksAlphabeticallyLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS;
        this.gbc.anchor = 512;
        this.sortPacksAlphabetically = new JCheckBox();
        if (App.settings.sortPacksAlphabetically()) {
            this.sortPacksAlphabetically.setSelected(true);
        }
        this.add((Component)this.sortPacksAlphabetically, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = this.LABEL_INSETS;
        this.gbc.anchor = 768;
        this.keepLauncherOpenLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.keeplauncheropen") + "?", (Icon)this.HELP_ICON, Language.INSTANCE.localize("settings.keeplauncheropenhelp"));
        this.add((Component)this.keepLauncherOpenLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS;
        this.gbc.anchor = 512;
        this.keepLauncherOpen = new JCheckBox();
        if (App.settings.keepLauncherOpen()) {
            this.keepLauncherOpen.setSelected(true);
        }
        this.add((Component)this.keepLauncherOpen, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = this.LABEL_INSETS;
        this.gbc.anchor = 768;
        this.enableConsoleLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.console") + "?", (Icon)this.HELP_ICON, Language.INSTANCE.localize("settings.consolehelp"));
        this.add((Component)this.enableConsoleLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS;
        this.gbc.anchor = 512;
        this.enableConsole = new JCheckBox();
        if (App.settings.enableConsole()) {
            this.enableConsole.setSelected(true);
        }
        this.add((Component)this.enableConsole, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = this.LABEL_INSETS;
        this.gbc.anchor = 768;
        this.enableTrayIconLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.traymenu") + "?", (Icon)this.HELP_ICON, "<html>" + Language.INSTANCE.localizeWithReplace("settings.traymenuhelp", "<br/>") + "</html>");
        this.add((Component)this.enableTrayIconLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS;
        this.gbc.anchor = 512;
        this.enableTrayIcon = new JCheckBox();
        if (App.settings.enableTrayIcon()) {
            this.enableTrayIcon.setSelected(true);
        }
        this.add((Component)this.enableTrayIcon, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = this.LABEL_INSETS;
        this.gbc.anchor = 768;
        this.enablePackTagsLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.packtags"), (Icon)this.HELP_ICON, Language.INSTANCE.localize("settings.packtagshelp"));
        this.add((Component)this.enablePackTagsLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS;
        this.gbc.anchor = 512;
        this.enablePackTags = new JCheckBox();
        this.enablePackTags.setSelected(App.settings.enabledPackTags());
        this.add((Component)this.enablePackTags, this.gbc);
    }

    public boolean needToReloadTheme() {
        return false;
    }

    public boolean needToReloadPacksPanel() {
        return this.sortPacksAlphabetically.isSelected() != App.settings.sortPacksAlphabetically();
    }

    public boolean reloadLocalizationTable() {
        return !((String)this.language.getSelectedItem()).equalsIgnoreCase(Language.current());
    }

    public void save() {
        App.settings.setLanguage((String)this.language.getSelectedItem());
        App.settings.setDateFormat((String)this.dateFormat.getSelectedItem());
        App.settings.setAdvancedBackups(this.advancedBackup.isSelected());
        App.settings.setSortPacksAlphabetically(this.sortPacksAlphabetically.isSelected());
        App.settings.setKeepLauncherOpen(this.keepLauncherOpen.isSelected());
        App.settings.setEnableConsole(this.enableConsole.isSelected());
        App.settings.setEnableTrayIcon(this.enableTrayIcon.isSelected());
        App.settings.setPackTags(this.enablePackTags.isSelected());
    }

    @Override
    public String getTitle() {
        return Language.INSTANCE.localize("settings.generaltab");
    }

    @Override
    public String getIcon() {
        return null;
    }

    @Override
    public void onRelocalization() {
        this.languageLabel.setText(Language.INSTANCE.localize("settings.language") + ":");
        this.languageLabel.setToolTipText(Language.INSTANCE.localize("settings.languagehelp"));
        this.themeLabelRestart.setToolTipText(Language.INSTANCE.localize("settings.requiresrestart"));
        this.themeLabel.setText(Language.INSTANCE.localize("settings.theme") + ":");
        this.themeLabel.setToolTipText(Language.INSTANCE.localize("settings.themehelp"));
        this.dateFormatLabel.setText(Language.INSTANCE.localize("settings.dateformat") + ":");
        this.dateFormatLabel.setToolTipText(Language.INSTANCE.localize("settings.dateformathelp"));
        this.advancedBackupLabel.setText(Language.INSTANCE.localize("settings.advancedbackup") + "?");
        this.advancedBackupLabel.setToolTipText("<html>" + Language.INSTANCE.localizeWithReplace("settings.advancedbackuphelp", "<br/>") + "</html>");
        this.sortPacksAlphabeticallyLabel.setText(Language.INSTANCE.localize("settings.sortpacksalphabetically") + "?");
        this.sortPacksAlphabeticallyLabel.setToolTipText(Language.INSTANCE.localize("settings.sortpacksalphabeticallyhelp"));
        this.keepLauncherOpenLabel.setText(Language.INSTANCE.localize("settings.keeplauncheropen") + "?");
        this.keepLauncherOpenLabel.setToolTipText(Language.INSTANCE.localize("settings.keeplauncheropenhelp"));
        this.enableConsoleLabel.setText(Language.INSTANCE.localize("settings.console") + "?");
        this.enableConsoleLabel.setToolTipText(Language.INSTANCE.localize("settings.consolehelp"));
        this.enableTrayIconLabel.setText(Language.INSTANCE.localize("settings.traymenu") + "?");
        this.enableTrayIconLabel.setToolTipText("<html>" + Language.INSTANCE.localizeWithReplace("settings.traymenuhelp", "<br/>") + "</html>");
    }
}

