/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.tabs.settings;

import com.atlauncher.App;
import com.atlauncher.data.Language;
import com.atlauncher.evnt.listener.RelocalizationListener;
import com.atlauncher.evnt.manager.RelocalizationManager;
import com.atlauncher.gui.components.JLabelWithHover;
import com.atlauncher.gui.tabs.settings.AbstractSettingsTab;
import com.atlauncher.utils.Utils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JavaSettingsTab
extends AbstractSettingsTab
implements RelocalizationListener {
    private final String[] MEMORY_OPTIONS = Utils.getMemoryOptions();
    private JLabelWithHover initialMemoryLabel;
    private JComboBox<String> initialMemory;
    private JLabelWithHover initialMemoryLabelWarning;
    private JPanel initialMemoryPanel;
    private JLabelWithHover maximumMemoryLabel;
    private JComboBox<String> maximumMemory;
    private JLabelWithHover maximumMemoryLabelWarning;
    private JPanel maximumMemoryPanel;
    private JLabelWithHover permGenLabel;
    private JTextField permGen;
    private JPanel windowSizePanel;
    private JLabelWithHover windowSizeLabel;
    private JTextField widthField;
    private JTextField heightField;
    private JComboBox<String> commonScreenSizes;
    private JPanel javaPathPanel;
    private JLabelWithHover javaPathLabel;
    private JTextField javaPath;
    private JButton javaPathResetButton;
    private JPanel javaParametersPanel;
    private JLabelWithHover javaParametersLabel;
    private JTextField javaParameters;
    private JButton javaParametersResetButton;
    private JLabelWithHover startMinecraftMaximisedLabel;
    private JCheckBox startMinecraftMaximised;
    private JLabelWithHover saveCustomModsLabel;
    private JCheckBox saveCustomMods;

    public JavaSettingsTab() {
        RelocalizationManager.addListener(this);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = this.LABEL_INSETS;
        this.gbc.anchor = 768;
        this.initialMemoryLabelWarning = new JLabelWithHover(this.WARNING_ICON, "<html>" + Utils.splitMultilinedString(Language.INSTANCE.localize("settings.32bitmemorywarning"), 80, "<br/>") + "</html>", this.RESTART_BORDER);
        this.initialMemoryLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.initialmemory") + ":", (Icon)this.HELP_ICON, "<html>" + Utils.splitMultilinedString(Language.INSTANCE.localize("settings.initialmemoryhelp"), 80, "<br/>") + "</html>");
        this.initialMemoryPanel = new JPanel();
        this.initialMemoryPanel.setLayout(new FlowLayout(2, 0, 0));
        if (!Utils.is64Bit()) {
            this.initialMemoryPanel.add(this.initialMemoryLabelWarning);
        }
        this.initialMemoryPanel.add(this.initialMemoryLabel);
        this.add((Component)this.initialMemoryPanel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS;
        this.gbc.anchor = 512;
        this.initialMemory = new JComboBox();
        this.initialMemory.addItem("64 MB");
        this.initialMemory.addItem("128 MB");
        this.initialMemory.addItem("256 MB");
        for (String option : this.MEMORY_OPTIONS) {
            this.initialMemory.addItem(option);
        }
        this.initialMemory.setSelectedItem(App.settings.getInitialMemory() + " MB");
        this.initialMemory.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int maxRam;
                int selectedRam;
                if (e.getStateChange() == 1 && (selectedRam = Integer.parseInt(((String)JavaSettingsTab.this.initialMemory.getSelectedItem()).replace(" MB", ""))) > (maxRam = Integer.parseInt(((String)JavaSettingsTab.this.maximumMemory.getSelectedItem()).replace(" MB", "")))) {
                    JOptionPane.showMessageDialog(App.settings.getParent(), "<html>" + Language.INSTANCE.localizeWithReplace("settings.initialmemorytoohigh", "<br/><br/>") + "</html>", Language.INSTANCE.localize("settings.help"), -1);
                    JavaSettingsTab.this.initialMemory.setSelectedItem("256 MB");
                }
            }
        });
        this.add(this.initialMemory, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = this.LABEL_INSETS;
        this.gbc.anchor = 768;
        this.maximumMemoryLabelWarning = new JLabelWithHover(this.WARNING_ICON, "<html>" + Utils.splitMultilinedString(Language.INSTANCE.localize("settings.32bitmemorywarning"), 80, "<br/>") + "</html>", this.RESTART_BORDER);
        this.maximumMemoryLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.maximummemory") + ":", (Icon)this.HELP_ICON, "<html>" + Utils.splitMultilinedString(Language.INSTANCE.localize("settings.maximummemoryhelp"), 80, "<br/>") + "</html>");
        this.maximumMemoryPanel = new JPanel();
        this.maximumMemoryPanel.setLayout(new FlowLayout(2, 0, 0));
        if (!Utils.is64Bit()) {
            this.maximumMemoryPanel.add(this.maximumMemoryLabelWarning);
        }
        this.maximumMemoryPanel.add(this.maximumMemoryLabel);
        this.add((Component)this.maximumMemoryPanel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS;
        this.gbc.anchor = 512;
        this.maximumMemory = new JComboBox();
        for (String option : this.MEMORY_OPTIONS) {
            this.maximumMemory.addItem(option);
        }
        this.maximumMemory.setSelectedItem(App.settings.getMaximumMemory() + " MB");
        this.maximumMemory.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int selectedRam;
                if (e.getStateChange() == 1 && (selectedRam = Integer.parseInt(((String)JavaSettingsTab.this.maximumMemory.getSelectedItem()).replace(" MB", ""))) > 4096) {
                    JOptionPane.showMessageDialog(App.settings.getParent(), "<html>" + Language.INSTANCE.localizeWithReplace("settings.toomuchramallocated", "<br/><br/>") + "</html>", Language.INSTANCE.localize("settings.help"), -1);
                }
            }
        });
        this.add(this.maximumMemory, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = this.LABEL_INSETS;
        this.gbc.anchor = 768;
        this.permGenLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.permgen") + ":", (Icon)this.HELP_ICON, Language.INSTANCE.localize("settings.permgenhelp"));
        this.add((Component)this.permGenLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS;
        this.gbc.anchor = 512;
        this.permGen = new JTextField(4);
        this.permGen.setText(App.settings.getPermGen() + "");
        this.add((Component)this.permGen, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.gridwidth = 1;
        this.gbc.insets = this.LABEL_INSETS_SMALL;
        this.gbc.anchor = 768;
        this.windowSizeLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.windowsize") + ":", (Icon)this.HELP_ICON, Language.INSTANCE.localize("settings.windowsizehelp"));
        this.add((Component)this.windowSizeLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS_SMALL;
        this.gbc.anchor = 512;
        this.windowSizePanel = new JPanel();
        this.windowSizePanel.setLayout(new FlowLayout(0, 0, 0));
        this.widthField = new JTextField(4);
        this.widthField.setText(App.settings.getWindowWidth() + "");
        this.heightField = new JTextField(4);
        this.heightField.setText(App.settings.getWindowHeight() + "");
        this.commonScreenSizes = new JComboBox();
        this.commonScreenSizes.addItem("Select An Option");
        this.commonScreenSizes.addItem("854x480");
        if (Utils.getMaximumWindowWidth() >= 1280 && Utils.getMaximumWindowHeight() >= 720) {
            this.commonScreenSizes.addItem("1280x720");
        }
        if (Utils.getMaximumWindowWidth() >= 1600 && Utils.getMaximumWindowHeight() >= 900) {
            this.commonScreenSizes.addItem("1600x900");
        }
        if (Utils.getMaximumWindowWidth() >= 1920 && Utils.getMaximumWindowHeight() >= 1080) {
            this.commonScreenSizes.addItem("1920x1080");
        }
        this.commonScreenSizes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selected = (String)JavaSettingsTab.this.commonScreenSizes.getSelectedItem();
                if (selected.contains("x")) {
                    String[] parts = selected.split("x");
                    JavaSettingsTab.this.widthField.setText(parts[0]);
                    JavaSettingsTab.this.heightField.setText(parts[1]);
                }
            }
        });
        this.commonScreenSizes.setPreferredSize(new Dimension(this.commonScreenSizes.getPreferredSize().width + 10, this.commonScreenSizes.getPreferredSize().height));
        this.windowSizePanel.add(this.widthField);
        this.windowSizePanel.add(new JLabel("x"));
        this.windowSizePanel.add(this.heightField);
        this.windowSizePanel.add(this.commonScreenSizes);
        this.add((Component)this.windowSizePanel, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.gridwidth = 1;
        this.gbc.insets = this.LABEL_INSETS_SMALL;
        this.gbc.anchor = 768;
        this.javaPathLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.javapath") + ":", (Icon)this.HELP_ICON, "<html>" + Language.INSTANCE.localizeWithReplace("settings.javapathhelp", "<br/>") + "</html>");
        this.add((Component)this.javaPathLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.LABEL_INSETS_SMALL;
        this.gbc.anchor = 768;
        this.javaPathPanel = new JPanel();
        this.javaPathPanel.setLayout(new FlowLayout(0, 0, 0));
        this.javaPath = new JTextField(20);
        this.javaPath.setText(App.settings.getJavaPath());
        this.javaPathResetButton = new JButton(Language.INSTANCE.localize("settings.javapathreset"));
        this.javaPathResetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaSettingsTab.this.javaPath.setText(Utils.getJavaHome());
            }
        });
        this.javaPathPanel.add(this.javaPath);
        this.javaPathPanel.add(this.javaPathResetButton);
        this.add((Component)this.javaPathPanel, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.gridwidth = 1;
        this.gbc.insets = this.LABEL_INSETS_SMALL;
        this.gbc.anchor = 768;
        this.javaParametersLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.javaparameters") + ":", (Icon)this.HELP_ICON, Language.INSTANCE.localize("settings.javaparametershelp"));
        this.add((Component)this.javaParametersLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.LABEL_INSETS_SMALL;
        this.gbc.anchor = 768;
        this.javaParametersPanel = new JPanel();
        this.javaParametersPanel.setLayout(new FlowLayout(0, 0, 0));
        this.javaParameters = new JTextField(20);
        this.javaParameters.setText(App.settings.getJavaParameters());
        this.javaParametersResetButton = new JButton(Language.INSTANCE.localize("settings.javapathreset"));
        this.javaParametersResetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaSettingsTab.this.javaParameters.setText("");
            }
        });
        this.javaParametersPanel.add(this.javaParameters);
        this.javaParametersPanel.add(this.javaParametersResetButton);
        this.add((Component)this.javaParametersPanel, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = this.LABEL_INSETS;
        this.gbc.anchor = 768;
        this.startMinecraftMaximisedLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.startminecraftmaximised") + "?", (Icon)this.HELP_ICON, Language.INSTANCE.localize("settings.startminecraftmaximisedhelp"));
        this.add((Component)this.startMinecraftMaximisedLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS;
        this.gbc.anchor = 512;
        this.startMinecraftMaximised = new JCheckBox();
        if (App.settings.startMinecraftMaximised()) {
            this.startMinecraftMaximised.setSelected(true);
        }
        this.add((Component)this.startMinecraftMaximised, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = this.LABEL_INSETS;
        this.gbc.anchor = 768;
        this.saveCustomModsLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.savecustommods") + "?", (Icon)this.HELP_ICON, Language.INSTANCE.localize("settings.savecustommodshelp"));
        this.add((Component)this.saveCustomModsLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS;
        this.gbc.anchor = 512;
        this.saveCustomMods = new JCheckBox();
        if (App.settings.saveCustomMods()) {
            this.saveCustomMods.setSelected(true);
        }
        this.add((Component)this.saveCustomMods, this.gbc);
    }

    public boolean isValidJavaPath() {
        File jPath = new File(this.javaPath.getText(), "bin");
        if (!jPath.exists()) {
            JOptionPane.showMessageDialog(App.settings.getParent(), "<html>" + Language.INSTANCE.localizeWithReplace("settings.javapathincorrect", "<br/><br/>") + "</html>", Language.INSTANCE.localize("settings.help"), -1);
            return false;
        }
        return true;
    }

    public boolean isValidJavaParamaters() {
        if (this.javaParameters.getText().contains("-Xms") || this.javaParameters.getText().contains("-Xmx") || this.javaParameters.getText().contains("-XX:PermSize") || this.javaParameters.getText().contains("-XX:MetaspaceSize")) {
            JOptionPane.showMessageDialog(App.settings.getParent(), "<html>" + Language.INSTANCE.localizeWithReplace("settings.javaparametersincorrect", "<br/><br/>") + "</html>", Language.INSTANCE.localize("settings.help"), -1);
            return false;
        }
        return true;
    }

    public void save() {
        App.settings.setInitialMemory(Integer.parseInt(((String)this.initialMemory.getSelectedItem()).replace(" MB", "")));
        App.settings.setMaximumMemory(Integer.parseInt(((String)this.maximumMemory.getSelectedItem()).replace(" MB", "")));
        App.settings.setPermGen(Integer.parseInt(this.permGen.getText().replaceAll("[^0-9]", "")));
        App.settings.setWindowWidth(Integer.parseInt(this.widthField.getText().replaceAll("[^0-9]", "")));
        App.settings.setWindowHeight(Integer.parseInt(this.heightField.getText().replaceAll("[^0-9]", "")));
        App.settings.setJavaPath(this.javaPath.getText());
        App.settings.setJavaParameters(this.javaParameters.getText());
        App.settings.setStartMinecraftMaximised(this.startMinecraftMaximised.isSelected());
        App.settings.setSaveCustomMods(this.saveCustomMods.isSelected());
    }

    @Override
    public String getTitle() {
        return Language.INSTANCE.localize("settings.javatab");
    }

    @Override
    public String getIcon() {
        return null;
    }

    @Override
    public void onRelocalization() {
        this.initialMemoryLabelWarning.setToolTipText("<html>" + Utils.splitMultilinedString(Language.INSTANCE.localize("settings.32bitmemorywarning"), 80, "<br/>") + "</html>");
        this.initialMemoryLabel.setText(Language.INSTANCE.localize("settings.initialmemory") + ":");
        this.initialMemoryLabel.setToolTipText("<html>" + Utils.splitMultilinedString(Language.INSTANCE.localize("settings.initialmemoryhelp"), 80, "<br/>") + "</html>");
        this.maximumMemoryLabelWarning.setToolTipText("<html>" + Utils.splitMultilinedString(Language.INSTANCE.localize("settings.32bitmemorywarning"), 80, "<br/>") + "</html>");
        this.maximumMemoryLabel.setText(Language.INSTANCE.localize("settings.maximummemory") + ":");
        this.maximumMemoryLabel.setToolTipText("<html>" + Utils.splitMultilinedString(Language.INSTANCE.localize("settings.maximummemoryhelp"), 80, "<br/>") + "</html>");
        this.permGenLabel.setText(Language.INSTANCE.localize("settings.permgen") + ":");
        this.permGenLabel.setToolTipText(Language.INSTANCE.localize("settings.permgenhelp"));
        this.windowSizeLabel.setText(Language.INSTANCE.localize("settings.windowsize") + ":");
        this.windowSizeLabel.setToolTipText(Language.INSTANCE.localize("settings.windowsizehelp"));
        this.javaPathLabel.setText(Language.INSTANCE.localize("settings.javapath") + ":");
        this.javaPathLabel.setToolTipText("<html>" + Language.INSTANCE.localizeWithReplace("settings.javapathhelp", "<br/>") + "</html>");
        this.javaPathResetButton.setText(Language.INSTANCE.localize("settings.javapathreset"));
        this.javaParametersLabel.setText(Language.INSTANCE.localize("settings.javaparameters") + ":");
        this.javaParametersLabel.setToolTipText(Language.INSTANCE.localize("settings.javaparametershelp"));
        this.javaParametersResetButton.setText(Language.INSTANCE.localize("settings.javapathreset"));
        this.startMinecraftMaximisedLabel.setText(Language.INSTANCE.localize("settings.startminecraftmaximised") + "?");
        this.startMinecraftMaximisedLabel.setToolTipText(Language.INSTANCE.localize("settings.startminecraftmaximisedhelp"));
        this.saveCustomModsLabel.setText(Language.INSTANCE.localize("settings.savecustommods") + "?");
        this.saveCustomModsLabel.setToolTipText(Language.INSTANCE.localize("settings.savecustommodshelp"));
    }
}

