/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.tabs.settings;

import com.atlauncher.App;
import com.atlauncher.data.Language;
import com.atlauncher.evnt.listener.RelocalizationListener;
import com.atlauncher.evnt.manager.RelocalizationManager;
import com.atlauncher.gui.components.JLabelWithHover;
import com.atlauncher.gui.tabs.settings.AbstractSettingsTab;
import com.atlauncher.utils.Utils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class LoggingSettingsTab
extends AbstractSettingsTab
implements RelocalizationListener {
    private JLabelWithHover forgeLoggingLevelLabel;
    private JComboBox<String> forgeLoggingLevel;
    private JLabelWithHover daysOfLogsToKeepLabel;
    private SpinnerModel daysOfLogsToKeepModel;
    private JSpinner daysOfLogsToKeep;
    private JLabelWithHover enableLeaderboardsLabel;
    private JCheckBox enableLeaderboards;
    private JLabelWithHover enableLoggingLabel;
    private JCheckBox enableLogs;
    private JLabelWithHover enableOpenEyeReportingLabel;
    private JCheckBox enableOpenEyeReporting;

    public LoggingSettingsTab() {
        RelocalizationManager.addListener(this);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = this.LABEL_INSETS;
        this.gbc.anchor = 768;
        this.forgeLoggingLevelLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.forgelogginglevel") + ":", (Icon)this.HELP_ICON, "<html>" + Language.INSTANCE.localizeWithReplace("settings.forgelogginglevelhelp", "<br/><br/>") + "</html>");
        this.add((Component)this.forgeLoggingLevelLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS;
        this.gbc.anchor = 512;
        this.forgeLoggingLevel = new JComboBox();
        this.forgeLoggingLevel.addItem("SEVERE");
        this.forgeLoggingLevel.addItem("WARNING");
        this.forgeLoggingLevel.addItem("INFO");
        this.forgeLoggingLevel.addItem("CONFIG");
        this.forgeLoggingLevel.addItem("FINE");
        this.forgeLoggingLevel.addItem("FINER");
        this.forgeLoggingLevel.addItem("FINEST");
        this.forgeLoggingLevel.setSelectedItem(App.settings.getForgeLoggingLevel());
        this.add(this.forgeLoggingLevel, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = this.LABEL_INSETS;
        this.gbc.anchor = 768;
        this.daysOfLogsToKeepLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.daysoflogstokeep") + ":", (Icon)this.HELP_ICON, Language.INSTANCE.localize("settings.daysoflogstokeephelp"));
        this.add((Component)this.daysOfLogsToKeepLabel, this.gbc);
        this.daysOfLogsToKeepModel = new SpinnerNumberModel(App.settings.getDaysOfLogsToKeep(), 1, 30, 1);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS;
        this.gbc.anchor = 512;
        this.daysOfLogsToKeep = new JSpinner(this.daysOfLogsToKeepModel);
        this.daysOfLogsToKeep.setValue(App.settings.getDaysOfLogsToKeep());
        this.add((Component)this.daysOfLogsToKeep, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = this.LABEL_INSETS;
        this.gbc.anchor = 768;
        this.enableLeaderboardsLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.leaderboards") + "?", (Icon)this.HELP_ICON, Language.INSTANCE.localize("settings.leaderboardshelp"));
        this.add((Component)this.enableLeaderboardsLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS;
        this.gbc.anchor = 512;
        this.enableLeaderboards = new JCheckBox();
        if (App.settings.enableLeaderboards()) {
            this.enableLeaderboards.setSelected(true);
        }
        if (!App.settings.enableLogs()) {
            this.enableLeaderboards.setEnabled(false);
        }
        this.add((Component)this.enableLeaderboards, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = this.LABEL_INSETS;
        this.gbc.anchor = 768;
        this.enableLoggingLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.logging") + "?", (Icon)this.HELP_ICON, "<html>" + Language.INSTANCE.localizeWithReplace("settings.logginghelp", "<br/></html>"));
        this.add((Component)this.enableLoggingLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS;
        this.gbc.anchor = 512;
        this.enableLogs = new JCheckBox();
        this.enableLogs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!LoggingSettingsTab.this.enableLogs.isSelected()) {
                    LoggingSettingsTab.this.enableOpenEyeReporting.setSelected(false);
                    LoggingSettingsTab.this.enableOpenEyeReporting.setEnabled(false);
                    LoggingSettingsTab.this.enableLeaderboards.setSelected(false);
                    LoggingSettingsTab.this.enableLeaderboards.setEnabled(false);
                } else {
                    LoggingSettingsTab.this.enableOpenEyeReporting.setSelected(true);
                    LoggingSettingsTab.this.enableOpenEyeReporting.setEnabled(true);
                    LoggingSettingsTab.this.enableLeaderboards.setSelected(true);
                    LoggingSettingsTab.this.enableLeaderboards.setEnabled(true);
                }
            }
        });
        if (App.settings.enableLogs()) {
            this.enableLogs.setSelected(true);
        }
        this.add((Component)this.enableLogs, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = this.LABEL_INSETS;
        this.gbc.anchor = 768;
        this.enableOpenEyeReportingLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.openeye") + "?", (Icon)this.HELP_ICON, "<html>" + Utils.splitMultilinedString(Language.INSTANCE.localize("settings.openeyehelp"), 80, "<br/>") + "</html>");
        this.add((Component)this.enableOpenEyeReportingLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS;
        this.gbc.anchor = 512;
        this.enableOpenEyeReporting = new JCheckBox();
        if (!App.settings.enableLogs()) {
            this.enableOpenEyeReporting.setEnabled(false);
        }
        if (App.settings.enableOpenEyeReporting()) {
            this.enableOpenEyeReporting.setSelected(true);
        }
        this.add((Component)this.enableOpenEyeReporting, this.gbc);
    }

    public void save() {
        App.settings.setForgeLoggingLevel((String)this.forgeLoggingLevel.getSelectedItem());
        App.settings.setDaysOfLogsToKeep((Integer)this.daysOfLogsToKeep.getValue());
        App.settings.setEnableLeaderboards(this.enableLeaderboards.isSelected());
        App.settings.setEnableLogs(this.enableLogs.isSelected());
        App.settings.setEnableOpenEyeReporting(this.enableOpenEyeReporting.isSelected());
    }

    @Override
    public String getTitle() {
        return Language.INSTANCE.localize("settings.loggingtab");
    }

    @Override
    public String getIcon() {
        return null;
    }

    @Override
    public void onRelocalization() {
        this.forgeLoggingLevelLabel.setText(Language.INSTANCE.localize("settings.forgelogginglevel") + ":");
        this.forgeLoggingLevelLabel.setToolTipText("<html>" + Language.INSTANCE.localizeWithReplace("settings.forgelogginglevelhelp", "<br/><br/>") + "</html>");
        this.daysOfLogsToKeepLabel.setText(Language.INSTANCE.localize("settings.daysoflogstokeep") + "?");
        this.daysOfLogsToKeepLabel.setToolTipText(Language.INSTANCE.localize("settings.daysoflogstokeephelp"));
        this.enableLeaderboardsLabel.setText(Language.INSTANCE.localize("settings.leaderboards") + "?");
        this.enableLeaderboardsLabel.setToolTipText(Language.INSTANCE.localize("settings.leaderboardshelp"));
        this.enableLoggingLabel.setText(Language.INSTANCE.localize("settings.logging") + "?");
        this.enableLoggingLabel.setToolTipText("<html>" + Language.INSTANCE.localizeWithReplace("settings.logginghelp", "<br/></html>"));
        this.enableOpenEyeReportingLabel.setText(Language.INSTANCE.localize("settings.openeye") + "?");
        this.enableOpenEyeReportingLabel.setToolTipText("<html>" + Utils.splitMultilinedString(Language.INSTANCE.localize("settings.openeyehelp"), 80, "<br/>") + "</html>");
    }
}

