/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.tabs.settings;

import com.atlauncher.App;
import com.atlauncher.data.Language;
import com.atlauncher.data.Server;
import com.atlauncher.evnt.listener.RelocalizationListener;
import com.atlauncher.evnt.manager.RelocalizationManager;
import com.atlauncher.gui.components.JLabelWithHover;
import com.atlauncher.gui.dialogs.ProgressDialog;
import com.atlauncher.gui.tabs.settings.AbstractSettingsTab;
import com.atlauncher.utils.Utils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetSocketAddress;
import java.net.Proxy;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class NetworkSettingsTab
extends AbstractSettingsTab
implements RelocalizationListener {
    private JLabelWithHover downloadServerLabel;
    private JComboBox<Server> server;
    private JLabelWithHover concurrentConnectionsLabel;
    private JTextField concurrentConnections;
    private JLabelWithHover enableProxyLabel;
    private JCheckBox enableProxy;
    private JLabelWithHover proxyHostLabel;
    private JTextField proxyHost;
    private JLabelWithHover proxyPortLabel;
    private JTextField proxyPort;
    private JLabelWithHover proxyTypeLabel;
    private JComboBox<String> proxyType;

    public NetworkSettingsTab() {
        RelocalizationManager.addListener(this);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = this.LABEL_INSETS;
        this.gbc.anchor = 768;
        this.downloadServerLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.downloadserver") + ":", (Icon)this.HELP_ICON, Language.INSTANCE.localize("settings.downloadserverhelp"));
        this.add((Component)this.downloadServerLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS;
        this.gbc.anchor = 512;
        this.server = new JComboBox();
        for (Server serverr : App.settings.getServers()) {
            if (!serverr.isUserSelectable()) continue;
            this.server.addItem(serverr);
        }
        this.server.setSelectedItem(App.settings.getOriginalServer());
        this.add(this.server, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = this.LABEL_INSETS;
        this.gbc.anchor = 768;
        this.concurrentConnectionsLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.concurrentconnections") + ":", (Icon)this.HELP_ICON, "<html>" + Language.INSTANCE.localizeWithReplace("settings.concurrentconnectionshelp", "<br/><br/>") + "</html>");
        this.add((Component)this.concurrentConnectionsLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS;
        this.gbc.anchor = 512;
        this.concurrentConnections = new JTextField(4);
        this.concurrentConnections.setText(App.settings.getConcurrentConnections() + "");
        this.add((Component)this.concurrentConnections, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = this.LABEL_INSETS;
        this.gbc.anchor = 768;
        this.enableProxyLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.enableproxy") + "?", (Icon)this.HELP_ICON, Language.INSTANCE.localize("settings.enableproxyhelp"));
        this.add((Component)this.enableProxyLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS;
        this.gbc.anchor = 512;
        this.enableProxy = new JCheckBox();
        if (App.settings.getEnableProxy()) {
            this.enableProxy.setSelected(true);
        }
        this.enableProxy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!NetworkSettingsTab.this.enableProxy.isSelected()) {
                    NetworkSettingsTab.this.proxyHost.setEnabled(false);
                    NetworkSettingsTab.this.proxyPort.setEnabled(false);
                    NetworkSettingsTab.this.proxyType.setEnabled(false);
                } else {
                    NetworkSettingsTab.this.proxyHost.setEnabled(true);
                    NetworkSettingsTab.this.proxyPort.setEnabled(true);
                    NetworkSettingsTab.this.proxyType.setEnabled(true);
                }
            }
        });
        this.add((Component)this.enableProxy, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = this.LABEL_INSETS;
        this.gbc.anchor = 768;
        this.proxyHostLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.proxyhost") + ":", (Icon)this.HELP_ICON, Language.INSTANCE.localize("settings.proxyhosthelp"));
        this.add((Component)this.proxyHostLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS;
        this.gbc.anchor = 512;
        this.proxyHost = new JTextField(20);
        this.proxyHost.setText(App.settings.getProxyHost());
        if (!this.enableProxy.isSelected()) {
            this.proxyHost.setEnabled(false);
        }
        this.add((Component)this.proxyHost, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = this.LABEL_INSETS;
        this.gbc.anchor = 768;
        this.proxyPortLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.proxyport") + ":", (Icon)this.HELP_ICON, Language.INSTANCE.localize("settings.proxyporthelp"));
        this.add((Component)this.proxyPortLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS;
        this.gbc.anchor = 512;
        this.proxyPort = new JTextField(4);
        this.proxyPort.setText((App.settings.getProxyPort() == 0 ? "" : Integer.valueOf(App.settings.getProxyPort())) + "");
        if (!this.enableProxy.isSelected()) {
            this.proxyPort.setEnabled(false);
        }
        this.add((Component)this.proxyPort, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = this.LABEL_INSETS;
        this.gbc.anchor = 768;
        this.proxyTypeLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.proxytype") + ":", (Icon)this.HELP_ICON, Language.INSTANCE.localize("settings.proxytypehelp"));
        this.add((Component)this.proxyTypeLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS;
        this.gbc.anchor = 512;
        this.proxyType = new JComboBox();
        this.proxyType.addItem("HTTP");
        this.proxyType.addItem("SOCKS");
        this.proxyType.addItem("DIRECT");
        this.proxyType.setSelectedItem(App.settings.getProxyType());
        if (!this.enableProxy.isSelected()) {
            this.proxyType.setEnabled(false);
        }
        this.add(this.proxyType, this.gbc);
    }

    public boolean isValidConcurrentConnections() {
        if (Integer.parseInt(this.concurrentConnections.getText().replaceAll("[^0-9]", "")) < 1) {
            JOptionPane.showMessageDialog(App.settings.getParent(), Language.INSTANCE.localize("settings.concurrentconnectionsinvalid"), Language.INSTANCE.localize("settings.help"), -1);
            return false;
        }
        return true;
    }

    public boolean isValidProxyPort() {
        if (!this.enableProxy.isSelected()) {
            return true;
        }
        if (this.proxyPort.getText().isEmpty() || Integer.parseInt(this.proxyPort.getText().replaceAll("[^0-9]", "")) < 1 || Integer.parseInt(this.proxyPort.getText().replaceAll("[^0-9]", "")) > 65535) {
            JOptionPane.showMessageDialog(App.settings.getParent(), Language.INSTANCE.localize("settings.proxyportinvalid"), Language.INSTANCE.localize("settings.help"), -1);
            return false;
        }
        return true;
    }

    public boolean canConnectWithProxy() {
        if (!this.enableProxy.isSelected()) {
            return true;
        }
        Proxy.Type type = null;
        if (this.proxyType.getSelectedItem().equals("HTTP")) {
            type = Proxy.Type.HTTP;
        } else if (this.proxyType.getSelectedItem().equals("SOCKS")) {
            type = Proxy.Type.SOCKS;
        } else if (this.proxyType.getSelectedItem().equals("DIRECT")) {
            type = Proxy.Type.DIRECT;
        }
        if (type == null) {
            return false;
        }
        final Proxy.Type theType = type;
        final ProgressDialog dialog = new ProgressDialog(Language.INSTANCE.localize("settings.checkingproxytitle"), 0, Language.INSTANCE.localize("settings.checkingproxy"), "Cancelled Proxy Test!");
        dialog.addThread(new Thread(){

            @Override
            public void run() {
                dialog.setReturnValue(Utils.testProxy(new Proxy(theType, new InetSocketAddress(NetworkSettingsTab.this.proxyHost.getText(), Integer.parseInt(NetworkSettingsTab.this.proxyPort.getText().replaceAll("[^0-9]", ""))))));
                dialog.close();
            }
        });
        dialog.start();
        if (dialog.getReturnValue() == null) {
            return false;
        }
        if (!((Boolean)dialog.getReturnValue()).booleanValue()) {
            JOptionPane.showMessageDialog(App.settings.getParent(), Language.INSTANCE.localize("settings.proxycannotconnect"), Language.INSTANCE.localize("settings.help"), -1);
            return false;
        }
        return true;
    }

    public void save() {
        App.settings.setServer((Server)this.server.getSelectedItem());
        App.settings.setConcurrentConnections(Integer.parseInt(this.concurrentConnections.getText().replaceAll("[^0-9]", "")));
        App.settings.setEnableProxy(this.enableProxy.isSelected());
        if (this.enableProxy.isSelected()) {
            App.settings.setProxyHost(this.proxyHost.getText());
            App.settings.setProxyPort(Integer.parseInt(this.proxyPort.getText().replaceAll("[^0-9]", "")));
            App.settings.setProxyType((String)this.proxyType.getSelectedItem());
        }
    }

    @Override
    public String getTitle() {
        return Language.INSTANCE.localize("settings.networktab");
    }

    @Override
    public String getIcon() {
        return null;
    }

    @Override
    public void onRelocalization() {
        this.downloadServerLabel.setText(Language.INSTANCE.localize("settings.downloadserver") + ":");
        this.downloadServerLabel.setToolTipText(Language.INSTANCE.localize("settings.downloadserverhelp"));
        this.concurrentConnectionsLabel.setText(Language.INSTANCE.localize("settings.concurrentconnections") + ":");
        this.concurrentConnectionsLabel.setToolTipText("<html>" + Language.INSTANCE.localizeWithReplace("settings.concurrentconnectionshelp", "<br/><br/>") + "</html>");
        this.enableProxyLabel.setText(Language.INSTANCE.localize("settings.enableproxy") + "?");
        this.enableProxyLabel.setToolTipText(Language.INSTANCE.localize("settings.enableproxyhelp"));
        this.proxyHostLabel.setText(Language.INSTANCE.localize("settings.proxyhost") + ":");
        this.proxyHostLabel.setToolTipText(Language.INSTANCE.localize("settings.proxyhosthelp"));
        this.proxyPortLabel.setText(Language.INSTANCE.localize("settings.proxyport") + ":");
        this.proxyPortLabel.setToolTipText(Language.INSTANCE.localize("settings.proxyporthelp"));
        this.proxyTypeLabel.setText(Language.INSTANCE.localize("settings.proxytype") + ":");
        this.proxyTypeLabel.setToolTipText(Language.INSTANCE.localize("settings.proxytypehelp"));
    }
}

