/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.tabs.settings;

import com.atlauncher.App;
import com.atlauncher.data.Language;
import com.atlauncher.evnt.listener.RelocalizationListener;
import com.atlauncher.evnt.manager.RelocalizationManager;
import com.atlauncher.gui.components.JLabelWithHover;
import com.atlauncher.gui.tabs.settings.AbstractSettingsTab;
import com.atlauncher.utils.Utils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class ToolsSettingsTab
extends AbstractSettingsTab
implements RelocalizationListener {
    private JLabelWithHover enableServerCheckerLabel;
    private JCheckBox enableServerChecker;
    private JLabelWithHover serverCheckerWaitLabel;
    private JTextField serverCheckerWait;

    public ToolsSettingsTab() {
        RelocalizationManager.addListener(this);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.insets = this.LABEL_INSETS;
        this.gbc.anchor = 768;
        this.enableServerCheckerLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.serverchecker") + "?", (Icon)this.HELP_ICON, "<html>" + Language.INSTANCE.localizeWithReplace("settings.servercheckerhelp", "<br/></html>"));
        this.add((Component)this.enableServerCheckerLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS;
        this.gbc.anchor = 512;
        this.enableServerChecker = new JCheckBox();
        if (App.settings.enableServerChecker()) {
            this.enableServerChecker.setSelected(true);
        }
        this.enableServerChecker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ToolsSettingsTab.this.enableServerChecker.isSelected()) {
                    ToolsSettingsTab.this.serverCheckerWait.setEnabled(false);
                } else {
                    ToolsSettingsTab.this.serverCheckerWait.setEnabled(true);
                }
            }
        });
        this.add((Component)this.enableServerChecker, this.gbc);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.gbc.insets = this.LABEL_INSETS;
        this.gbc.anchor = 768;
        this.serverCheckerWaitLabel = new JLabelWithHover(Language.INSTANCE.localize("settings.servercheckerwait") + ":", (Icon)this.HELP_ICON, "<html>" + Utils.splitMultilinedString(Language.INSTANCE.localize("settings.servercheckerwaithelp"), 75, "<br/>") + "</html>");
        this.add((Component)this.serverCheckerWaitLabel, this.gbc);
        ++this.gbc.gridx;
        this.gbc.insets = this.FIELD_INSETS;
        this.gbc.anchor = 512;
        this.serverCheckerWait = new JTextField(4);
        this.serverCheckerWait.setText(App.settings.getServerCheckerWait() + "");
        if (!App.settings.enableServerChecker()) {
            this.serverCheckerWait.setEnabled(false);
        }
        this.add((Component)this.serverCheckerWait, this.gbc);
    }

    public boolean isValidServerCheckerWait() {
        if (Integer.parseInt(this.serverCheckerWait.getText().replaceAll("[^0-9]", "")) < 1 || Integer.parseInt(this.serverCheckerWait.getText().replaceAll("[^0-9]", "")) > 30) {
            JOptionPane.showMessageDialog(App.settings.getParent(), Language.INSTANCE.localize("settings.servercheckerwaitinvalid"), Language.INSTANCE.localize("settings.help"), -1);
            return false;
        }
        return true;
    }

    public boolean needToRestartServerChecker() {
        return this.enableServerChecker.isSelected() != App.settings.enableServerChecker() || App.settings.getServerCheckerWait() != Integer.parseInt(this.serverCheckerWait.getText().replaceAll("[^0-9]", ""));
    }

    public void save() {
        App.settings.setEnableServerChecker(this.enableServerChecker.isSelected());
        App.settings.setServerCheckerWait(Integer.parseInt(this.serverCheckerWait.getText().replaceAll("[^0-9]", "")));
    }

    @Override
    public String getTitle() {
        return Language.INSTANCE.localize("tabs.tools");
    }

    @Override
    public String getIcon() {
        return null;
    }

    @Override
    public void onRelocalization() {
        this.enableServerCheckerLabel.setText(Language.INSTANCE.localize("settings.serverchecker") + "?");
        this.enableServerCheckerLabel.setToolTipText("<html>" + Language.INSTANCE.localizeWithReplace("settings.servercheckerhelp", "<br/></html>"));
        this.serverCheckerWaitLabel.setText(Language.INSTANCE.localize("settings.servercheckerwait") + ":");
        this.serverCheckerWaitLabel.setToolTipText("<html>" + Utils.splitMultilinedString(Language.INSTANCE.localize("settings.servercheckerwaithelp"), 75, "<br/>") + "</html>");
    }
}

