/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.utils;

import de.zh32.pingtest.QueryVersion;
import de.zh32.pingtest.ServerListPing14;
import de.zh32.pingtest.ServerListPing16;
import de.zh32.pingtest.ServerListPing17;
import de.zh32.pingtest.ServerListPingB18;
import java.net.InetSocketAddress;

public class MCQuery {
    public static QueryVersion getMinecraftServerQueryVersion(String host, int port) {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(host, port);
        try {
            ServerListPing16 ping16 = new ServerListPing16();
            ping16.setAddress(inetSocketAddress);
            ping16.fetchData();
            return QueryVersion.mc16;
        }
        catch (Exception ex) {
            try {
                ServerListPing14 ping14 = new ServerListPing14();
                ping14.setAddress(inetSocketAddress);
                ping14.fetchData();
                return QueryVersion.mc14;
            }
            catch (Exception ex2) {
                try {
                    ServerListPingB18 pingb18 = new ServerListPingB18();
                    pingb18.setAddress(inetSocketAddress);
                    pingb18.fetchData();
                    return QueryVersion.mc18b;
                }
                catch (Exception ex3) {
                    try {
                        ServerListPing17 ping17 = new ServerListPing17();
                        ping17.setAddress(inetSocketAddress);
                        ping17.fetchData();
                        return QueryVersion.mc17;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            }
        }
    }

    public static int getNumberOfPlayers(String host, int port, QueryVersion qv) {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(host, port);
        switch (qv) {
            case mc14: {
                try {
                    ServerListPing14 ping14 = new ServerListPing14();
                    ping14.setAddress(inetSocketAddress);
                    ping14.fetchData();
                    return ping14.getPlayersOnline();
                }
                catch (Exception ex) {
                    return -1;
                }
            }
            case mc16: {
                try {
                    ServerListPing16 ping16 = new ServerListPing16();
                    ping16.setAddress(inetSocketAddress);
                    ping16.fetchData();
                    return ping16.getPlayersOnline();
                }
                catch (Exception ex) {
                    return -1;
                }
            }
            case mc17: {
                try {
                    ServerListPing17 ping17 = new ServerListPing17();
                    ping17.setAddress(inetSocketAddress);
                    ServerListPing17.StatusResponse response = ping17.fetchData();
                    return response.getPlayers().getOnline();
                }
                catch (Exception ex) {
                    return -1;
                }
            }
            case mc18b: {
                try {
                    ServerListPingB18 pingb18 = new ServerListPingB18();
                    pingb18.setAddress(inetSocketAddress);
                    pingb18.fetchData();
                    return pingb18.getPlayersOnline();
                }
                catch (Exception ex) {
                    return -1;
                }
            }
        }
        return -1;
    }
}

