/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.utils;

import com.atlauncher.App;
import com.atlauncher.LogManager;
import com.atlauncher.exceptions.ChunkyException;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.text.html.StyleSheet;

public final class Resources {
    private static final Map<String, Object> resources = new HashMap<String, Object>();
    public static final String[] FONT_FAMILIES = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();

    private Resources() {
    }

    public static boolean isSystemFont(String name) {
        for (String str : FONT_FAMILIES) {
            if (!str.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static StyleSheet makeStyleSheet(String name) {
        try {
            if (resources.containsKey(name)) {
                Object obj = resources.get(name);
                if (!(obj instanceof StyleSheet)) {
                    throw new ChunkyException("Reference for " + name + " ended up with a bad value, " + "suggested=" + StyleSheet.class.getName() + "; got=" + obj.getClass().getName());
                }
                return (StyleSheet)obj;
            }
            StyleSheet sheet = new StyleSheet();
            File themeFile = App.settings.getThemeFile();
            if (themeFile != null) {
                InputStream stream = null;
                ZipFile zipFile = new ZipFile(themeFile);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().equals("css/" + name + ".css")) continue;
                    stream = zipFile.getInputStream(entry);
                    break;
                }
                if (stream != null) {
                    InputStreamReader reader = new InputStreamReader(stream);
                    sheet.loadRules(reader, null);
                    ((Reader)reader).close();
                    stream.close();
                    zipFile.close();
                    resources.put(name, sheet);
                    return sheet;
                }
                zipFile.close();
            }
            InputStreamReader reader = new InputStreamReader(System.class.getResourceAsStream("/assets/css/" + name + ".css"));
            sheet.loadRules(reader, null);
            ((Reader)reader).close();
            resources.put(name, sheet);
            return sheet;
        }
        catch (Exception ex) {
            throw new ChunkyException(ex);
        }
    }

    public static Font makeFont(String name) {
        try {
            if (resources.containsKey(name)) {
                Object obj = resources.get(name);
                if (!(obj instanceof Font)) {
                    throw new ChunkyException("Reference for " + name + " ended up with a bad value, " + "suggested=" + Font.class.getName() + "; got=" + obj.getClass().getName());
                }
                return (Font)obj;
            }
            if (Resources.isSystemFont(name)) {
                Font f = new Font(name, 0, 0);
                resources.put(name, f);
                return f;
            }
            URL url = System.class.getResource("/assets/font/" + name + ".ttf");
            if (url == null) {
                File themeFile = App.settings.getThemeFile();
                if (themeFile != null) {
                    InputStream stream = null;
                    ZipFile zipFile = new ZipFile(themeFile);
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (!entry.getName().equals("font/" + name + ".ttf")) continue;
                        stream = zipFile.getInputStream(entry);
                        break;
                    }
                    if (stream != null) {
                        Font f = Font.createFont(0, stream);
                        resources.put(name, f);
                        stream.close();
                        zipFile.close();
                        resources.put(name, f);
                        return f;
                    }
                    zipFile.close();
                }
                LogManager.error("Cannot find font " + name);
                return new Font("Sans-Serif", 0, 0);
            }
            Font f = Font.createFont(0, url.openStream());
            resources.put(name, f);
            return f;
        }
        catch (Exception ex) {
            App.settings.logStackTrace("Cannot find font " + name, ex);
            return new Font("Sans-Serif", 0, 0);
        }
    }
}

