/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.utils;

import com.atlauncher.App;
import com.atlauncher.LogManager;
import com.atlauncher.data.Settings;
import com.atlauncher.data.mojang.ExtractRule;
import com.atlauncher.data.mojang.OperatingSystem;
import com.atlauncher.data.openmods.OpenEyeReportResponse;
import com.atlauncher.evnt.LogEvent;
import com.atlauncher.utils.Base64;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;
import javax.imageio.ImageIO;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.ImageIcon;
import org.tukaani.xz.XZInputStream;

public class Utils {
    public static String error(Throwable t) {
        StringBuilder builder = new StringBuilder();
        builder.append(t.toString()).append("\n");
        StackTraceElement[] elements = t.getStackTrace();
        for (int i = 0; i < elements.length; ++i) {
            builder.append("\t").append(elements[i].toString());
            if (i >= elements.length - 1) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    public static ImageIcon getIconImage(String path) {
        try {
            URL url;
            File themeFile = App.settings.getThemeFile();
            if (themeFile != null) {
                InputStream stream = null;
                ZipFile zipFile = new ZipFile(themeFile);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().equals("image/" + path.substring(path.lastIndexOf(47) + 1))) continue;
                    stream = zipFile.getInputStream(entry);
                    break;
                }
                if (stream != null) {
                    BufferedImage image = ImageIO.read(stream);
                    stream.close();
                    zipFile.close();
                    return new ImageIcon(image);
                }
                zipFile.close();
            }
            if ((url = System.class.getResource(path)) == null) {
                LogManager.error("Unable to load resource " + path);
                return null;
            }
            return new ImageIcon(url);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return null;
        }
    }

    public static File getCoreGracefully() {
        if (Utils.isLinux()) {
            try {
                return new File(App.class.getProtectionDomain().getCodeSource().getLocation().toURI().getSchemeSpecificPart()).getParentFile();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return new File(System.getProperty("user.dir"), "ATLauncher");
            }
        }
        return new File(System.getProperty("user.dir"));
    }

    public static ImageIcon getIconImage(File file) {
        if (!file.exists()) {
            LogManager.error("Unable to load file " + file.getAbsolutePath());
            return null;
        }
        return new ImageIcon(file.getAbsolutePath());
    }

    public static Font getFont() {
        if (Utils.isMac()) {
            return new Font("SansSerif", 0, 11);
        }
        return new Font("SansSerif", 0, 12);
    }

    public static BufferedImage getImage(String img) {
        try {
            InputStream stream;
            File themeFile;
            String name = !img.startsWith("/assets/image/") ? "/assets/image/" + img : img;
            if (!name.endsWith(".png")) {
                name = name + ".png";
            }
            if ((themeFile = App.settings.getThemeFile()) != null) {
                stream = null;
                ZipFile zipFile = new ZipFile(themeFile);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().equals("image/" + name.substring(name.lastIndexOf(47) + 1))) continue;
                    stream = zipFile.getInputStream(entry);
                    break;
                }
                if (stream != null) {
                    BufferedImage image = ImageIO.read(stream);
                    stream.close();
                    zipFile.close();
                    return image;
                }
                zipFile.close();
            }
            if ((stream = App.class.getResourceAsStream(name)) == null) {
                throw new NullPointerException("Stream == null");
            }
            return ImageIO.read(stream);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return null;
        }
    }

    public static void openExplorer(File file) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().open(file);
            }
            catch (Exception e) {
                App.settings.logStackTrace(e);
            }
        }
    }

    public static void openBrowser(String URL2) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(new URI(URL2));
            }
            catch (Exception e) {
                LogManager.error("Failed to open link " + URL2 + " in browser!");
                App.settings.logStackTrace(e);
            }
        }
    }

    public static void openBrowser(URL URL2) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(URL2.toURI());
            }
            catch (Exception e) {
                LogManager.error("Failed to open link " + URL2 + " in browser!");
                App.settings.logStackTrace(e);
            }
        }
    }

    public static String osSlash() {
        if (Utils.isWindows()) {
            return "\\";
        }
        return "/";
    }

    public static String osDelimiter() {
        if (Utils.isWindows()) {
            return ";";
        }
        return ":";
    }

    public static String getJavaHome() {
        return System.getProperty("java.home");
    }

    public static String getJavaVersion() {
        return System.getProperty("java.runtime.version");
    }

    public static boolean isWindows() {
        return OperatingSystem.getOS() == OperatingSystem.WINDOWS;
    }

    public static boolean isMac() {
        return OperatingSystem.getOS() == OperatingSystem.OSX;
    }

    public static boolean isLinux() {
        return OperatingSystem.getOS() == OperatingSystem.LINUX;
    }

    public static boolean is64Bit() {
        return System.getProperty("sun.arch.data.model").contains("64");
    }

    public static String getArch() {
        if (Utils.is64Bit()) {
            return "64";
        }
        return "32";
    }

    public static String[] getMemoryOptions() {
        int options = Utils.getMaximumRam() / 512;
        int ramLeft = 0;
        int count = 0;
        String[] ramOptions = new String[options];
        while (ramLeft + 512 <= Utils.getMaximumRam()) {
            ramOptions[count] = (ramLeft += 512) + " MB";
            ++count;
        }
        return ramOptions;
    }

    public static int getSystemRam() {
        long ramm = 0L;
        int ram = 0;
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        try {
            Method m = operatingSystemMXBean.getClass().getDeclaredMethod("getTotalPhysicalMemorySize", new Class[0]);
            m.setAccessible(true);
            Object value = m.invoke((Object)operatingSystemMXBean, new Object[0]);
            if (value != null) {
                ramm = Long.parseLong(value.toString());
                ram = (int)(ramm / 0x100000L);
            } else {
                ram = 1024;
            }
        }
        catch (SecurityException e) {
            App.settings.logStackTrace(e);
        }
        catch (NoSuchMethodException e) {
            App.settings.logStackTrace(e);
        }
        catch (IllegalArgumentException e) {
            App.settings.logStackTrace(e);
        }
        catch (IllegalAccessException e) {
            App.settings.logStackTrace(e);
        }
        catch (InvocationTargetException e) {
            App.settings.logStackTrace(e);
        }
        return ram;
    }

    public static int getMaximumRam() {
        int maxRam = Utils.getSystemRam();
        if (!Utils.is64Bit()) {
            if (maxRam < 1024) {
                return maxRam;
            }
            return 1024;
        }
        return maxRam;
    }

    public static int getSafeMaximumRam() {
        int maxRam = Utils.getSystemRam();
        if (!Utils.is64Bit()) {
            if (maxRam < 1024) {
                return maxRam / 2;
            }
            return 512;
        }
        return maxRam / 2;
    }

    public static int getMaximumWindowWidth() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dim = toolkit.getScreenSize();
        return dim.width;
    }

    public static int getMaximumWindowHeight() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dim = toolkit.getScreenSize();
        return dim.height;
    }

    public static String uploadPaste(String title, String log) {
        String line = "";
        String result = "";
        try {
            String urlParameters = "";
            urlParameters = urlParameters + "title=" + URLEncoder.encode(title, "ISO-8859-1") + "&";
            urlParameters = urlParameters + "language=" + URLEncoder.encode("text", "ISO-8859-1") + "&";
            urlParameters = urlParameters + "private=" + URLEncoder.encode("1", "ISO-8859-1") + "&";
            urlParameters = urlParameters + "text=" + URLEncoder.encode(log, "ISO-8859-1");
            URL url = new URL("http://rushmead.playat.ch/stikket/api/create");
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
            writer.write(urlParameters);
            writer.flush();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = reader.readLine()) != null) {
                result = line;
            }
            writer.close();
            reader.close();
        }
        catch (IOException e1) {
            App.settings.logStackTrace(e1);
        }
        return result;
    }

    public static String getMD5(File file) {
        if (!file.exists()) {
            LogManager.error("Cannot get MD5 of " + file.getAbsolutePath() + " as it doesn't exist");
            return "0";
        }
        StringBuffer sb = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            FileInputStream fis = new FileInputStream(file);
            byte[] dataBytes = new byte[1024];
            int nread = 0;
            while ((nread = fis.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
            byte[] mdbytes = md.digest();
            sb = new StringBuffer();
            for (int i = 0; i < mdbytes.length; ++i) {
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
            if (fis != null) {
                fis.close();
            }
        }
        catch (NoSuchAlgorithmException e) {
            App.settings.logStackTrace(e);
        }
        catch (FileNotFoundException e) {
            App.settings.logStackTrace(e);
        }
        catch (IOException e) {
            App.settings.logStackTrace(e);
        }
        return sb.toString();
    }

    public static String getSHA1(File file) {
        if (!file.exists()) {
            LogManager.error("Cannot get SHA-1 hash of " + file.getAbsolutePath() + " as it doesn't exist");
            return "0";
        }
        StringBuffer sb = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            FileInputStream fis = new FileInputStream(file);
            byte[] dataBytes = new byte[1024];
            int nread = 0;
            while ((nread = fis.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
            byte[] mdbytes = md.digest();
            sb = new StringBuffer();
            for (int i = 0; i < mdbytes.length; ++i) {
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
            if (fis != null) {
                fis.close();
            }
        }
        catch (NoSuchAlgorithmException e) {
            App.settings.logStackTrace(e);
        }
        catch (FileNotFoundException e) {
            App.settings.logStackTrace(e);
        }
        catch (IOException e) {
            App.settings.logStackTrace(e);
        }
        return sb.toString();
    }

    public static String getMD5(String string) {
        if (string == null) {
            LogManager.error("Cannot get MD5 of null");
            return "0";
        }
        StringBuffer sb = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytesOfMessage = string.getBytes("UTF-8");
            byte[] mdbytes = md.digest(bytesOfMessage);
            sb = new StringBuffer();
            for (int i = 0; i < mdbytes.length; ++i) {
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
        }
        catch (NoSuchAlgorithmException e) {
            App.settings.logStackTrace(e);
        }
        catch (IOException e) {
            App.settings.logStackTrace(e);
        }
        return sb.toString();
    }

    public static boolean moveFile(File from, File to, boolean withFilename) {
        if (Utils.copyFile(from, to, withFilename)) {
            Utils.delete(from);
            return true;
        }
        LogManager.error("Couldn't move file " + from.getAbsolutePath() + " to " + to.getAbsolutePath());
        return false;
    }

    public static boolean copyFile(File from, File to) {
        return Utils.copyFile(from, to, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File from, File to, boolean withFilename) {
        if (!from.isFile()) {
            LogManager.error("File " + from.getAbsolutePath() + " cannot be copied to " + to.getAbsolutePath() + " as" + " it isn't a file");
        }
        if (!from.exists()) {
            LogManager.error("File " + from.getAbsolutePath() + " cannot be copied to " + to.getAbsolutePath() + " as" + " it doesn't exist");
            return false;
        }
        if (!withFilename) {
            to = new File(to, from.getName());
        }
        if (to.exists()) {
            to.delete();
        }
        try {
            to.createNewFile();
        }
        catch (IOException e) {
            App.settings.logStackTrace(e);
            return false;
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(from).getChannel();
            destination = new FileOutputStream(to).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        catch (IOException e) {
            App.settings.logStackTrace(e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (source != null) {
                    source.close();
                }
                if (destination != null) {
                    destination.close();
                }
            }
            catch (IOException e) {
                App.settings.logStackTrace(e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean safeCopy(File from, File to) throws IOException {
        if (to.exists()) {
            to.delete();
        }
        FileInputStream is = null;
        OutputStream os = null;
        try {
            int len;
            is = new FileInputStream(from);
            os = new FileOutputStream(to);
            byte[] buff = new byte[1024];
            while ((len = ((InputStream)is).read(buff)) > 0) {
                os.write(buff, 0, len);
            }
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
            if (os != null) {
                os.close();
            }
        }
        return true;
    }

    public static boolean moveDirectory(File sourceLocation, File targetLocation) {
        if (Utils.copyDirectory(sourceLocation, targetLocation)) {
            Utils.delete(sourceLocation);
            return true;
        }
        LogManager.error("Couldn't move directory " + sourceLocation.getAbsolutePath() + " to " + targetLocation.getAbsolutePath());
        return false;
    }

    public static boolean copyDirectory(File sourceLocation, File targetLocation) {
        return Utils.copyDirectory(sourceLocation, targetLocation, false);
    }

    public static boolean copyDirectory(File sourceLocation, File targetLocation, boolean copyFolder) {
        if (copyFolder) {
            targetLocation = new File(targetLocation, sourceLocation.getName());
        }
        try {
            if (sourceLocation.isDirectory()) {
                if (!targetLocation.exists()) {
                    targetLocation.mkdirs();
                }
                String[] children = sourceLocation.list();
                for (int i = 0; i < children.length; ++i) {
                    Utils.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
                }
            } else {
                int len;
                FileInputStream in = new FileInputStream(sourceLocation);
                FileOutputStream out = new FileOutputStream(targetLocation);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
        }
        catch (IOException e) {
            App.settings.logStackTrace(e);
            return false;
        }
        return true;
    }

    public static void unzip(File in, File out) {
        Utils.unzip(in, out, null);
    }

    public static void unzip(File in, File out, ExtractRule extractRule) {
        try {
            ZipFile zipFile = null;
            if (!out.exists()) {
                out.mkdirs();
            }
            zipFile = new ZipFile(in);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                int b;
                ZipEntry entry = e.nextElement();
                String entryName = entry.getName();
                if (entry.getName().endsWith("aux.class")) {
                    entryName = "aux_class";
                }
                if (extractRule != null && extractRule.shouldExclude(entryName)) continue;
                if (entry.isDirectory()) {
                    File folder = new File(out, entryName);
                    folder.mkdirs();
                }
                File destinationFilePath = new File(out, entryName);
                destinationFilePath.getParentFile().mkdirs();
                if (entry.isDirectory() || entry.getName().equals(".minecraft")) continue;
                BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));
                byte[] buffer = new byte[1024];
                FileOutputStream fos = new FileOutputStream(destinationFilePath);
                BufferedOutputStream bos = new BufferedOutputStream(fos, 1024);
                while ((b = bis.read(buffer, 0, 1024)) != -1) {
                    bos.write(buffer, 0, b);
                }
                bos.flush();
                bos.close();
                bis.close();
            }
            zipFile.close();
        }
        catch (IOException e) {
            App.settings.logStackTrace(e);
        }
    }

    public static void cleanTempDirectory() {
        File file = App.settings.getTempDir();
        if (file.isDirectory()) {
            String[] myFiles = file.list();
            for (int i = 0; i < myFiles.length; ++i) {
                new File(file, myFiles[i]).delete();
            }
        }
    }

    public static void delete(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File c : file.listFiles()) {
                Utils.delete(c);
            }
        }
        if (!file.delete()) {
            LogManager.error((file.isFile() ? "File" : "Folder") + " " + file.getAbsolutePath() + " couldn't be " + "deleted");
        }
    }

    public static void deleteWithFilter(File file, final List<String> filesToIgnore) {
        FilenameFilter ffFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !filesToIgnore.contains(name);
            }
        };
        for (File aFile : file.listFiles(ffFilter)) {
            Utils.delete(aFile);
        }
    }

    public static void spreadOutResourceFiles(File dir) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                Utils.spreadOutResourceFiles(file);
                continue;
            }
            String hash = Utils.getSHA1(file);
            File saveTo = new File(App.settings.getObjectsAssetsDir(), hash.substring(0, 2) + File.separator + hash);
            saveTo.mkdirs();
            Utils.copyFile(file, saveTo, true);
        }
    }

    public static void deleteContents(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                return;
            }
            for (File c : files) {
                Utils.delete(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File in, File out) {
        try {
            URI base = in.toURI();
            LinkedList<File> queue = new LinkedList<File>();
            queue.push(in);
            FileOutputStream stream = new FileOutputStream(out);
            OutputStream res = stream;
            ZipOutputStream zout = null;
            try {
                zout = new ZipOutputStream(stream);
                res = zout;
                while (!queue.isEmpty()) {
                    in = (File)queue.pop();
                    for (File kid : in.listFiles()) {
                        String name = base.relativize(kid.toURI()).getPath();
                        if (name.endsWith("aux_class")) {
                            name = "aux.class";
                        }
                        if (kid.isDirectory()) {
                            queue.push(kid);
                            name = name.endsWith("/") ? name : name + "/";
                            zout.putNextEntry(new ZipEntry(name));
                            continue;
                        }
                        zout.putNextEntry(new ZipEntry(name));
                        Utils.copy(kid, (OutputStream)zout);
                        zout.closeEntry();
                    }
                }
            }
            finally {
                res.close();
                if (zout != null) {
                    zout.close();
                }
            }
        }
        catch (IOException e) {
            App.settings.logStackTrace(e);
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int readCount;
        byte[] buffer = new byte[1024];
        while ((readCount = in.read(buffer)) >= 0) {
            out.write(buffer, 0, readCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(File file, OutputStream out) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            Utils.copy(in, out);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static String encrypt(String Data) {
        String encryptedValue = null;
        try {
            Key key = Utils.generateKey();
            Cipher c = Cipher.getInstance("AES");
            c.init(1, key);
            byte[] encVal = c.doFinal(Data.getBytes());
            encryptedValue = Base64.encodeBytes(encVal);
        }
        catch (Exception e) {
            App.settings.logStackTrace(e);
        }
        return encryptedValue;
    }

    public static String decrypt(String encryptedData) {
        String decryptedValue = null;
        try {
            Key key = Utils.generateKey();
            Cipher c = Cipher.getInstance("AES");
            c.init(2, key);
            byte[] decordedValue = Base64.decode(encryptedData);
            byte[] decValue = c.doFinal(decordedValue);
            decryptedValue = new String(decValue);
        }
        catch (InvalidKeyException e) {
            return Utils.decryptOld(encryptedData);
        }
        catch (BadPaddingException e) {
            return Utils.decryptOld(encryptedData);
        }
        catch (IllegalBlockSizeException e) {
            return Utils.decryptOld(encryptedData);
        }
        catch (Exception e) {
            App.settings.logStackTrace(e);
        }
        return decryptedValue;
    }

    public static String decryptOld(String encryptedData) {
        String decryptedValue = null;
        try {
            SecretKeySpec key = new SecretKeySpec("NotARandomKeyYes".getBytes(), "AES");
            Cipher c = Cipher.getInstance("AES");
            c.init(2, key);
            byte[] decordedValue = Base64.decode(encryptedData);
            byte[] decValue = c.doFinal(decordedValue);
            decryptedValue = new String(decValue);
        }
        catch (Exception e) {
            App.settings.logStackTrace(e);
        }
        return decryptedValue;
    }

    private static Key generateKey() throws Exception {
        return new SecretKeySpec(Utils.getMACAdressHash().getBytes(), 0, 16, "AES");
    }

    public static void replaceText(File originalFile, File destinationFile, String replaceThis, String withThis) throws IOException {
        FileInputStream fs = new FileInputStream(originalFile);
        BufferedReader br = new BufferedReader(new InputStreamReader(fs));
        FileWriter writer1 = new FileWriter(destinationFile);
        String line = br.readLine();
        while (line != null) {
            if (line.contains(replaceThis)) {
                line = line.replace(replaceThis, withThis);
            }
            writer1.write(line);
            writer1.write(System.getProperty("line.separator"));
            line = br.readLine();
        }
        writer1.flush();
        writer1.close();
        br.close();
        fs.close();
    }

    public static String sendPostData(String urll, String text, String key) throws IOException {
        String line;
        String write = URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(text, "UTF-8");
        StringBuilder response = null;
        URL url = new URL(urll);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("User-Agent", App.settings.getUserAgent());
        connection.setRequestProperty("Cache-Control", "no-store,max-age=0,no-cache");
        connection.setRequestProperty("Expires", "0");
        connection.setRequestProperty("Pragma", "no-cache");
        connection.setRequestProperty("Content-Length", "" + write.getBytes().length);
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        DataOutputStream writer = new DataOutputStream(connection.getOutputStream());
        writer.write(write.getBytes());
        writer.flush();
        writer.close();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        response = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            response.append(line);
            response.append('\r');
        }
        reader.close();
        return response.toString();
    }

    public static String sendAPICall(String path, Object data) throws IOException {
        String line;
        StringBuilder response = null;
        byte[] contents = Settings.gson.toJson(data).getBytes();
        URL url = new URL("" + path);
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("User-Agent", App.settings.getUserAgent());
        connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        connection.setRequestProperty("Cache-Control", "no-store,max-age=0,no-cache");
        connection.setRequestProperty("Expires", "0");
        connection.setRequestProperty("Pragma", "no-cache");
        connection.setRequestProperty("Content-Length", "" + contents.length);
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        DataOutputStream writer = new DataOutputStream(connection.getOutputStream());
        writer.write(contents);
        writer.flush();
        writer.close();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        response = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            response.append(line);
            response.append('\r');
        }
        reader.close();
        return response.toString();
    }

    public static String sendGetAPICall(String path) throws IOException {
        String line;
        StringBuilder response = null;
        URL url = new URL("" + path);
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("User-Agent", App.settings.getUserAgent());
        connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        connection.setRequestProperty("Cache-Control", "no-store,max-age=0,no-cache");
        connection.setRequestProperty("Expires", "0");
        connection.setRequestProperty("Pragma", "no-cache");
        connection.setUseCaches(false);
        connection.setDoOutput(true);
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        response = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            response.append(line);
            response.append('\r');
        }
        reader.close();
        return response.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasMetaInf(File minecraftJar) {
        ZipInputStream input = null;
        try {
            JarEntry entry;
            input = new JarInputStream(new FileInputStream(minecraftJar));
            boolean found = false;
            while ((entry = ((JarInputStream)input).getNextJarEntry()) != null) {
                if (!entry.getName().contains("META-INF")) continue;
                found = true;
            }
            boolean bl = found;
            return bl;
        }
        catch (IOException e) {
            App.settings.logStackTrace(e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    App.settings.logStackTrace("Unable to close input stream", e);
                }
            }
        }
        return false;
    }

    public static FilenameFilter getLogsFileFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File file = new File(dir, name);
                return file.isFile() && name.startsWith("ATLauncher-Log_") && name.endsWith(".log");
            }
        };
    }

    public static FilenameFilter getInstanceFileFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File instanceDir = new File(dir, name);
                if (instanceDir.isDirectory()) {
                    return new File(instanceDir, "instance.json").exists();
                }
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getActualJavaVersion() {
        if (App.settings.isUsingCustomJavaPath()) {
            File folder = new File(App.settings.getJavaPath(), "bin/");
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add(folder + File.separator + "java" + (Utils.isWindows() ? ".exe" : ""));
            arguments.add("-version");
            ProcessBuilder processBuilder = new ProcessBuilder(arguments);
            processBuilder.directory(folder);
            processBuilder.redirectErrorStream(true);
            String version = "Unknown";
            BufferedReader br = null;
            try {
                Process process = processBuilder.start();
                InputStream is = process.getInputStream();
                InputStreamReader isr = new InputStreamReader(is);
                br = new BufferedReader(isr);
                String line = null;
                Pattern p = Pattern.compile("build ([0-9.-_a-zA-Z]+)");
                while ((line = br.readLine()) != null) {
                    Matcher m = p.matcher(line);
                    if (!m.find()) continue;
                    version = m.group(1);
                    break;
                }
            }
            catch (IOException e) {
                App.settings.logStackTrace(e);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        App.settings.logStackTrace("Cannot close process input stream reader", e);
                    }
                }
            }
            return "Launcher: " + System.getProperty("java.version") + ", Minecraft: " + version;
        }
        return "Launcher: " + System.getProperty("java.version") + ", Minecraft: " + System.getProperty("java.version");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJava7OrAbove(boolean checkCustomPath) {
        if (App.settings.isUsingCustomJavaPath() && checkCustomPath) {
            block21: {
                File folder = new File(App.settings.getJavaPath(), "bin/");
                ArrayList<String> arguments = new ArrayList<String>();
                arguments.add(folder + File.separator + "java" + (Utils.isWindows() ? ".exe" : ""));
                arguments.add("-version");
                ProcessBuilder processBuilder = new ProcessBuilder(arguments);
                processBuilder.directory(folder);
                processBuilder.redirectErrorStream(true);
                BufferedReader br = null;
                int version = -1;
                try {
                    Process process = processBuilder.start();
                    InputStream is = process.getInputStream();
                    InputStreamReader isr = new InputStreamReader(is);
                    br = new BufferedReader(isr);
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        if (!line.contains("build 1.")) continue;
                        int buildIndex = line.indexOf("build 1.") + 8;
                        version = Integer.parseInt(line.substring(buildIndex, buildIndex + 1));
                        break;
                    }
                    if (version == -1) {
                        LogManager.warn("Cannot get java version number from the ouput of java -version");
                        break block21;
                    }
                    boolean bl = version >= 7;
                    return bl;
                }
                catch (NumberFormatException e) {
                    App.settings.logStackTrace("Cannot get number from the ouput of java -version", e);
                }
                catch (IOException e) {
                    App.settings.logStackTrace(e);
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            App.settings.logStackTrace("Cannot close input stream reader", e);
                        }
                    }
                }
            }
            return true;
        }
        return Integer.parseInt(System.getProperty("java.version").substring(2, 3)) >= 7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJava8() {
        if (App.settings.isUsingCustomJavaPath()) {
            File folder = new File(App.settings.getJavaPath(), "bin/");
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add(folder + File.separator + "java" + (Utils.isWindows() ? ".exe" : ""));
            arguments.add("-version");
            ProcessBuilder processBuilder = new ProcessBuilder(arguments);
            processBuilder.directory(folder);
            processBuilder.redirectErrorStream(true);
            BufferedReader br = null;
            try {
                Process process = processBuilder.start();
                InputStream is = process.getInputStream();
                InputStreamReader isr = new InputStreamReader(is);
                br = new BufferedReader(isr);
                String line = br.readLine();
                boolean bl = line.contains("\"1.8");
                return bl;
            }
            catch (IOException e) {
                App.settings.logStackTrace(e);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        App.settings.logStackTrace("Cannot close input stream reader", e);
                    }
                }
            }
            return false;
        }
        return System.getProperty("java.version").substring(0, 3).equalsIgnoreCase("1.8");
    }

    public static FilenameFilter getOpenEyePendingReportsFileFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File file = new File(dir, name);
                Pattern pattern = Pattern.compile("^pending-crash-[0-9\\-_\\.]+\\.json$");
                return file.isFile() && pattern.matcher(name).matches();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenEyeReportResponse sendOpenEyePendingReport(File report) {
        HttpURLConnection connection;
        StringBuilder response = null;
        String request = Utils.getFileContents(report);
        if (request == null) {
            LogManager.error("OpenEye: Couldn't read contents of file '" + report.getAbsolutePath() + "'. Pending " + "report sending failed!");
            return null;
        }
        try {
            URL url = new URL("http://openeye.openmods.info/api/v1/crash");
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            connection.setRequestProperty("Content-Length", "" + request.getBytes().length);
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            DataOutputStream writer = new DataOutputStream(connection.getOutputStream());
            writer.write(request.getBytes(Charset.forName("UTF-8")));
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            App.settings.logStackTrace(e);
            return null;
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
                response.append('\r');
            }
        }
        catch (IOException e) {
            App.settings.logStackTrace(e);
            OpenEyeReportResponse openEyeReportResponse = null;
            return openEyeReportResponse;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                App.settings.logStackTrace(e);
            }
        }
        return Settings.gson.fromJson(response.toString(), OpenEyeReportResponse[].class)[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContents(File file) {
        if (!file.exists()) {
            LogManager.error("File '" + file.getAbsolutePath() + "' doesn't exist so cannot read contents of file!");
            return null;
        }
        String contents = null;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append(System.getProperty("line.separator"));
                line = br.readLine();
            }
            contents = sb.toString();
        }
        catch (IOException e) {
            App.settings.logStackTrace(e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                App.settings.logStackTrace(e);
            }
        }
        return contents;
    }

    public static String splitMultilinedString(String string, int maxLineLength, String lineSeparator) {
        char[] chars = string.toCharArray();
        StringBuilder sb = new StringBuilder();
        char spaceChar = " ".charAt(0);
        int count = 0;
        for (char character : chars) {
            if (count >= maxLineLength && character == spaceChar) {
                sb.append(lineSeparator);
                count = 0;
                continue;
            }
            ++count;
            sb.append(character);
        }
        return sb.toString();
    }

    public static Float getBaseFontSize() {
        if (Utils.isMac()) {
            return Float.valueOf(11.0f);
        }
        return Float.valueOf(12.0f);
    }

    public static boolean testProxy(Proxy proxy) {
        try {
            URL url = new URL(App.settings.getFileURL("ping"));
            HttpURLConnection connection = (HttpURLConnection)url.openConnection(proxy);
            connection.setUseCaches(false);
            connection.setDefaultUseCaches(false);
            if (App.useGzipForDownloads) {
                connection.setRequestProperty("Accept-Encoding", "gzip");
            }
            connection.setRequestProperty("User-Agent", App.settings.getUserAgent());
            connection.setRequestProperty("Cache-Control", "no-store,max-age=0,no-cache");
            connection.setRequestProperty("Expires", "0");
            connection.setRequestProperty("Pragma", "no-cache");
            connection.connect();
            LogManager.info("Proxy returned code " + connection.getResponseCode() + " when testing!");
            return connection.getResponseCode() == 200;
        }
        catch (IOException e) {
            LogManager.error("Proxy couldn't establish a connection when testing!");
            return false;
        }
    }

    public static FilenameFilter getThemesFileFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File file = new File(dir, name);
                return file.exists() && file.isFile() && name.endsWith(".zip");
            }
        };
    }

    public static Image flipImage(BufferedImage image) {
        AffineTransform tx = AffineTransform.getScaleInstance(-1.0, 1.0);
        tx.translate(-image.getWidth(null), 0.0);
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        image = op.filter(image, null);
        return image;
    }

    public static int nonTransparentPixels(BufferedImage image) {
        int count = 0;
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 8; ++y) {
                if (image.getRGB(x, y) != -1) continue;
                ++count;
            }
        }
        return count;
    }

    public static String pingAddress(String host) {
        String pingStats = "";
        StringBuilder response = new StringBuilder();
        try {
            String line;
            InetAddress address = InetAddress.getByName(host);
            Process traceRoute = Utils.isWindows() ? Runtime.getRuntime().exec("ping -n 10 " + address.getHostAddress()) : Runtime.getRuntime().exec("ping -c 10 " + address.getHostAddress());
            BufferedReader reader = null;
            reader = new BufferedReader(new InputStreamReader(traceRoute.getInputStream()));
            response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
                response.append('\r');
            }
            reader.close();
            pingStats = response.toString();
        }
        catch (IOException e) {
            App.settings.logStackTrace("IOException while running ping on host " + host, e);
        }
        return pingStats;
    }

    public static String traceRoute(String host) {
        String route = "";
        try {
            String line;
            InetAddress address = InetAddress.getByName(host);
            Process traceRoute = Utils.isWindows() ? Runtime.getRuntime().exec("tracert " + address.getHostAddress()) : Runtime.getRuntime().exec("traceroute " + address.getHostAddress());
            BufferedReader reader = null;
            reader = new BufferedReader(new InputStreamReader(traceRoute.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
                response.append('\r');
            }
            reader.close();
            route = response.toString();
        }
        catch (IOException e) {
            App.settings.logStackTrace("IOException while running traceRoute on host " + host, e);
        }
        return route;
    }

    public static Object[] prepareMessageForMinecraftLog(String text) {
        LogEvent.LogType type = null;
        String message = null;
        if (text.contains("[INFO] [STDERR]")) {
            message = text.substring(text.indexOf("[INFO] [STDERR]"));
            type = LogEvent.LogType.WARN;
        } else if (text.contains("[INFO]")) {
            message = text.substring(text.indexOf("[INFO]"));
            type = message.contains("CONFLICT") ? LogEvent.LogType.ERROR : (message.contains("overwriting existing item") ? LogEvent.LogType.WARN : LogEvent.LogType.INFO);
        } else if (text.contains("[WARNING]")) {
            message = text.substring(text.indexOf("[WARNING]"));
            type = LogEvent.LogType.WARN;
        } else if (text.contains("WARNING:")) {
            message = text.substring(text.indexOf("WARNING:"));
            type = LogEvent.LogType.WARN;
        } else if (text.contains("INFO:")) {
            message = text.substring(text.indexOf("INFO:"));
            type = LogEvent.LogType.INFO;
        } else if (text.contains("Exception")) {
            message = text;
            type = LogEvent.LogType.ERROR;
        } else if (text.contains("[SEVERE]")) {
            message = text.substring(text.indexOf("[SEVERE]"));
            type = LogEvent.LogType.ERROR;
        } else if (text.contains("[Sound Library Loader/ERROR]")) {
            message = text.substring(text.indexOf("[Sound Library Loader/ERROR]"));
            type = LogEvent.LogType.ERROR;
        } else if (text.contains("[Sound Library Loader/WARN]")) {
            message = text.substring(text.indexOf("[Sound Library Loader/WARN]"));
            type = LogEvent.LogType.WARN;
        } else if (text.contains("[Sound Library Loader/INFO]")) {
            message = text.substring(text.indexOf("[Sound Library Loader/INFO]"));
            type = LogEvent.LogType.INFO;
        } else if (text.contains("[MCO Availability Checker #1/ERROR]")) {
            message = text.substring(text.indexOf("[MCO Availability Checker #1/ERROR]"));
            type = LogEvent.LogType.ERROR;
        } else if (text.contains("[MCO Availability Checker #1/WARN]")) {
            message = text.substring(text.indexOf("[MCO Availability Checker #1/WARN]"));
            type = LogEvent.LogType.WARN;
        } else if (text.contains("[MCO Availability Checker #1/INFO]")) {
            message = text.substring(text.indexOf("[MCO Availability Checker #1/INFO]"));
            type = LogEvent.LogType.INFO;
        } else if (text.contains("[Client thread/ERROR]")) {
            message = text.substring(text.indexOf("[Client thread/ERROR]"));
            type = LogEvent.LogType.ERROR;
        } else if (text.contains("[Client thread/WARN]")) {
            message = text.substring(text.indexOf("[Client thread/WARN]"));
            type = LogEvent.LogType.WARN;
        } else if (text.contains("[Client thread/INFO]")) {
            message = text.substring(text.indexOf("[Client thread/INFO]"));
            type = LogEvent.LogType.INFO;
        } else if (text.contains("[Server thread/ERROR]")) {
            message = text.substring(text.indexOf("[Server thread/ERROR]"));
            type = LogEvent.LogType.ERROR;
        } else if (text.contains("[Server thread/WARN]")) {
            message = text.substring(text.indexOf("[Server thread/WARN]"));
            type = LogEvent.LogType.WARN;
        } else if (text.contains("[Server thread/INFO]")) {
            message = text.substring(text.indexOf("[Server thread/INFO]"));
            type = LogEvent.LogType.INFO;
        } else if (text.contains("[main/ERROR]")) {
            message = text.substring(text.indexOf("[main/ERROR]"));
            type = LogEvent.LogType.ERROR;
        } else if (text.contains("[main/WARN]")) {
            message = text.substring(text.indexOf("[main/WARN]"));
            type = LogEvent.LogType.WARN;
        } else if (text.contains("[main/INFO]")) {
            message = text.substring(text.indexOf("[main/INFO]"));
            type = LogEvent.LogType.INFO;
        } else {
            message = text;
            type = LogEvent.LogType.INFO;
        }
        return new Object[]{type, message};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(File file) {
        byte[] bytes = null;
        RandomAccessFile f = null;
        try {
            f = new RandomAccessFile(file, "r");
            bytes = new byte[(int)f.length()];
            f.read(bytes);
        }
        catch (IOException e) {
            App.settings.logStackTrace(e);
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException e) {
                    App.settings.logStackTrace(e);
                }
            }
        }
        return bytes;
    }

    public static void unXZPackFile(File xzFile, File packFile, File outputFile) {
        Utils.unXZFile(xzFile, packFile);
        Utils.unpackFile(packFile, outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unXZFile(File input, File output) {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        BufferedInputStream bis = null;
        XZInputStream xzis = null;
        try {
            fis = new FileInputStream(input);
            xzis = new XZInputStream(fis);
            fos = new FileOutputStream(output);
            byte[] buffer = new byte[8192];
            int n = 0;
            while (-1 != (n = xzis.read(buffer))) {
                fos.write(buffer, 0, n);
            }
        }
        catch (IOException e) {
            App.settings.logStackTrace(e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (bis != null) {
                    bis.close();
                }
                if (fos != null) {
                    fos.close();
                }
                if (xzis != null) {
                    xzis.close();
                }
            }
            catch (IOException e) {
                App.settings.logStackTrace(e);
            }
        }
    }

    public static void unpackFile(File input, File output) {
        byte[] decompressed;
        if (output.exists()) {
            Utils.delete(output);
        }
        if ((decompressed = Utils.readFile(input)) == null) {
            LogManager.error("unpackFile: While reading in " + input.getName() + " the file returned null");
            return;
        }
        String end = new String(decompressed, decompressed.length - 4, 4);
        if (!end.equals("SIGN")) {
            LogManager.error("unpackFile: Unpacking failed, signature missing " + end);
            return;
        }
        int x = decompressed.length;
        int len = decompressed[x - 8] & 0xFF | (decompressed[x - 7] & 0xFF) << 8 | (decompressed[x - 6] & 0xFF) << 16 | (decompressed[x - 5] & 0xFF) << 24;
        byte[] checksums = Arrays.copyOfRange(decompressed, decompressed.length - len - 8, decompressed.length - 8);
        try {
            FileOutputStream jarBytes = new FileOutputStream(output);
            JarOutputStream jos = new JarOutputStream(jarBytes);
            Pack200.newUnpacker().unpack((InputStream)new ByteArrayInputStream(decompressed), jos);
            jos.putNextEntry(new JarEntry("checksums.sha1"));
            jos.write(checksums);
            jos.closeEntry();
            jos.close();
            jarBytes.close();
        }
        catch (IOException e) {
            App.settings.logStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMACAdressHash() {
        String returnStr = null;
        try {
            byte[] mac;
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            if (network == null) {
                Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
                while (e.hasMoreElements()) {
                    NetworkInterface n = e.nextElement();
                    Enumeration<InetAddress> ee = n.getInetAddresses();
                    while (ee.hasMoreElements()) {
                        InetAddress i = ee.nextElement();
                        if (i.isLoopbackAddress() || i.isLinkLocalAddress() || !i.isSiteLocalAddress()) continue;
                        ip = i;
                    }
                }
                network = NetworkInterface.getByInetAddress(ip);
            }
            if (network != null && (mac = network.getHardwareAddress()) != null && mac.length > 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
                }
                returnStr = sb.toString();
            }
            returnStr = returnStr == null ? "NotARandomKeyYes" : returnStr;
        }
        catch (Exception e) {
            try {
                App.settings.logStackTrace(e);
                returnStr = returnStr == null ? "NotARandomKeyYes" : returnStr;
            }
            catch (Throwable throwable) {
                returnStr = returnStr == null ? "NotARandomKeyYes" : returnStr;
                throw throwable;
            }
        }
        return Utils.getMD5(returnStr);
    }

    public static boolean addToClasspath(File file) {
        LogManager.info("Loading external library " + file.getName() + " to classpath");
        try {
            if (file.exists()) {
                Utils.addURL(file.toURI().toURL());
            } else {
                LogManager.error("Error loading AuthLib");
            }
        }
        catch (Throwable t) {
            if (t.getMessage() != null) {
                LogManager.error(t.getMessage());
            }
            return false;
        }
        return true;
    }

    public static boolean checkAuthLibLoaded() {
        try {
            App.settings.getClass();
            Class.forName("com.mojang.authlib.exceptions.AuthenticationException");
            App.settings.getClass();
            Class.forName("com.mojang.authlib.Agent");
            App.settings.getClass();
            Class.forName("com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService");
            App.settings.getClass();
            Class.forName("com.mojang.authlib.yggdrasil.YggdrasilUserAuthentication");
        }
        catch (ClassNotFoundException e) {
            App.settings.logStackTrace(e);
            return false;
        }
        return true;
    }

    public static void addURL(URL u) throws IOException {
        URLClassLoader sysloader = (URLClassLoader)App.settings.getClass().getClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)sysloader, u);
        }
        catch (Throwable t) {
            if (t.getMessage() != null) {
                LogManager.error(t.getMessage());
            }
            throw new IOException("Error, could not add URL to system classloader");
        }
    }
}

