/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.workers;

import com.atlauncher.App;
import com.atlauncher.Gsons;
import com.atlauncher.LogManager;
import com.atlauncher.data.APIResponse;
import com.atlauncher.data.DecompType;
import com.atlauncher.data.DisableableMod;
import com.atlauncher.data.Download;
import com.atlauncher.data.Downloadable;
import com.atlauncher.data.Instance;
import com.atlauncher.data.Language;
import com.atlauncher.data.Mod;
import com.atlauncher.data.Pack;
import com.atlauncher.data.PackVersion;
import com.atlauncher.data.Settings;
import com.atlauncher.data.json.Action;
import com.atlauncher.data.json.CaseType;
import com.atlauncher.data.json.DownloadType;
import com.atlauncher.data.json.Library;
import com.atlauncher.data.json.ModInfo;
import com.atlauncher.data.json.ModType;
import com.atlauncher.data.json.Version;
import com.atlauncher.data.mojang.AssetIndex;
import com.atlauncher.data.mojang.AssetObject;
import com.atlauncher.data.mojang.DateTypeAdapter;
import com.atlauncher.data.mojang.EnumTypeAdapterFactory;
import com.atlauncher.data.mojang.FileTypeAdapter;
import com.atlauncher.data.mojang.MojangConstants;
import com.atlauncher.gui.dialogs.JsonModsChooser;
import com.atlauncher.gui.dialogs.ModsChooser;
import com.atlauncher.utils.Utils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class InstanceInstaller
extends SwingWorker<Boolean, Void> {
    private final Gson gson;
    private String instanceName;
    private Pack pack;
    private Version jsonVersion;
    private PackVersion version;
    private boolean isReinstall;
    private boolean isServer;
    private String jarOrder;
    private boolean instanceIsCorrupt = false;
    private boolean savedReis = false;
    private boolean savedZans = false;
    private boolean savedNEICfg = false;
    private boolean savedOptionsTxt = false;
    private boolean savedServersDat = false;
    private boolean savedPortalGunSounds = false;
    private boolean extractedTexturePack = false;
    private boolean extractedResourcePack = false;
    private String caseAllFiles = null;
    private int permgen = 0;
    private int memory = 0;
    private String librariesNeeded = null;
    private String extraArguments = null;
    private String mainClass = null;
    private int percent = 0;
    private List<Mod> allMods;
    private List<com.atlauncher.data.json.Mod> allJsonMods;
    private List<Mod> selectedMods;
    private List<com.atlauncher.data.json.Mod> selectedJsonMods;
    private int totalDownloads = 0;
    private int doneDownloads = 0;
    private int totalBytes = 0;
    private int downloadedBytes = 0;
    private Instance instance = null;
    private List<DisableableMod> modsInstalled;
    private List<File> serverLibraries;
    private List<com.atlauncher.data.Action> actions;
    private List<String> forgeLibraries = new ArrayList<String>();

    public InstanceInstaller(String instanceName, Pack pack, PackVersion version, boolean isReinstall, boolean isServer) {
        this.instanceName = instanceName;
        this.pack = pack;
        this.version = version;
        this.isReinstall = isReinstall;
        this.isServer = isServer;
        if (isServer) {
            this.serverLibraries = new ArrayList<File>();
        }
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapterFactory(new EnumTypeAdapterFactory());
        builder.registerTypeAdapter((Type)((Object)Date.class), new DateTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)File.class), new FileTypeAdapter());
        builder.setPrettyPrinting();
        this.gson = builder.create();
    }

    public static String getEtag(String etag) {
        if (etag == null) {
            etag = "-";
        } else if (etag.startsWith("\"") && etag.endsWith("\"")) {
            etag = etag.substring(1, etag.length() - 1);
        }
        return etag;
    }

    public Pack getPack() {
        return this.pack;
    }

    public void setInstance(Instance instance) {
        this.instance = instance;
    }

    public boolean isServer() {
        return this.isServer;
    }

    public boolean isLegacy() {
        return this.version.getMinecraftVersion().isLegacy();
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public List<DisableableMod> getModsInstalled() {
        return this.modsInstalled;
    }

    public String getInstanceSafeName() {
        return this.instanceName.replaceAll("[^A-Za-z0-9]", "");
    }

    public File getRootDirectory() {
        if (this.isServer) {
            return new File(App.settings.getServersDir(), this.pack.getSafeName() + "_" + this.version.getSafeVersion());
        }
        return new File(App.settings.getInstancesDir(), this.getInstanceSafeName());
    }

    public File getTempDirectory() {
        return new File(App.settings.getTempDir(), this.pack.getSafeName() + "_" + this.version.getSafeVersion());
    }

    public File getTempJarDirectory() {
        return new File(App.settings.getTempDir(), this.pack.getSafeName() + "_" + this.version.getSafeVersion() + "_JarTemp");
    }

    public File getTempActionsDirectory() {
        return new File(App.settings.getTempDir(), this.pack.getSafeName() + "_" + this.version.getSafeVersion() + "_ActionsTemp");
    }

    public File getTempTexturePackDirectory() {
        return new File(App.settings.getTempDir(), this.pack.getSafeName() + "_" + this.version.getSafeVersion() + "_TexturePackTemp");
    }

    public File getTempResourcePackDirectory() {
        return new File(App.settings.getTempDir(), this.pack.getSafeName() + "_" + this.version.getSafeVersion() + "_ResourcePackTemp");
    }

    public File getLibrariesDirectory() {
        return new File(this.getRootDirectory(), "libraries");
    }

    public File getTexturePacksDirectory() {
        return new File(this.getRootDirectory(), "texturepacks");
    }

    public File getShaderPacksDirectory() {
        return new File(this.getRootDirectory(), "shaderpacks");
    }

    public File getResourcePacksDirectory() {
        return new File(this.getRootDirectory(), "resourcepacks");
    }

    public File getConfigDirectory() {
        return new File(this.getRootDirectory(), "config");
    }

    public File getModsDirectory() {
        return new File(this.getRootDirectory(), "mods");
    }

    public File getIC2LibDirectory() {
        return new File(this.getModsDirectory(), "ic2");
    }

    public File getDenLibDirectory() {
        return new File(this.getModsDirectory(), "denlib");
    }

    public File getFlanDirectory() {
        return new File(this.getRootDirectory(), "Flan");
    }

    public File getDependencyDirectory() {
        return new File(this.getModsDirectory(), this.version.getMinecraftVersion().getVersion());
    }

    public File getPluginsDirectory() {
        return new File(this.getRootDirectory(), "plugins");
    }

    public File getCoreModsDirectory() {
        return new File(this.getRootDirectory(), "coremods");
    }

    public File getJarModsDirectory() {
        return new File(this.getRootDirectory(), "jarmods");
    }

    public File getDisabledModsDirectory() {
        return new File(this.getRootDirectory(), "disabledmods");
    }

    public File getBinDirectory() {
        return new File(this.getRootDirectory(), "bin");
    }

    public File getNativesDirectory() {
        return new File(this.getBinDirectory(), "natives");
    }

    public boolean hasActions() {
        if (this.jsonVersion != null) {
            return this.jsonVersion.hasActions();
        }
        return this.actions != null && this.actions.size() != 0;
    }

    public PackVersion getVersion() {
        return this.version;
    }

    public File getMinecraftJar() {
        if (this.isServer) {
            return new File(this.getRootDirectory(), "minecraft_server." + this.version.getMinecraftVersion().getVersion() + ".jar");
        }
        return new File(this.getBinDirectory(), "minecraft.jar");
    }

    public String getJarOrder() {
        return this.jarOrder;
    }

    public void setTexturePackExtracted() {
        this.extractedTexturePack = true;
    }

    public void setResourcePackExtracted() {
        this.extractedResourcePack = true;
    }

    public void addToJarOrder(String file) {
        this.jarOrder = this.jarOrder == null ? file : (!this.isLegacy() ? this.jarOrder + "," + file : file + "," + this.jarOrder);
    }

    public boolean wasModInstalled(String mod) {
        return this.instance != null && this.instance.wasModInstalled(mod);
    }

    public boolean isReinstall() {
        return this.isReinstall;
    }

    public boolean isModByName(String name) {
        for (Mod mod : this.allMods) {
            if (!mod.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public Mod getModByName(String name) {
        for (Mod mod : this.allMods) {
            if (!mod.getName().equalsIgnoreCase(name)) continue;
            return mod;
        }
        return null;
    }

    public com.atlauncher.data.json.Mod getJsonModByName(String name) {
        for (com.atlauncher.data.json.Mod mod : this.allJsonMods) {
            if (!mod.getName().equalsIgnoreCase(name)) continue;
            return mod;
        }
        return null;
    }

    public List<Mod> getLinkedMods(Mod mod) {
        ArrayList<Mod> linkedMods = new ArrayList<Mod>();
        for (Mod modd : this.allMods) {
            if (!modd.getLinked().equalsIgnoreCase(mod.getName())) continue;
            linkedMods.add(modd);
        }
        return linkedMods;
    }

    public List<com.atlauncher.data.json.Mod> getJsonLinkedMods(com.atlauncher.data.json.Mod mod) {
        ArrayList<com.atlauncher.data.json.Mod> linkedMods = new ArrayList<com.atlauncher.data.json.Mod>();
        for (com.atlauncher.data.json.Mod modd : this.allJsonMods) {
            if (!modd.hasLinked() || !modd.getLinked().equalsIgnoreCase(mod.getName())) continue;
            linkedMods.add(modd);
        }
        return linkedMods;
    }

    public List<Mod> getGroupedMods(Mod mod) {
        ArrayList<Mod> groupedMods = new ArrayList<Mod>();
        for (Mod modd : this.allMods) {
            if (!modd.getGroup().equalsIgnoreCase(mod.getGroup()) || modd == mod) continue;
            groupedMods.add(modd);
        }
        return groupedMods;
    }

    public List<com.atlauncher.data.json.Mod> getGroupedMods(com.atlauncher.data.json.Mod mod) {
        ArrayList<com.atlauncher.data.json.Mod> groupedMods = new ArrayList<com.atlauncher.data.json.Mod>();
        for (com.atlauncher.data.json.Mod modd : this.allJsonMods) {
            if (!modd.hasGroup() || !modd.getGroup().equalsIgnoreCase(mod.getGroup()) || modd == mod) continue;
            groupedMods.add(modd);
        }
        return groupedMods;
    }

    public List<Mod> getModsDependancies(Mod mod) {
        ArrayList<Mod> dependsMods = new ArrayList<Mod>();
        block0: for (String name : mod.getDependancies()) {
            for (Mod modd : this.allMods) {
                if (!modd.getName().equalsIgnoreCase(name)) continue;
                dependsMods.add(modd);
                continue block0;
            }
        }
        return dependsMods;
    }

    public List<com.atlauncher.data.json.Mod> getModsDependancies(com.atlauncher.data.json.Mod mod) {
        ArrayList<com.atlauncher.data.json.Mod> dependsMods = new ArrayList<com.atlauncher.data.json.Mod>();
        block0: for (String name : mod.getDepends()) {
            for (com.atlauncher.data.json.Mod modd : this.allJsonMods) {
                if (!modd.getName().equalsIgnoreCase(name)) continue;
                dependsMods.add(modd);
                continue block0;
            }
        }
        return dependsMods;
    }

    public List<Mod> dependedMods(Mod mod) {
        ArrayList<Mod> dependedMods = new ArrayList<Mod>();
        for (Mod modd : this.allMods) {
            if (!modd.hasDepends() || !modd.isADependancy(mod)) continue;
            dependedMods.add(modd);
        }
        return dependedMods;
    }

    public List<com.atlauncher.data.json.Mod> dependedMods(com.atlauncher.data.json.Mod mod) {
        ArrayList<com.atlauncher.data.json.Mod> dependedMods = new ArrayList<com.atlauncher.data.json.Mod>();
        for (com.atlauncher.data.json.Mod modd : this.allJsonMods) {
            if (!modd.hasDepends() || !modd.isADependancy(mod)) continue;
            dependedMods.add(modd);
        }
        return dependedMods;
    }

    public boolean hasADependancy(Mod mod) {
        for (Mod modd : this.allMods) {
            if (!modd.hasDepends() || !modd.isADependancy(mod)) continue;
            return true;
        }
        return false;
    }

    public boolean hasADependancy(com.atlauncher.data.json.Mod mod) {
        for (com.atlauncher.data.json.Mod modd : this.allJsonMods) {
            if (!modd.hasDepends() || !modd.isADependancy(mod)) continue;
            return true;
        }
        return false;
    }

    private void makeDirectories() {
        if (this.isReinstall || this.isServer) {
            Utils.delete(this.getBinDirectory());
            Utils.delete(this.getConfigDirectory());
            if (this.instance != null && this.instance.getMinecraftVersion().equalsIgnoreCase(this.version.getMinecraftVersion().getVersion()) && this.instance.hasCustomMods()) {
                Utils.deleteWithFilter(this.getModsDirectory(), this.instance.getCustomMods(com.atlauncher.data.Type.mods));
                if (this.version.getMinecraftVersion().usesCoreMods()) {
                    Utils.deleteWithFilter(this.getCoreModsDirectory(), this.instance.getCustomMods(com.atlauncher.data.Type.coremods));
                }
                if (this.isReinstall) {
                    Utils.deleteWithFilter(this.getJarModsDirectory(), this.instance.getCustomMods(com.atlauncher.data.Type.jar));
                }
            } else {
                Utils.delete(this.getModsDirectory());
                if (this.version.getMinecraftVersion().usesCoreMods()) {
                    Utils.delete(this.getCoreModsDirectory());
                }
                if (this.isReinstall) {
                    Utils.delete(this.getJarModsDirectory());
                }
            }
            if (this.isReinstall) {
                Utils.delete(new File(this.getTexturePacksDirectory(), "TexturePack.zip"));
                Utils.delete(new File(this.getResourcePacksDirectory(), "ResourcePack.zip"));
            } else {
                Utils.delete(this.getLibrariesDirectory());
            }
            if (this.instance != null) {
                List<File> fileDeletes;
                if (this.pack.hasDeleteArguments(true, this.version.getVersion())) {
                    fileDeletes = this.pack.getDeletes(true, this.version.getVersion(), this.instance);
                    for (File file : fileDeletes) {
                        if (!file.exists()) continue;
                        Utils.delete(file);
                    }
                }
                if (this.pack.hasDeleteArguments(false, this.version.getVersion())) {
                    fileDeletes = this.pack.getDeletes(false, this.version.getVersion(), this.instance);
                    for (File file : fileDeletes) {
                        if (!file.exists()) continue;
                        Utils.delete(file);
                    }
                }
            }
        }
        File[] directories = this.isServer ? new File[]{this.getRootDirectory(), this.getModsDirectory(), this.getTempDirectory(), this.getLibrariesDirectory()} : new File[]{this.getRootDirectory(), this.getModsDirectory(), this.getDisabledModsDirectory(), this.getTempDirectory(), this.getJarModsDirectory(), this.getBinDirectory(), this.getNativesDirectory()};
        for (File directory : directories) {
            directory.mkdir();
        }
        if (this.version.getMinecraftVersion().usesCoreMods()) {
            this.getCoreModsDirectory().mkdir();
        }
    }

    private ArrayList<Downloadable> getDownloadableMods() {
        ArrayList<Downloadable> mods = new ArrayList<Downloadable>();
        ArrayList<String> files = new ArrayList<String>();
        Map fileSizes = new HashMap();
        for (Mod mod : this.selectedMods) {
            if (!mod.isServerDownload()) continue;
            files.add(mod.getURL());
        }
        if (!files.isEmpty()) {
            APIResponse response = null;
            try {
                response = Gsons.DEFAULT.fromJson(Utils.sendAPICall("file-info", files), APIResponse.class);
            }
            catch (IOException e1) {
                App.settings.logStackTrace(e1);
            }
            if (response == null) {
                LogManager.warn("Couldn't get info of files. Continuing regardless!");
            } else {
                try {
                    Type type = new TypeToken<Map<String, ModInfo>>(){}.getType();
                    fileSizes = (Map)Gsons.DEFAULT.fromJson(response.getDataAsString(), type);
                }
                catch (Exception e) {
                    App.settings.logStackTrace("Failed to get response from the API, this won't affect the install process!", e);
                }
            }
        }
        for (Mod mod : this.selectedMods) {
            if (!mod.isServerDownload()) continue;
            int size = -1;
            String md5 = null;
            if (mod.hasMD5()) {
                md5 = mod.getMD5();
            }
            if (fileSizes.containsKey(mod.getURL())) {
                size = ((ModInfo)fileSizes.get(mod.getURL())).getFilesize();
                md5 = ((ModInfo)fileSizes.get(mod.getURL())).getMd5();
            }
            Downloadable downloadable = new Downloadable(mod.getURL(), new File(App.settings.getDownloadsDir(), mod.getFile()), md5, size, this, true);
            mods.add(downloadable);
        }
        return mods;
    }

    private List<Downloadable> getDownloadableJsonMods() {
        ArrayList<Downloadable> mods = new ArrayList<Downloadable>();
        ArrayList<String> files = new ArrayList<String>();
        Map fileSizes = new HashMap();
        for (com.atlauncher.data.json.Mod mod : this.selectedJsonMods) {
            if (mod.getDownload() != DownloadType.server) continue;
            files.add(mod.getUrl());
        }
        if (!files.isEmpty()) {
            APIResponse response = null;
            try {
                response = Gsons.DEFAULT.fromJson(Utils.sendAPICall("file-info", files), APIResponse.class);
            }
            catch (IOException e1) {
                App.settings.logStackTrace(e1);
            }
            if (response == null) {
                LogManager.warn("Couldn't get info of files. Continuing regardless!");
            } else {
                try {
                    Type type = new TypeToken<Map<String, ModInfo>>(){}.getType();
                    fileSizes = (Map)Gsons.DEFAULT.fromJson(response.getDataAsString(), type);
                }
                catch (Exception e) {
                    App.settings.logStackTrace("Failed to get response from the API, this won't affect the install process!", e);
                }
            }
        }
        for (com.atlauncher.data.json.Mod mod : this.selectedJsonMods) {
            if (mod.getDownload() != DownloadType.server) continue;
            int size = -1;
            String md5 = null;
            if (mod.hasMD5()) {
                md5 = mod.getMD5();
            }
            if (fileSizes.containsKey(mod.getUrl())) {
                size = ((ModInfo)fileSizes.get(mod.getUrl())).getFilesize();
                md5 = ((ModInfo)fileSizes.get(mod.getUrl())).getMd5();
            }
            Downloadable downloadable = new Downloadable(mod.getUrl(), new File(App.settings.getDownloadsDir(), mod.getFile()), md5, size, this, true);
            mods.add(downloadable);
        }
        return mods;
    }

    private void loadActions() {
        this.actions = new ArrayList<com.atlauncher.data.Action>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(this.pack.getXML(this.version.getVersion(), false)));
            Document document = builder.parse(is);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("action");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String mod = element.getAttribute("mod");
                String action = element.getAttribute("action");
                com.atlauncher.data.Type type = null;
                if (element.hasAttribute("type")) {
                    type = com.atlauncher.data.Type.valueOf(element.getAttribute("type"));
                }
                String after = element.getAttribute("after");
                String saveAs = element.getAttribute("saveas");
                Boolean client = element.getAttribute("client").equalsIgnoreCase("yes");
                Boolean server = element.getAttribute("server").equalsIgnoreCase("yes");
                com.atlauncher.data.Action thing = null;
                thing = element.hasAttribute("type") ? new com.atlauncher.data.Action(action, type, after, saveAs, client, server) : new com.atlauncher.data.Action(action, after, saveAs, client, server);
                for (String modd : mod.split(",")) {
                    if (!this.isModByName(modd)) continue;
                    thing.addMod(this.getModByName(modd));
                }
                this.actions.add(thing);
            }
        }
        catch (SAXException e) {
            App.settings.logStackTrace(e);
        }
        catch (ParserConfigurationException e) {
            App.settings.logStackTrace(e);
        }
        catch (IOException e) {
            App.settings.logStackTrace(e);
        }
    }

    private void doActions() {
        if (this.jsonVersion != null) {
            for (Action action : this.jsonVersion.getActions()) {
                action.execute(this);
            }
        } else {
            for (com.atlauncher.data.Action action : this.actions) {
                action.execute(this);
            }
        }
    }

    private boolean hasOptionalMods() {
        for (Mod mod : this.allMods) {
            if (!mod.isOptional()) continue;
            return true;
        }
        return false;
    }

    private void installMods() {
        if (this.jsonVersion != null) {
            for (com.atlauncher.data.json.Mod mod : this.selectedJsonMods) {
                if (this.isCancelled()) continue;
                this.fireTask(Language.INSTANCE.localize("common.installing") + " " + mod.getName());
                this.addPercent(this.selectedJsonMods.size() / 40);
                mod.install(this);
            }
        } else {
            for (Mod mod : this.selectedMods) {
                if (this.isCancelled()) continue;
                this.fireTask(Language.INSTANCE.localize("common.installing") + " " + mod.getName());
                this.addPercent(this.selectedMods.size() / 40);
                mod.install(this);
            }
        }
    }

    public boolean hasRecommendedMods() {
        for (Mod mod : this.allMods) {
            if (mod.isRecommeneded()) continue;
            return true;
        }
        return false;
    }

    public boolean hasJsonRecommendedMods() {
        for (com.atlauncher.data.json.Mod mod : this.allJsonMods) {
            if (mod.isRecommended()) continue;
            return true;
        }
        return false;
    }

    public boolean isOnlyRecommendedInGroup(Mod mod) {
        for (Mod modd : this.allMods) {
            if (modd == mod || !modd.getGroup().equalsIgnoreCase(mod.getGroup()) || !modd.isRecommeneded()) continue;
            return false;
        }
        return true;
    }

    public boolean isOnlyRecommendedInGroup(com.atlauncher.data.json.Mod mod) {
        for (com.atlauncher.data.json.Mod modd : this.allJsonMods) {
            if (modd == mod || !modd.hasGroup() || !modd.getGroup().equalsIgnoreCase(mod.getGroup()) || !modd.isRecommended()) continue;
            return false;
        }
        return true;
    }

    public ArrayList<Mod> getModsInCategory(String category) {
        ArrayList<Mod> mods = new ArrayList<Mod>();
        for (Mod mod : this.allMods) {
            if (mod.getCategory() == null || !mod.isOptional() || !mod.getCategory().equalsIgnoreCase(category)) continue;
            mods.add(mod);
        }
        return mods;
    }

    public ArrayList<String> getCategories() {
        ArrayList<String> categories = new ArrayList<String>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(this.pack.getXML(this.version.getVersion(), false)));
            Document document = builder.parse(is);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("category");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                categories.add(element.getAttribute("id"));
            }
        }
        catch (SAXException e) {
            App.settings.logStackTrace(e);
        }
        catch (ParserConfigurationException e) {
            App.settings.logStackTrace(e);
        }
        catch (IOException e) {
            App.settings.logStackTrace(e);
        }
        return categories;
    }

    public String getCategoryName(String id) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(this.pack.getXML(this.version.getVersion(), false)));
            Document document = builder.parse(is);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("category");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(element = (Element)node).getAttribute("id").equalsIgnoreCase(id)) continue;
                return element.getAttribute("name");
            }
        }
        catch (SAXException e) {
            App.settings.logStackTrace(e);
        }
        catch (ParserConfigurationException e) {
            App.settings.logStackTrace(e);
        }
        catch (IOException e) {
            App.settings.logStackTrace(e);
        }
        return null;
    }

    public String getCategoryDescription(String id) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(this.pack.getXML(this.version.getVersion(), false)));
            Document document = builder.parse(is);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("category");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(element = (Element)node).getAttribute("id").equalsIgnoreCase(id)) continue;
                return element.getAttribute("description");
            }
        }
        catch (SAXException e) {
            App.settings.logStackTrace(e);
        }
        catch (ParserConfigurationException e) {
            App.settings.logStackTrace(e);
        }
        catch (IOException e) {
            App.settings.logStackTrace(e);
        }
        return null;
    }

    private void downloadResources() {
        this.fireTask(Language.INSTANCE.localize("instance.downloadingresources"));
        this.fireSubProgressUnknown();
        ExecutorService executor = Executors.newFixedThreadPool(App.settings.getConcurrentConnections());
        ArrayList<Downloadable> downloads = this.getResources();
        this.totalBytes = 0;
        this.downloadedBytes = 0;
        for (final Downloadable download : downloads) {
            if (!download.needToDownload()) continue;
            this.totalBytes += download.getFilesize();
        }
        this.fireSubProgress(0);
        for (final Downloadable download : downloads) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (download.needToDownload()) {
                        InstanceInstaller.this.fireTask(Language.INSTANCE.localize("common.downloading") + " " + download.getFilename());
                        download.download(true);
                    } else {
                        download.copyFile();
                    }
                }
            });
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        this.fireSubProgress(-1);
    }

    private void downloadLibraries() {
        this.fireTask(Language.INSTANCE.localize("instance.downloadinglibraries"));
        this.fireSubProgressUnknown();
        ArrayList<Downloadable> downloads = this.getLibraries();
        this.totalBytes = 0;
        this.downloadedBytes = 0;
        ExecutorService executor = Executors.newFixedThreadPool(App.settings.getConcurrentConnections());
        for (final Downloadable download : downloads) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (download.needToDownload()) {
                        InstanceInstaller.this.totalBytes += download.getFilesize();
                    }
                }
            });
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        this.fireSubProgress(0);
        executor = Executors.newFixedThreadPool(App.settings.getConcurrentConnections());
        for (final Downloadable download : downloads) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (download.needToDownload()) {
                        InstanceInstaller.this.fireTask(Language.INSTANCE.localize("common.downloading") + " " + download.getFilename());
                        download.download(true);
                    }
                }
            });
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        this.fireSubProgress(-1);
    }

    private void downloadMods(List<Mod> mods) {
        this.fireSubProgressUnknown();
        ArrayList<Downloadable> downloads = this.getDownloadableMods();
        this.totalBytes = 0;
        this.downloadedBytes = 0;
        ExecutorService executor = Executors.newFixedThreadPool(App.settings.getConcurrentConnections());
        for (final Downloadable download : downloads) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (download.needToDownload()) {
                        InstanceInstaller.this.totalBytes += download.getFilesize();
                    }
                }
            });
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        this.fireSubProgress(0);
        executor = Executors.newFixedThreadPool(App.settings.getConcurrentConnections());
        for (final Downloadable download : downloads) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (download.needToDownload()) {
                        download.download(true);
                    }
                }
            });
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        this.fireSubProgress(-1);
        for (Mod mod : mods) {
            if (downloads.contains(mod) || this.isCancelled()) continue;
            this.fireTask(Language.INSTANCE.localize("common.downloading") + " " + (mod.isFilePattern() ? mod.getName() : mod.getFile()));
            mod.download(this);
            this.fireSubProgress(-1);
        }
    }

    private void downloadJsonMods(List<com.atlauncher.data.json.Mod> mods) {
        this.fireSubProgressUnknown();
        List<Downloadable> downloads = this.getDownloadableJsonMods();
        this.totalBytes = 0;
        this.downloadedBytes = 0;
        ExecutorService executor = Executors.newFixedThreadPool(App.settings.getConcurrentConnections());
        for (final Downloadable download : downloads) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (download.needToDownload()) {
                        InstanceInstaller.this.totalBytes += download.getFilesize();
                    }
                }
            });
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        this.fireSubProgress(0);
        executor = Executors.newFixedThreadPool(App.settings.getConcurrentConnections());
        for (final Downloadable download : downloads) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (download.needToDownload()) {
                        download.download(true);
                    }
                }
            });
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        this.fireSubProgress(-1);
        for (com.atlauncher.data.json.Mod mod : mods) {
            if (downloads.contains(mod) || this.isCancelled()) continue;
            this.fireTask(Language.INSTANCE.localize("common.downloading") + " " + (mod.isFilePattern() ? mod.getName() : mod.getFile()));
            mod.download(this);
            this.fireSubProgress(-1);
        }
    }

    private void organiseLibraries() {
        File copyTo;
        File toCopy;
        ArrayList<String> libraryNamesAdded = new ArrayList<String>();
        this.fireTask(Language.INSTANCE.localize("instance.organisinglibraries"));
        this.fireSubProgressUnknown();
        if (!this.isServer) {
            for (String libraryFile : this.forgeLibraries) {
                File library = new File(App.settings.getLibrariesDir(), libraryFile);
                if (!library.exists()) {
                    LogManager.error("Cannot install instance because the library file " + library.getAbsolutePath() + " wasn't found!");
                    this.cancel(true);
                    return;
                }
                Utils.copyFile(library, this.getBinDirectory());
                libraryNamesAdded.add(library.getName().substring(0, library.getName().lastIndexOf("-")));
            }
            for (com.atlauncher.data.mojang.Library library : this.version.getMinecraftVersion().getMojangVersion().getLibraries()) {
                if (!library.shouldInstall() || libraryNamesAdded.contains(library.getFile().getName().substring(0, library.getFile().getName().lastIndexOf("-")))) continue;
                if (library.getFile().exists()) {
                    if (library.shouldExtract()) {
                        Utils.unzip(library.getFile(), this.getNativesDirectory(), library.getExtractRule());
                        continue;
                    }
                    File dirToInstall = this.getBinDirectory();
                    Utils.copyFile(library.getFile(), this.getBinDirectory());
                    continue;
                }
                LogManager.error("Cannot install instance because the library file " + library.getFile().getAbsolutePath() + " wasn't found!");
                this.cancel(true);
                return;
            }
        }
        boolean withFilename = false;
        if (this.isServer) {
            toCopy = new File(App.settings.getJarsDir(), "minecraft_server." + this.version.getMinecraftVersion().getVersion() + ".jar");
            copyTo = this.getRootDirectory();
        } else {
            toCopy = new File(App.settings.getJarsDir(), this.version.getMinecraftVersion().getVersion() + ".jar");
            copyTo = new File(this.getBinDirectory(), "minecraft.jar");
            withFilename = true;
        }
        if (!toCopy.exists()) {
            LogManager.error("Cannot install instance because the library file " + toCopy.getAbsolutePath() + " " + "wasn't found!");
            this.cancel(true);
            return;
        }
        Utils.copyFile(toCopy, copyTo, withFilename);
        this.fireSubProgress(-1);
    }

    private void doCaseConversions(File dir) {
        File[] files;
        if (this.isReinstall && this.instance.getMinecraftVersion().equalsIgnoreCase(this.version.getMinecraftVersion().getVersion())) {
            final List<String> customMods = this.instance.getCustomMods(com.atlauncher.data.Type.mods);
            FilenameFilter ffFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return !customMods.contains(name);
                }
            };
            files = dir.listFiles(ffFilter);
        } else {
            files = dir.listFiles();
        }
        if (this.jsonVersion != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().endsWith("jar") && !file.getName().endsWith("zip") && !file.getName().endsWith("litemod")) continue;
                if (this.jsonVersion.getCaseAllFiles() == CaseType.upper) {
                    file.renameTo(new File(file.getParentFile(), file.getName().substring(0, file.getName().lastIndexOf(".")).toUpperCase() + file.getName().substring(file.getName().lastIndexOf("."), file.getName().length())));
                    continue;
                }
                if (this.jsonVersion.getCaseAllFiles() != CaseType.lower) continue;
                file.renameTo(new File(file.getParentFile(), file.getName().toLowerCase()));
            }
        } else {
            for (File file : files) {
                if (!file.isFile() || !file.getName().endsWith("jar") && !file.getName().endsWith("zip") && !file.getName().endsWith("litemod") || this.caseAllFiles == null) continue;
                if (this.caseAllFiles.equalsIgnoreCase("upper")) {
                    file.renameTo(new File(file.getParentFile(), file.getName().substring(0, file.getName().lastIndexOf(".")).toUpperCase() + file.getName().substring(file.getName().lastIndexOf("."), file.getName().length())));
                    continue;
                }
                if (!this.caseAllFiles.equalsIgnoreCase("lower")) continue;
                file.renameTo(new File(file.getParentFile(), file.getName().toLowerCase()));
            }
        }
    }

    private ArrayList<Downloadable> getResources() {
        ArrayList<Downloadable> downloads = new ArrayList<Downloadable>();
        File objectsFolder = new File(App.settings.getResourcesDir(), "objects");
        File indexesFolder = new File(App.settings.getResourcesDir(), "indexes");
        File virtualFolder = new File(App.settings.getResourcesDir(), "virtual");
        String assetVersion = this.version.getMinecraftVersion().getMojangVersion().getAssets();
        File virtualRoot = new File(virtualFolder, assetVersion);
        File indexFile = new File(indexesFolder, assetVersion + ".json");
        objectsFolder.mkdirs();
        indexesFolder.mkdirs();
        virtualFolder.mkdirs();
        try {
            new Downloadable(MojangConstants.DOWNLOAD_BASE.getURL("indexes/" + assetVersion + ".json"), indexFile, null, this, false).download(false);
            AssetIndex index = this.gson.fromJson((Reader)new FileReader(indexFile), AssetIndex.class);
            if (index.isVirtual()) {
                virtualRoot.mkdirs();
            }
            for (Map.Entry<String, AssetObject> entry : index.getObjects().entrySet()) {
                AssetObject object = entry.getValue();
                String filename = object.getHash().substring(0, 2) + "/" + object.getHash();
                File file = new File(objectsFolder, filename);
                File virtualFile = new File(virtualRoot, entry.getKey());
                if (object.needToDownload(file)) {
                    downloads.add(new Downloadable(MojangConstants.RESOURCES_BASE.getURL(filename), file, object.getHash(), (int)object.getSize(), this, false, virtualFile, index.isVirtual()));
                    continue;
                }
                if (!index.isVirtual()) continue;
                virtualFile.mkdirs();
                Utils.copyFile(file, virtualFile, true);
            }
        }
        catch (JsonSyntaxException e) {
            App.settings.logStackTrace(e);
        }
        catch (JsonIOException e) {
            App.settings.logStackTrace(e);
        }
        catch (FileNotFoundException e) {
            App.settings.logStackTrace(e);
        }
        return downloads;
    }

    public ArrayList<Downloadable> getLibraries() {
        ArrayList<Downloadable> libraries = new ArrayList<Downloadable>();
        ArrayList<String> libraryNamesAdded = new ArrayList<String>();
        if (this.jsonVersion == null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = factory.newDocumentBuilder();
                InputSource is = new InputSource(new StringReader(this.pack.getXML(this.version.getVersion(), false)));
                Document document = documentBuilder.parse(is);
                document.getDocumentElement().normalize();
                NodeList nodeList = document.getElementsByTagName("library");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    String url = element.getAttribute("url");
                    String file = element.getAttribute("file");
                    Download download = Download.direct;
                    if (element.hasAttribute("download")) {
                        download = Download.valueOf(element.getAttribute("download"));
                    } else if (!url.startsWith("http://") && !url.startsWith("https://")) {
                        download = Download.server;
                    }
                    String md5 = "-";
                    if (element.hasAttribute("md5")) {
                        md5 = element.getAttribute("md5");
                    }
                    if (element.hasAttribute("depends")) {
                        boolean found = false;
                        for (Mod mod : this.selectedMods) {
                            if (!element.getAttribute("depends").equalsIgnoreCase(mod.getName())) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            continue;
                        }
                    } else if (element.hasAttribute("dependsgroup")) {
                        boolean found = false;
                        for (Mod mod : this.selectedMods) {
                            if (!element.getAttribute("dependsgroup").equalsIgnoreCase(mod.getGroup())) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                    }
                    this.librariesNeeded = this.librariesNeeded == null ? file : this.librariesNeeded + "," + file;
                    this.forgeLibraries.add(file);
                    File downloadTo = null;
                    if (this.isServer) {
                        if (!element.hasAttribute("server")) continue;
                        this.serverLibraries.add(new File(new File(this.getLibrariesDirectory(), element.getAttribute("server").substring(0, element.getAttribute("server").lastIndexOf(47))), element.getAttribute("server").substring(element.getAttribute("server").lastIndexOf(47), element.getAttribute("server").length())));
                    }
                    downloadTo = new File(App.settings.getLibrariesDir(), file);
                    if (download == Download.server) {
                        libraries.add(new Downloadable(url, downloadTo, md5, this, true));
                    } else {
                        libraries.add(new Downloadable(url, downloadTo, md5, this, false));
                    }
                    libraryNamesAdded.add(file.substring(0, file.lastIndexOf("-")));
                }
            }
            catch (SAXException e) {
                App.settings.logStackTrace(e);
            }
            catch (ParserConfigurationException e) {
                App.settings.logStackTrace(e);
            }
            catch (IOException e) {
                App.settings.logStackTrace(e);
            }
        } else {
            for (Library library : this.jsonVersion.getLibraries()) {
                if (library.hasDepends()) {
                    boolean found = false;
                    for (com.atlauncher.data.json.Mod mod : this.selectedJsonMods) {
                        if (!library.getDepends().equalsIgnoreCase(mod.getName())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        continue;
                    }
                } else if (library.hasDependsGroup()) {
                    boolean found = false;
                    for (com.atlauncher.data.json.Mod mod : this.selectedJsonMods) {
                        if (!library.getDependsGroup().equalsIgnoreCase(mod.getGroup())) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                }
                if (!library.getUrl().startsWith("http://") && !library.getUrl().startsWith("https://")) {
                    library.setDownloadType(DownloadType.server);
                }
                this.librariesNeeded = this.librariesNeeded == null ? library.getFile() : this.librariesNeeded + "," + library.getFile();
                this.forgeLibraries.add(library.getFile());
                File downloadTo = null;
                if (this.isServer) {
                    if (!library.forServer()) continue;
                    this.serverLibraries.add(new File(this.getLibrariesDirectory(), library.getServer()));
                }
                downloadTo = new File(App.settings.getLibrariesDir(), library.getFile());
                if (library.getDownloadType() == DownloadType.server) {
                    libraries.add(new Downloadable(library.getUrl(), downloadTo, library.getMD5(), this, true));
                } else if (library.getDownloadType() == DownloadType.direct) {
                    libraries.add(new Downloadable(library.getUrl(), downloadTo, library.getMD5(), this, false));
                } else {
                    LogManager.error("DownloadType for server library " + library.getFile() + " is invalid with a " + "value of " + (Object)((Object)library.getDownloadType()));
                    this.cancel(true);
                    return null;
                }
                if (library.getFile().contains("-")) {
                    libraryNamesAdded.add(library.getFile().substring(0, library.getFile().lastIndexOf("-")));
                    continue;
                }
                libraryNamesAdded.add(library.getFile());
            }
        }
        if (!this.isServer) {
            for (com.atlauncher.data.mojang.Library library : this.version.getMinecraftVersion().getMojangVersion().getLibraries()) {
                if (!library.shouldInstall()) continue;
                if (libraryNamesAdded.contains(library.getFile().getName().substring(0, library.getFile().getName().lastIndexOf("-")))) {
                    LogManager.debug("Not adding library " + library.getName() + " as it's been overwritten " + "already by the packs libraries!");
                    continue;
                }
                if (!library.shouldExtract()) {
                    this.librariesNeeded = this.librariesNeeded == null ? library.getFile().getName() : this.librariesNeeded + "," + library.getFile().getName();
                }
                libraries.add(new Downloadable(library.getURL(), library.getFile(), null, this, false));
            }
        }
        if (this.isServer) {
            libraries.add(new Downloadable(MojangConstants.DOWNLOAD_BASE.getURL("versions/" + this.version.getMinecraftVersion().getVersion() + "/minecraft_server." + this.version.getMinecraftVersion().getVersion() + ".jar"), new File(App.settings.getJarsDir(), "minecraft_server." + this.version.getMinecraftVersion().getVersion() + ".jar"), null, this, false));
        } else {
            libraries.add(new Downloadable(MojangConstants.DOWNLOAD_BASE.getURL("versions/" + this.version.getMinecraftVersion().getVersion() + "/" + this.version.getMinecraftVersion().getVersion() + "" + ".jar"), new File(App.settings.getJarsDir(), this.version.getMinecraftVersion().getVersion() + "" + ".jar"), null, this, false));
        }
        return libraries;
    }

    public void deleteMetaInf() {
        File inputFile = this.getMinecraftJar();
        File outputTmpFile = new File(App.settings.getTempDir(), this.pack.getSafeName() + "-minecraft.jar");
        try {
            JarEntry entry;
            JarInputStream input = new JarInputStream(new FileInputStream(inputFile));
            JarOutputStream output = new JarOutputStream(new FileOutputStream(outputTmpFile));
            while ((entry = input.getNextJarEntry()) != null) {
                int amo;
                if (entry.getName().contains("META-INF")) continue;
                output.putNextEntry(entry);
                byte[] buffer = new byte[1024];
                while ((amo = input.read(buffer, 0, 1024)) != -1) {
                    output.write(buffer, 0, amo);
                }
                output.closeEntry();
            }
            input.close();
            output.close();
            inputFile.delete();
            outputTmpFile.renameTo(inputFile);
        }
        catch (IOException e) {
            App.settings.logStackTrace(e);
        }
    }

    public void configurePack() {
        this.fireTask(Language.INSTANCE.localize("instance.downloadingconfigs"));
        File configs = new File(App.settings.getTempDir(), "Configs.zip");
        String path = "packs/" + this.pack.getSafeName() + "/versions/" + this.version.getVersion() + "/Configs.zip";
        Downloadable configsDownload = new Downloadable(path, configs, null, this, true);
        this.totalBytes = configsDownload.getFilesize();
        this.downloadedBytes = 0;
        configsDownload.download(true);
        this.fireSubProgressUnknown();
        this.fireTask(Language.INSTANCE.localize("instance.extractingconfigs"));
        Utils.unzip(configs, this.getRootDirectory());
        Utils.delete(configs);
    }

    public String getServerJar() {
        if (this.jsonVersion != null) {
            com.atlauncher.data.json.Mod forge = null;
            com.atlauncher.data.json.Mod mcpc = null;
            for (com.atlauncher.data.json.Mod mod : this.selectedJsonMods) {
                if (mod.getType() == ModType.forge) {
                    forge = mod;
                    continue;
                }
                if (mod.getType() != ModType.mcpc) continue;
                mcpc = mod;
            }
            if (mcpc != null) {
                return mcpc.getFile();
            }
            if (forge != null) {
                return forge.getFile();
            }
            return "minecraft_server." + this.version.getMinecraftVersion().getVersion() + ".jar";
        }
        Mod forge = null;
        Mod mcpc = null;
        for (Mod mod : this.selectedMods) {
            if (mod.getType() == com.atlauncher.data.Type.forge) {
                forge = mod;
                continue;
            }
            if (mod.getType() != com.atlauncher.data.Type.mcpc) continue;
            mcpc = mod;
        }
        if (mcpc != null) {
            return mcpc.getFile();
        }
        if (forge != null) {
            return forge.getFile();
        }
        return "minecraft_server." + this.version.getMinecraftVersion().getVersion() + ".jar";
    }

    public Version getJsonVersion() {
        return this.jsonVersion;
    }

    public boolean hasJarMods() {
        if (this.jsonVersion != null) {
            for (com.atlauncher.data.json.Mod mod : this.selectedJsonMods) {
                if (!mod.installOnServer() && this.isServer) continue;
                if (mod.getType() == ModType.jar) {
                    return true;
                }
                if (mod.getType() != ModType.decomp || mod.getDecompType() != com.atlauncher.data.json.DecompType.jar) continue;
                return true;
            }
        } else {
            for (Mod mod : this.selectedMods) {
                if (!mod.installOnServer() && this.isServer) continue;
                if (mod.getType() == com.atlauncher.data.Type.jar) {
                    return true;
                }
                if (mod.getType() != com.atlauncher.data.Type.decomp || mod.getDecompType() != DecompType.jar) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasForge() {
        if (this.jsonVersion != null) {
            for (com.atlauncher.data.json.Mod mod : this.selectedJsonMods) {
                if (!mod.installOnServer() && this.isServer || mod.getType() != ModType.forge) continue;
                return true;
            }
        } else {
            for (Mod mod : this.selectedMods) {
                if (!mod.installOnServer() && this.isServer || mod.getType() != com.atlauncher.data.Type.forge) continue;
                return true;
            }
        }
        return false;
    }

    public List<Mod> getMods() {
        return this.allMods;
    }

    public List<com.atlauncher.data.json.Mod> getJsonMods() {
        return this.allJsonMods;
    }

    public boolean shouldCoruptInstance() {
        return this.instanceIsCorrupt;
    }

    public String getCaseAllFiles() {
        return this.caseAllFiles;
    }

    public int getPermGen() {
        return this.permgen;
    }

    public int getMemory() {
        return this.memory;
    }

    public String getLibrariesNeeded() {
        return this.librariesNeeded;
    }

    public String getExtraArguments() {
        return this.extraArguments;
    }

    public String getMinecraftArguments() {
        return this.version.getMinecraftVersion().getMojangVersion().getMinecraftArguments();
    }

    public String getMainClass() {
        if (this.mainClass == null) {
            return this.version.getMinecraftVersion().getMojangVersion().getMainClass();
        }
        return this.mainClass;
    }

    public List<Mod> sortMods(List<Mod> original) {
        ArrayList<Mod> mods = new ArrayList<Mod>(original);
        for (Mod mod : original) {
            if (!mod.isOptional() || mod.getLinked().isEmpty()) continue;
            for (Mod mod1 : original) {
                if (!mod1.getName().equalsIgnoreCase(mod.getLinked())) continue;
                mods.remove(mod);
                int index = mods.indexOf(mod1) + 1;
                mods.add(index, mod);
            }
        }
        ArrayList<Mod> modss = new ArrayList<Mod>();
        for (Mod mod : mods) {
            if (mod.isOptional()) continue;
            modss.add(mod);
        }
        for (String category : this.getCategories()) {
            for (Mod mod : mods) {
                if (!mod.isOptional() || mod.getCategory().isEmpty() || !mod.getCategory().equalsIgnoreCase(category)) continue;
                modss.add(mod);
            }
        }
        for (Mod mod : mods) {
            if (modss.contains(mod)) continue;
            modss.add(mod);
        }
        return modss;
    }

    public List<com.atlauncher.data.json.Mod> sortJsonMods(List<com.atlauncher.data.json.Mod> original) {
        ArrayList<com.atlauncher.data.json.Mod> mods = new ArrayList<com.atlauncher.data.json.Mod>(original);
        for (com.atlauncher.data.json.Mod mod : original) {
            if (!mod.isOptional() || !mod.hasLinked()) continue;
            for (com.atlauncher.data.json.Mod mod1 : original) {
                if (!mod1.getName().equalsIgnoreCase(mod.getLinked())) continue;
                mods.remove(mod);
                int index = mods.indexOf(mod1) + 1;
                mods.add(index, mod);
            }
        }
        ArrayList<com.atlauncher.data.json.Mod> modss = new ArrayList<com.atlauncher.data.json.Mod>();
        for (com.atlauncher.data.json.Mod mod : mods) {
            if (mod.isOptional()) continue;
            modss.add(mod);
        }
        for (com.atlauncher.data.json.Mod mod : mods) {
            if (modss.contains(mod)) continue;
            modss.add(mod);
        }
        return modss;
    }

    private void backupSelectFiles() {
        File portalGunSounds;
        File serversDAT;
        File optionsTXT;
        File neiCfg;
        File zans;
        File reis = new File(this.getModsDirectory(), "rei_minimap");
        if (reis.exists() && reis.isDirectory() && Utils.copyDirectory(reis, this.getTempDirectory(), true)) {
            this.savedReis = true;
        }
        if ((zans = new File(this.getModsDirectory(), "VoxelMods")).exists() && zans.isDirectory() && Utils.copyDirectory(zans, this.getTempDirectory(), true)) {
            this.savedZans = true;
        }
        if ((neiCfg = new File(this.getConfigDirectory(), "NEI.cfg")).exists() && neiCfg.isFile() && Utils.copyFile(neiCfg, this.getTempDirectory())) {
            this.savedNEICfg = true;
        }
        if ((optionsTXT = new File(this.getRootDirectory(), "options.txt")).exists() && optionsTXT.isFile() && Utils.copyFile(optionsTXT, this.getTempDirectory())) {
            this.savedOptionsTxt = true;
        }
        if ((serversDAT = new File(this.getRootDirectory(), "servers.dat")).exists() && serversDAT.isFile() && Utils.copyFile(serversDAT, this.getTempDirectory())) {
            this.savedServersDat = true;
        }
        if ((portalGunSounds = new File(this.getModsDirectory(), "PortalGunSounds.pak")).exists() && portalGunSounds.isFile()) {
            this.savedPortalGunSounds = true;
            Utils.copyFile(portalGunSounds, this.getTempDirectory());
        }
    }

    private void restoreSelectFiles() {
        if (this.savedReis) {
            Utils.copyDirectory(new File(this.getTempDirectory(), "rei_minimap"), new File(this.getModsDirectory(), "rei_minimap"));
        }
        if (this.savedZans) {
            Utils.copyDirectory(new File(this.getTempDirectory(), "VoxelMods"), new File(this.getModsDirectory(), "VoxelMods"));
        }
        if (this.savedNEICfg) {
            Utils.copyFile(new File(this.getTempDirectory(), "NEI.cfg"), new File(this.getConfigDirectory(), "NEI.cfg"), true);
        }
        if (this.savedOptionsTxt) {
            Utils.copyFile(new File(this.getTempDirectory(), "options.txt"), new File(this.getRootDirectory(), "options.txt"), true);
        }
        if (this.savedServersDat) {
            Utils.copyFile(new File(this.getTempDirectory(), "servers.dat"), new File(this.getRootDirectory(), "servers.dat"), true);
        }
        if (this.savedPortalGunSounds) {
            Utils.copyFile(new File(this.getTempDirectory(), "PortalGunSounds.pak"), new File(this.getModsDirectory(), "PortalGunSounds.pak"), true);
        }
    }

    private Boolean installUsingJSON() throws Exception {
        if (this.jsonVersion == null) {
            return false;
        }
        if (this.jsonVersion.hasMessages()) {
            if (this.isReinstall && this.jsonVersion.getMessages().hasUpdateMessage() && this.jsonVersion.getMessages().showUpdateMessage(this.pack) != 0) {
                LogManager.error("Instance Install Cancelled After Viewing Message!");
                this.cancel(true);
                return false;
            }
            if (this.jsonVersion.getMessages().hasInstallMessage() && this.jsonVersion.getMessages().showInstallMessage(this.pack) != 0) {
                LogManager.error("Instance Install Cancelled After Viewing Message!");
                this.cancel(true);
                return false;
            }
        }
        this.jsonVersion.compileColours();
        this.allJsonMods = this.sortJsonMods(this.isServer ? this.jsonVersion.getServerInstallMods() : this.jsonVersion.getClientInstallMods());
        boolean hasOptional = false;
        for (com.atlauncher.data.json.Mod mod : this.allJsonMods) {
            if (!mod.isOptional()) continue;
            hasOptional = true;
            break;
        }
        if (this.allJsonMods.size() != 0 && hasOptional) {
            JsonModsChooser modsChooser = new JsonModsChooser(this);
            modsChooser.setVisible(true);
            if (modsChooser.wasClosed()) {
                this.cancel(true);
                return false;
            }
            this.selectedJsonMods = modsChooser.getSelectedMods();
        }
        if (!hasOptional) {
            this.selectedJsonMods = this.allJsonMods;
        }
        this.modsInstalled = new ArrayList<DisableableMod>();
        for (com.atlauncher.data.json.Mod mod : this.selectedJsonMods) {
            String file = mod.getFile();
            if (this.jsonVersion.getCaseAllFiles() == CaseType.upper) {
                file = file.substring(0, file.lastIndexOf(".")).toUpperCase() + file.substring(file.lastIndexOf("."));
            } else if (this.jsonVersion.getCaseAllFiles() == CaseType.lower) {
                file = file.substring(0, file.lastIndexOf(".")).toLowerCase() + file.substring(file.lastIndexOf("."));
            }
            this.modsInstalled.add(new DisableableMod(mod.getName(), mod.getVersion(), mod.isOptional(), file, com.atlauncher.data.Type.valueOf(com.atlauncher.data.Type.class, mod.getType().toString()), this.jsonVersion.getColour(mod.getColour()), mod.getDescription(), false, false));
        }
        if (this.isReinstall && this.instance.hasCustomMods() && this.instance.getMinecraftVersion().equalsIgnoreCase(this.version.getMinecraftVersion().getVersion())) {
            for (DisableableMod disableableMod : this.instance.getCustomDisableableMods()) {
                this.modsInstalled.add(disableableMod);
            }
        }
        this.instanceIsCorrupt = true;
        this.getTempDirectory().mkdirs();
        this.backupSelectFiles();
        this.makeDirectories();
        this.addPercent(5);
        this.setJsonMainClass();
        this.setJsonExtraArguments();
        if (this.version.getMinecraftVersion().hasResources()) {
            this.downloadResources();
            if (this.isCancelled()) {
                return false;
            }
        }
        this.downloadLibraries();
        if (this.isCancelled()) {
            return false;
        }
        this.organiseLibraries();
        if (this.isCancelled()) {
            return false;
        }
        if (this.isServer) {
            for (File file : this.serverLibraries) {
                file.mkdirs();
                Utils.copyFile(new File(App.settings.getLibrariesDir(), file.getName()), file, true);
            }
        }
        this.addPercent(5);
        if (this.isServer && this.hasJarMods()) {
            this.fireTask(Language.INSTANCE.localize("server.extractingjar"));
            this.fireSubProgressUnknown();
            Utils.unzip(this.getMinecraftJar(), this.getTempJarDirectory());
        }
        if (!this.isServer && this.hasJarMods() && !this.hasForge()) {
            this.deleteMetaInf();
        }
        this.addPercent(5);
        if (this.selectedJsonMods.size() != 0) {
            this.addPercent(40);
            this.fireTask(Language.INSTANCE.localize("instance.downloadingmods"));
            this.downloadJsonMods(this.selectedJsonMods);
            if (this.isCancelled()) {
                return false;
            }
            this.addPercent(40);
            this.installMods();
        } else {
            this.addPercent(80);
        }
        if (this.isCancelled()) {
            return false;
        }
        if (this.jsonVersion.shouldCaseAllFiles()) {
            this.doCaseConversions(this.getModsDirectory());
        }
        if (this.isServer && this.hasJarMods()) {
            this.fireTask(Language.INSTANCE.localize("server.zippingjar"));
            this.fireSubProgressUnknown();
            Utils.zip(this.getTempJarDirectory(), this.getMinecraftJar());
        }
        if (this.extractedTexturePack) {
            this.fireTask(Language.INSTANCE.localize("instance.zippingtexturepackfiles"));
            this.fireSubProgressUnknown();
            if (!this.getTexturePacksDirectory().exists()) {
                this.getTexturePacksDirectory().mkdir();
            }
            Utils.zip(this.getTempTexturePackDirectory(), new File(this.getTexturePacksDirectory(), "TexturePack.zip"));
        }
        if (this.extractedResourcePack) {
            this.fireTask(Language.INSTANCE.localize("instance.zippingresourcepackfiles"));
            this.fireSubProgressUnknown();
            if (!this.getResourcePacksDirectory().exists()) {
                this.getResourcePacksDirectory().mkdir();
            }
            Utils.zip(this.getTempResourcePackDirectory(), new File(this.getResourcePacksDirectory(), "ResourcePack.zip"));
        }
        if (this.isCancelled()) {
            return false;
        }
        if (this.hasActions()) {
            this.doActions();
        }
        if (this.isCancelled()) {
            return false;
        }
        if (!this.jsonVersion.hasNoConfigs()) {
            this.configurePack();
        }
        if (App.settings.getCommonConfigsDir().listFiles().length != 0) {
            Utils.copyDirectory(App.settings.getCommonConfigsDir(), this.getRootDirectory());
        }
        this.restoreSelectFiles();
        if (this.isServer) {
            File batFile = new File(this.getRootDirectory(), "LaunchServer.bat");
            File file = new File(this.getRootDirectory(), "LaunchServer.sh");
            Utils.replaceText(new File(App.settings.getLibrariesDir(), "LaunchServer.bat"), batFile, "%%SERVERJAR%%", this.getServerJar());
            Utils.replaceText(new File(App.settings.getLibrariesDir(), "LaunchServer.sh"), file, "%%SERVERJAR%%", this.getServerJar());
            batFile.setExecutable(true);
            file.setExecutable(true);
        }
        return true;
    }

    private Boolean installUsingXML() throws Exception {
        int ret;
        Object[] options;
        if (this.isReinstall) {
            if (this.pack.getUpdateMessage(this.version.getVersion()) != null) {
                if (this.isCancelled()) {
                    return false;
                }
                options = new String[]{Language.INSTANCE.localize("common.ok"), Language.INSTANCE.localize("common.cancel")};
                JEditorPane jEditorPane = new JEditorPane("text/html", "<html>" + this.pack.getUpdateMessage(this.version.getVersion()) + "</html>");
                jEditorPane.setEditable(false);
                jEditorPane.addHyperlinkListener(new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            Utils.openBrowser(e.getURL());
                        }
                    }
                });
                ret = JOptionPane.showOptionDialog(App.settings.getParent(), jEditorPane, Language.INSTANCE.localize("common.reinstalling") + " " + this.pack.getName(), -1, 2, null, options, options[0]);
                if (ret != 0) {
                    LogManager.error("Instance Install Cancelled After Viewing Message!");
                    this.cancel(true);
                    return false;
                }
            }
        } else if (this.pack.getInstallMessage(this.version.getVersion()) != null) {
            if (this.isCancelled()) {
                return false;
            }
            options = new String[]{Language.INSTANCE.localize("common.ok"), Language.INSTANCE.localize("common.cancel")};
            JEditorPane jEditorPane = new JEditorPane("text/html", "<html>" + this.pack.getInstallMessage(this.version.getVersion()) + "</html>");
            jEditorPane.setEditable(false);
            jEditorPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        Utils.openBrowser(e.getURL());
                    }
                }
            });
            ret = JOptionPane.showOptionDialog(App.settings.getParent(), jEditorPane, Language.INSTANCE.localize("common.installing") + " " + this.pack.getName(), -1, 2, null, options, options[0]);
            if (ret != 0) {
                LogManager.error("Instance Install Cancelled After Viewing Message!");
                this.cancel(true);
                return false;
            }
        }
        this.allMods = this.sortMods(this.pack.getMods(this.version.getVersion(), this.isServer));
        this.loadActions();
        this.permgen = this.pack.getPermGen(this.version.getVersion());
        this.memory = this.pack.getMemory(this.version.getVersion());
        this.caseAllFiles = this.pack.getCaseAllFiles(this.version.getVersion());
        this.selectedMods = new ArrayList<Mod>();
        if (this.allMods.size() != 0 && this.hasOptionalMods()) {
            ModsChooser modsChooser = new ModsChooser(this);
            modsChooser.setVisible(true);
            if (modsChooser.wasClosed()) {
                this.cancel(true);
                return false;
            }
            this.selectedMods = modsChooser.getSelectedMods();
        }
        if (!this.hasOptionalMods()) {
            this.selectedMods = this.allMods;
        }
        this.modsInstalled = new ArrayList<DisableableMod>();
        for (Mod mod : this.selectedMods) {
            String file = mod.getFile();
            if (this.caseAllFiles != null) {
                if (this.caseAllFiles.equalsIgnoreCase("upper")) {
                    file = file.substring(0, file.lastIndexOf(".")).toUpperCase() + file.substring(file.lastIndexOf("."));
                } else if (this.caseAllFiles.equalsIgnoreCase("lower")) {
                    file = file.substring(0, file.lastIndexOf(".")).toLowerCase() + file.substring(file.lastIndexOf("."));
                }
            }
            this.modsInstalled.add(new DisableableMod(mod.getName(), mod.getVersion(), mod.isOptional(), file, mod.getType(), mod.getColour(), mod.getDescription(), false, false));
        }
        if (this.isReinstall && this.instance.getMinecraftVersion().equalsIgnoreCase(this.version.getMinecraftVersion().getVersion()) && this.instance.hasCustomMods()) {
            for (DisableableMod disableableMod : this.instance.getCustomDisableableMods()) {
                this.modsInstalled.add(disableableMod);
            }
        }
        this.instanceIsCorrupt = true;
        this.getTempDirectory().mkdirs();
        this.backupSelectFiles();
        this.makeDirectories();
        this.addPercent(5);
        this.setMainClass();
        this.setExtraArguments();
        if (this.version.getMinecraftVersion().hasResources()) {
            this.downloadResources();
            if (this.isCancelled()) {
                return false;
            }
        }
        this.downloadLibraries();
        if (this.isCancelled()) {
            return false;
        }
        this.organiseLibraries();
        if (this.isCancelled()) {
            return false;
        }
        if (this.isServer) {
            for (File file : this.serverLibraries) {
                file.mkdirs();
                Utils.copyFile(new File(App.settings.getLibrariesDir(), file.getName()), file, true);
            }
        }
        this.addPercent(5);
        if (this.isServer && this.hasJarMods()) {
            this.fireTask(Language.INSTANCE.localize("server.extractingjar"));
            this.fireSubProgressUnknown();
            Utils.unzip(this.getMinecraftJar(), this.getTempJarDirectory());
        }
        if (!this.isServer && this.hasJarMods() && !this.hasForge()) {
            this.deleteMetaInf();
        }
        this.addPercent(5);
        if (this.selectedMods.size() != 0) {
            this.addPercent(40);
            this.fireTask(Language.INSTANCE.localize("instance.downloadingmods"));
            this.downloadMods(this.selectedMods);
            if (this.isCancelled()) {
                return false;
            }
            this.addPercent(40);
            this.installMods();
        } else {
            this.addPercent(80);
        }
        if (this.isCancelled()) {
            return false;
        }
        this.doCaseConversions(this.getModsDirectory());
        if (this.isServer && this.hasJarMods()) {
            this.fireTask(Language.INSTANCE.localize("server.zippingjar"));
            this.fireSubProgressUnknown();
            Utils.zip(this.getTempJarDirectory(), this.getMinecraftJar());
        }
        if (this.extractedTexturePack) {
            this.fireTask(Language.INSTANCE.localize("instance.zippingtexturepackfiles"));
            this.fireSubProgressUnknown();
            if (!this.getTexturePacksDirectory().exists()) {
                this.getTexturePacksDirectory().mkdir();
            }
            Utils.zip(this.getTempTexturePackDirectory(), new File(this.getTexturePacksDirectory(), "TexturePack.zip"));
        }
        if (this.extractedResourcePack) {
            this.fireTask(Language.INSTANCE.localize("instance.zippingresourcepackfiles"));
            this.fireSubProgressUnknown();
            if (!this.getResourcePacksDirectory().exists()) {
                this.getResourcePacksDirectory().mkdir();
            }
            Utils.zip(this.getTempResourcePackDirectory(), new File(this.getResourcePacksDirectory(), "ResourcePack.zip"));
        }
        if (this.isCancelled()) {
            return false;
        }
        if (this.hasActions()) {
            this.doActions();
        }
        if (this.isCancelled()) {
            return false;
        }
        if (this.pack.hasConfigs(this.version.getVersion())) {
            this.configurePack();
        }
        if (App.settings.getCommonConfigsDir().listFiles().length != 0) {
            Utils.copyDirectory(App.settings.getCommonConfigsDir(), this.getRootDirectory());
        }
        this.restoreSelectFiles();
        if (this.isServer) {
            Utils.replaceText(new File(App.settings.getLibrariesDir(), "LaunchServer.bat"), new File(this.getRootDirectory(), "LaunchServer.bat"), "%%SERVERJAR%%", this.getServerJar());
            Utils.replaceText(new File(App.settings.getLibrariesDir(), "LaunchServer.sh"), new File(this.getRootDirectory(), "LaunchServer.sh"), "%%SERVERJAR%%", this.getServerJar());
        }
        return true;
    }

    @Override
    protected Boolean doInBackground() throws Exception {
        LogManager.info("Started install of " + this.pack.getName() + " - " + this.version);
        if (App.experimentalJson) {
            LogManager.debug("Experimental JSON is enabled, using the JSON file!");
            try {
                this.jsonVersion = Settings.gson.fromJson(this.pack.getJSON(this.version.getVersion()), Version.class);
                return this.installUsingJSON();
            }
            catch (JsonSyntaxException e) {
                App.settings.logStackTrace("Couldn't read JSON of pack! Report this to the pack's developer/s and NOT ATLauncher!", e);
            }
            catch (JsonParseException e) {
                App.settings.logStackTrace("Couldn't parse JSON of pack! Report this to the pack's developer/s and NOT ATLauncher!", e);
            }
        }
        return this.installUsingXML();
    }

    private void setMainClass() {
        if (this.pack.getMainClassDepends(this.version.getVersion()) != null) {
            String depends = this.pack.getMainClassDepends(this.version.getVersion());
            boolean found = false;
            for (Mod mod : this.selectedMods) {
                if (!mod.getName().equals(depends)) continue;
                found = true;
            }
            if (found) {
                this.mainClass = this.pack.getMainClass(this.version.getVersion());
            }
        } else if (this.pack.getMainClassDependsGroup(this.version.getVersion()) != null) {
            String depends = this.pack.getMainClassDependsGroup(this.version.getVersion());
            boolean found = false;
            for (Mod mod : this.selectedMods) {
                if (!mod.hasGroup() || !mod.getGroup().equals(depends)) continue;
                found = true;
            }
            if (found) {
                this.mainClass = this.pack.getMainClass(this.version.getVersion());
            }
        } else {
            this.mainClass = this.pack.getMainClass(this.version.getVersion());
        }
        if (this.mainClass == null) {
            this.mainClass = this.version.getMinecraftVersion().getMojangVersion().getMainClass();
        }
    }

    private void setJsonMainClass() {
        if (this.jsonVersion.hasMainClass()) {
            if (!this.jsonVersion.getMainClass().hasDepends() && !this.jsonVersion.getMainClass().hasDependsGroup()) {
                this.mainClass = this.jsonVersion.getMainClass().getMainClass();
            } else if (this.jsonVersion.getMainClass().hasDepends()) {
                String depends = this.jsonVersion.getMainClass().getDepends();
                boolean found = false;
                for (com.atlauncher.data.json.Mod mod : this.selectedJsonMods) {
                    if (!mod.getName().equals(depends)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    this.mainClass = this.jsonVersion.getMainClass().getMainClass();
                }
            } else if (this.jsonVersion.getMainClass().hasDependsGroup()) {
                String depends = this.jsonVersion.getMainClass().getDependsGroup();
                boolean found = false;
                for (com.atlauncher.data.json.Mod mod : this.selectedJsonMods) {
                    if (!mod.hasGroup() || !mod.getGroup().equals(depends)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    this.mainClass = this.jsonVersion.getMainClass().getMainClass();
                }
            }
        }
        if (this.mainClass == null) {
            this.mainClass = this.version.getMinecraftVersion().getMojangVersion().getMainClass();
        }
    }

    private void setExtraArguments() {
        if (this.pack.getExtraArgumentsDepends(this.version.getVersion()) != null) {
            String depends = this.pack.getExtraArgumentsDepends(this.version.getVersion());
            boolean found = false;
            for (Mod mod : this.selectedMods) {
                if (!mod.getName().equals(depends)) continue;
                found = true;
            }
            if (found) {
                this.extraArguments = this.pack.getExtraArguments(this.version.getVersion());
            }
        } else if (this.pack.getExtraArgumentsDependsGroup(this.version.getVersion()) != null) {
            String depends = this.pack.getExtraArgumentsDependsGroup(this.version.getVersion());
            boolean found = false;
            for (Mod mod : this.selectedMods) {
                if (!mod.hasGroup() || !mod.getGroup().equals(depends)) continue;
                found = true;
            }
            if (found) {
                this.extraArguments = this.pack.getExtraArguments(this.version.getVersion());
            }
        } else {
            this.extraArguments = this.pack.getExtraArguments(this.version.getVersion());
        }
    }

    private void setJsonExtraArguments() {
        if (this.jsonVersion.hasExtraArguments()) {
            if (!this.jsonVersion.getExtraArguments().hasDepends() && !this.jsonVersion.getExtraArguments().hasDependsGroup()) {
                this.extraArguments = this.jsonVersion.getExtraArguments().getArguments();
            } else if (this.jsonVersion.getExtraArguments().hasDepends()) {
                String depends = this.jsonVersion.getExtraArguments().getDepends();
                boolean found = false;
                for (com.atlauncher.data.json.Mod mod : this.selectedJsonMods) {
                    if (!mod.getName().equals(depends)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    this.extraArguments = this.jsonVersion.getExtraArguments().getArguments();
                }
            } else if (this.jsonVersion.getMainClass().hasDependsGroup()) {
                String depends = this.jsonVersion.getMainClass().getDependsGroup();
                boolean found = false;
                for (com.atlauncher.data.json.Mod mod : this.selectedJsonMods) {
                    if (!mod.hasGroup() || !mod.getGroup().equals(depends)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    this.extraArguments = this.jsonVersion.getExtraArguments().getArguments();
                }
            }
        }
    }

    public void resetDownloadedBytes(int bytes) {
        this.totalBytes = bytes;
        this.downloadedBytes = 0;
    }

    public void fireTask(String name) {
        this.firePropertyChange("doing", null, name);
    }

    private void fireProgress(int percent) {
        if (percent > 100) {
            percent = 100;
        }
        this.firePropertyChange("progress", null, percent);
    }

    private void fireSubProgress(int percent) {
        if (percent > 100) {
            percent = 100;
        }
        this.firePropertyChange("subprogress", null, percent);
    }

    private void fireSubProgress(int percent, String paint) {
        if (percent > 100) {
            percent = 100;
        }
        String[] info = new String[]{"" + percent, paint};
        this.firePropertyChange("subprogress", null, info);
    }

    public void fireSubProgressUnknown() {
        this.firePropertyChange("subprogressint", null, null);
    }

    private void addPercent(int percent) {
        this.percent += percent;
        if (this.percent > 100) {
            this.percent = 100;
        }
        this.fireProgress(this.percent);
    }

    public void setSubPercent(int percent) {
        if (percent > 100) {
            percent = 100;
        }
        this.fireSubProgress(percent);
    }

    public void setDownloadDone() {
        ++this.doneDownloads;
        float progress = this.totalDownloads > 0 ? (float)this.doneDownloads / (float)this.totalDownloads * 100.0f : 0.0f;
        this.fireSubProgress((int)progress);
    }

    public void addDownloadedBytes(int bytes) {
        this.downloadedBytes += bytes;
        this.updateProgressBar();
    }

    public void addTotalDownloadedBytes(int bytes) {
        this.totalBytes += bytes;
        this.updateProgressBar();
    }

    private void updateProgressBar() {
        float progress = this.totalBytes > 0 ? (float)this.downloadedBytes / (float)this.totalBytes * 100.0f : 0.0f;
        float done = (float)this.downloadedBytes / 1024.0f / 1024.0f;
        float toDo = (float)this.totalBytes / 1024.0f / 1024.0f;
        if (done > toDo) {
            this.fireSubProgress(100, String.format("%.2f MB", Float.valueOf(done)));
        } else {
            this.fireSubProgress((int)progress, String.format("%.2f MB / %.2f MB", Float.valueOf(done), Float.valueOf(toDo)));
        }
    }
}

