/*
 * Decompiled with CFR 0.152.
 */
package de.zh32.pingtest;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;

public class ServerListPing17 {
    private InetSocketAddress host;
    private int timeout = 7000;
    private Gson gson = new Gson();

    public InetSocketAddress getHost() {
        return this.host;
    }

    public void setHost(InetSocketAddress host) {
        this.host = host;
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }

    public void setAddress(InetSocketAddress host) {
        this.host = host;
    }

    public InetSocketAddress getAddress() {
        return this.host;
    }

    void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    int getTimeout() {
        return this.timeout;
    }

    public int readVarInt(DataInputStream in) throws IOException {
        byte k;
        int i = 0;
        int j = 0;
        do {
            k = in.readByte();
            i |= (k & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((k & 0x80) == 128);
        return i;
    }

    public void writeVarInt(DataOutputStream out, int paramInt) throws IOException {
        while (true) {
            if ((paramInt & 0xFFFFFF80) == 0) {
                out.writeByte(paramInt);
                return;
            }
            out.writeByte(paramInt & 0x7F | 0x80);
            paramInt >>>= 7;
        }
    }

    public StatusResponse fetchData() throws IOException {
        Socket socket = new Socket();
        socket.setSoTimeout(this.timeout);
        socket.connect(this.host, this.timeout);
        OutputStream outputStream = socket.getOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        InputStream inputStream = socket.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DataOutputStream handshake = new DataOutputStream(b);
        handshake.writeByte(0);
        this.writeVarInt(handshake, 4);
        this.writeVarInt(handshake, this.host.getAddress().getHostAddress().length());
        handshake.writeBytes(this.host.getAddress().getHostAddress());
        handshake.writeShort(this.host.getPort());
        this.writeVarInt(handshake, 1);
        this.writeVarInt(dataOutputStream, b.size());
        dataOutputStream.write(b.toByteArray());
        dataOutputStream.writeByte(1);
        dataOutputStream.writeByte(0);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int size = this.readVarInt(dataInputStream);
        int id = this.readVarInt(dataInputStream);
        if (id == -1) {
            socket.close();
            throw new IOException("Premature end of stream.");
        }
        if (id != 0) {
            socket.close();
            throw new IOException("Invalid packetID");
        }
        int length = this.readVarInt(dataInputStream);
        if (length == -1) {
            socket.close();
            throw new IOException("Premature end of stream.");
        }
        if (length == 0) {
            socket.close();
            throw new IOException("Invalid string length.");
        }
        byte[] in = new byte[length];
        dataInputStream.readFully(in);
        String json = new String(in);
        StatusResponse response = null;
        try {
            response = this.gson.fromJson(json, StatusResponseOld.class);
        }
        catch (JsonSyntaxException jse) {
            response = this.gson.fromJson(json, StatusResponseNew.class);
        }
        if (response == null) {
            socket.close();
            throw new IOException("Cannot parse JSON.");
        }
        try {
            long now = System.currentTimeMillis();
            dataOutputStream.writeByte(9);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeLong(now);
            this.readVarInt(dataInputStream);
            id = this.readVarInt(dataInputStream);
            if (id == -1) {
                socket.close();
                throw new IOException("Premature end of stream.");
            }
            if (id != 1) {
                socket.close();
                throw new IOException("Invalid packetID");
            }
            long pingtime = dataInputStream.readLong();
            response.setTime((int)(now - pingtime));
        }
        catch (IOException exception) {
            // empty catch block
        }
        dataOutputStream.close();
        outputStream.close();
        inputStreamReader.close();
        inputStream.close();
        socket.close();
        return response;
    }

    public class Version {
        private String name;
        private String protocol;

        public String getName() {
            return this.name;
        }

        public String getProtocol() {
            return this.protocol;
        }
    }

    public class Player {
        private String name;
        private String id;

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }
    }

    public class Players {
        private int max;
        private int online;
        private List<Player> sample;

        public int getMax() {
            return this.max;
        }

        public int getOnline() {
            return this.online;
        }

        public List<Player> getSample() {
            return this.sample;
        }
    }

    public class Description {
        private String text;

        public String getText() {
            return this.text;
        }
    }

    public class StatusResponseNew
    implements StatusResponse {
        private Description description;
        private Players players;
        private Version version;
        private String favicon;
        private int time;

        @Override
        public String getDescription() {
            return this.description.getText();
        }

        @Override
        public Players getPlayers() {
            return this.players;
        }

        @Override
        public Version getVersion() {
            return this.version;
        }

        @Override
        public String getFavicon() {
            return this.favicon;
        }

        @Override
        public int getTime() {
            return this.time;
        }

        @Override
        public void setTime(int time) {
            this.time = time;
        }
    }

    public class StatusResponseOld
    implements StatusResponse {
        private String description;
        private Players players;
        private Version version;
        private String favicon;
        private int time;

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Players getPlayers() {
            return this.players;
        }

        @Override
        public Version getVersion() {
            return this.version;
        }

        @Override
        public String getFavicon() {
            return this.favicon;
        }

        @Override
        public int getTime() {
            return this.time;
        }

        @Override
        public void setTime(int time) {
            this.time = time;
        }
    }

    public static interface StatusResponse {
        public String getDescription();

        public Players getPlayers();

        public Version getVersion();

        public String getFavicon();

        public int getTime();

        public void setTime(int var1);
    }
}

