/*
 * Decompiled with CFR 0.152.
 */
package de.zh32.pingtest;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;

public class ServerListPingB18 {
    private InetSocketAddress address;
    private int timeout = 2500;
    private String motd;
    private int playersOnline = -1;
    private int maxPlayers = -1;

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetSocketAddress address) {
        this.address = address;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getMotd() {
        return this.motd;
    }

    public void setMotd(String motd) {
        this.motd = motd;
    }

    public int getPlayersOnline() {
        return this.playersOnline;
    }

    public void setPlayersOnline(int playersOnline) {
        this.playersOnline = playersOnline;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    public boolean fetchData() throws Exception {
        Socket socket = new Socket();
        socket.setSoTimeout(this.timeout);
        socket.setKeepAlive(false);
        socket.connect(this.address, this.getTimeout());
        OutputStream outputStream = socket.getOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        InputStream inputStream = socket.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, Charset.forName("UTF-16BE"));
        dataOutputStream.write(new byte[]{-2});
        int packetId = inputStream.read();
        if (packetId == -1) {
            socket.close();
            throw new IOException("Premature end of stream.");
        }
        if (packetId != 255) {
            socket.close();
            throw new IOException("Invalid packet ID (" + packetId + ").");
        }
        int length = inputStreamReader.read();
        if (length == -1) {
            socket.close();
            throw new IOException("Premature end of stream.");
        }
        if (length == 0) {
            socket.close();
            throw new IOException("Invalid string length.");
        }
        char[] chars = new char[length];
        if (inputStreamReader.read(chars, 0, length) != length) {
            socket.close();
            throw new IOException("Premature end of stream.");
        }
        String string = new String(chars);
        String[] data = string.split("\u00c2\u00a7");
        this.motd = data[0];
        this.playersOnline = Integer.parseInt(data[1]);
        this.maxPlayers = Integer.parseInt(data[2]);
        dataOutputStream.close();
        outputStream.close();
        inputStreamReader.close();
        inputStream.close();
        socket.close();
        return true;
    }
}

