/*
 * Decompiled with CFR 0.152.
 */
package io.github.asyncronous.toast;

import io.github.asyncronous.toast.ui.ToastWindow;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public final class Toaster {
    private static Toaster instance;
    public static volatile int CURRENT_TOASTER_NUMBER;
    public static volatile int MAX_TOASTER_IN_SCREEN;
    public static volatile int MAX_TOASTERS;

    public static Toaster instance() {
        return instance == null ? (instance = new Toaster()) : instance;
    }

    private Toaster() {
        UIManager.put("Toaster.infoIcon", this.createImage("info"));
        UIManager.put("Toaster.errorIcon", this.createImage("error"));
        UIManager.put("Toaster.questionIcon", this.createImage("question"));
        UIManager.put("Toaster.warningIcon", this.createImage("warning"));
        UIManager.put("Toaster.font", new Font("SansSerif", 1, 12).deriveFont(24.0f));
        UIManager.put("Toaster.msgColor", Color.BLACK);
        UIManager.put("Toaster.borderColor", Color.BLACK);
        UIManager.put("Toaster.bgColor", Color.WHITE);
        UIManager.put("Toaster.time", 5000);
        UIManager.put("Toaster.opaque", false);
        UIManager.put("Toaster.opacity", Float.valueOf(0.5f));
        UIManager.put("Toaster.contBounds", GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds());
    }

    public void popQuestion(String msg) {
        ToastWindow window = new ToastWindow();
        window.setText(msg);
        window.setIcon(new ImageIcon((Image)UIManager.get("Toaster.questionIcon")));
        window.pop();
    }

    public void pop(String msg) {
        ToastWindow window = new ToastWindow();
        window.setText(msg);
        window.setIcon(new ImageIcon((Image)UIManager.get("Toaster.infoIcon")));
        window.pop();
    }

    public void popWarning(String msg) {
        ToastWindow window = new ToastWindow();
        window.setText(msg);
        window.setIcon(new ImageIcon((Image)UIManager.get("Toaster.warningIcon")));
        window.pop();
    }

    public void popError(String msg) {
        ToastWindow window = new ToastWindow();
        window.setText(msg);
        window.setIcon(new ImageIcon((Image)UIManager.get("Toaster.errorIcon")));
        window.pop();
    }

    public void pop(String msg, Icon ico) {
        ToastWindow window = new ToastWindow();
        window.setText(msg);
        window.setIcon(ico);
        window.pop();
    }

    private Image createImage(String name) {
        try {
            InputStream stream = Toaster.class.getResourceAsStream("/assets/toast/icons/" + name + ".png");
            if (stream == null) {
                throw new NullPointerException("Stream == null");
            }
            return ImageIO.read(stream);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return null;
        }
    }

    static {
        CURRENT_TOASTER_NUMBER = 0;
        MAX_TOASTER_IN_SCREEN = 0;
        MAX_TOASTERS = 0;
    }
}

