/*
 * Decompiled with CFR 0.152.
 */
package io.github.asyncronous.toast.ui;

import com.atlauncher.utils.Utils;
import io.github.asyncronous.toast.thread.ToastAnimator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import javax.swing.UIManager;

public final class ToastWindow
extends JWindow {
    private final JLabel ICON = new JLabel();
    private final JTextArea MESSAGE = new JTextArea();

    public ToastWindow() {
        this.MESSAGE.setFont((Font)UIManager.get("Toaster.font"));
        this.MESSAGE.setBackground((Color)UIManager.get("Toaster.bgColor"));
        this.MESSAGE.setForeground((Color)UIManager.get("Toaster.msgColor"));
        this.MESSAGE.setLineWrap(true);
        this.MESSAGE.setEditable(false);
        this.MESSAGE.setMargin(new Insets(2, 2, 2, 2));
        this.MESSAGE.setWrapStyleWord(true);
        if (!((Boolean)UIManager.get("Toaster.opaque")).booleanValue() && Utils.isJava7OrAbove(false) && GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT)) {
            this.setOpacity(((Float)UIManager.get("Toaster.opacity")).floatValue());
        }
        JPanel CONTENT_PANEL = new JPanel(new BorderLayout(1, 1));
        CONTENT_PANEL.setBackground((Color)UIManager.get("Toaster.borderColor"));
        JPanel WRAPPER_PANEL = new JPanel(new BorderLayout(2, 2));
        WRAPPER_PANEL.setBackground((Color)UIManager.get("Toaster.bgColor"));
        WRAPPER_PANEL.add((Component)this.ICON, "West");
        WRAPPER_PANEL.add((Component)this.MESSAGE, "Center");
        CONTENT_PANEL.setBorder(BorderFactory.createEtchedBorder());
        CONTENT_PANEL.add(WRAPPER_PANEL);
        this.setFocusable(false);
        this.setAlwaysOnTop(true);
        this.setLocationRelativeTo(null);
        this.setMinimumSize(new Dimension(250, 100));
        this.getContentPane().add(CONTENT_PANEL);
        this.pack();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ToastWindow.this.setVisible(false);
                ToastWindow.this.dispose();
            }
        });
    }

    public void setText(String text) {
        this.MESSAGE.setText(text);
    }

    public String getText() {
        return this.MESSAGE.getText();
    }

    public void setIcon(Icon icon) {
        this.ICON.setIcon(icon);
    }

    public Icon getIcon() {
        return this.ICON.getIcon();
    }

    public void pop() {
        new ToastAnimator(this).execute();
    }
}

