/*
 * Decompiled with CFR 0.152.
 */
package modmuss50.mods.CustomPacks;

import com.atlauncher.App;
import com.atlauncher.LogManager;
import com.atlauncher.data.Language;
import com.atlauncher.data.Pack;
import com.atlauncher.gui.dialogs.InstanceInstallerDialog;
import com.atlauncher.gui.tabs.Tab;
import com.atlauncher.gui.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import modmuss50.mods.CustomPacks.IMod;
import modmuss50.mods.CustomPacks.IRepo;
import modmuss50.mods.CustomPacks.ModSanner;
import modmuss50.mods.CustomPacks.SelectMods;
import modmuss50.mods.CustomPacks.UploadPackCode;

public class CustomPacksTab
extends JPanel
implements Tab {
    public static ArrayList<IMod> modsToUse = new ArrayList();
    public static int selectedrepo = 0;
    JButton selectmods = new JButton("Select mods");
    JButton loadModsFromCode = new JButton("Load mods from code");
    JButton make = new JButton("Get my pack code");
    JButton install = new JButton("Install");
    JLabel ammoutOfMods = new JLabel("Amout of mods in pack: " + modsToUse.size());
    JLabel minecraftVersion = new JLabel("Minecraft version: NONE");
    JLabel forgeVersion = new JLabel("Minecraft forge version: NONE");
    JComboBox<String> repoVersion = new JComboBox();
    JLabel commingSoon = new JLabel("This is coming soon! Hang tight!");
    private JPanel bottomPanel;
    private JPanel topPanel;
    private JPanel middlePanel;

    public CustomPacksTab() {
        super(new BorderLayout());
        try {
            ModSanner.loadRepo();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (IRepo repo : ModSanner.repoVersions) {
            this.repoVersion.addItem(repo.version());
        }
        try {
            ModSanner.loadCustomMods(this.repoVersion.getSelectedItem().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        selectedrepo = 0;
        this.topPanel = new JPanel();
        this.repoVersion.setFont(Theme.DEFAULT_THEME.getDefaultFont().deriveFont(10.0f));
        this.topPanel.add(this.repoVersion);
        this.topPanel.add(this.loadModsFromCode);
        this.topPanel.add(this.selectmods);
        this.ammoutOfMods.setFont(Theme.DEFAULT_THEME.getDefaultFont().deriveFont(15.0f));
        this.topPanel.add(this.ammoutOfMods);
        this.add((Component)this.topPanel, "North");
        this.middlePanel = new JPanel();
        this.minecraftVersion.setFont(Theme.DEFAULT_THEME.getDefaultFont().deriveFont(15.0f));
        this.middlePanel.add(this.minecraftVersion);
        this.forgeVersion.setFont(Theme.DEFAULT_THEME.getDefaultFont().deriveFont(15.0f));
        this.middlePanel.add(this.forgeVersion);
        this.add((Component)this.middlePanel, "Center");
        this.bottomPanel = new JPanel();
        this.bottomPanel.add(this.make);
        this.bottomPanel.add(this.install);
        this.add((Component)this.bottomPanel, "South");
        this.make.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                System.out.println(CustomPacksTab.this.getPackCode());
                JTextArea textarea = new JTextArea(CustomPacksTab.this.getPackCode());
                textarea.setEditable(true);
                JOptionPane.showMessageDialog(null, textarea, "Your custom packcode!", 1);
            }
        });
        this.install.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (modsToUse.size() == 0) {
                    JOptionPane.showMessageDialog(null, "Please select 1 or more mods to install and use");
                    return;
                }
                if (App.settings.isInOfflineMode()) {
                    Object[] options = new String[]{Language.INSTANCE.localize("common.ok")};
                    JOptionPane.showOptionDialog(App.settings.getParent(), Language.INSTANCE.localize("pack.offlinenewinstance"), Language.INSTANCE.localize("common.offline"), -1, 0, null, options, options[0]);
                } else {
                    List<Pack> packs = App.settings.getPacks();
                    Pack packi = null;
                    for (Pack pack : packs) {
                        if (pack.getID() != 3) continue;
                        packi = pack;
                    }
                    if (App.settings.getAccount() == null) {
                        Object[] options = new String[]{Language.INSTANCE.localize("common.ok")};
                        JOptionPane.showOptionDialog(App.settings.getParent(), Language.INSTANCE.localize("instance.cannotcreate"), Language.INSTANCE.localize("instance.noaccountselected"), -1, 0, null, options, options[0]);
                    } else if (packi != null) {
                        new InstanceInstallerDialog((Object)packi, CustomPacksTab.this.getCurrentRepo().version() + " (Minecraft" + CustomPacksTab.this.getCurrentRepo().minecraftVersion() + ")");
                    }
                }
            }
        });
        this.loadModsFromCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame frame = new JFrame();
                String result = JOptionPane.showInputDialog(frame, (Object)"Enter Pack code:");
                String text = result;
                if (text == null || text.length() == 0) {
                    JOptionPane.showMessageDialog(null, "Please enter a pack code!");
                    return;
                }
                try {
                    text = CustomPacksTab.getText("http://rushmead.playat.ch/stikket/view/raw/" + text);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    return;
                }
                String[] split = text.split(":");
                String forgeverson = split[0];
                String repoVersion = split[1];
                System.out.println(text);
                if (!repoVersion.equals(CustomPacksTab.this.getCurrentRepo().version())) {
                    JOptionPane.showMessageDialog(null, "This mod pack was made with an old repo version. Please update the pack to the new version or change the repo version");
                    return;
                }
                for (int i = 2; i < split.length; ++i) {
                    try {
                        ModSanner.loadCustomMods(CustomPacksTab.this.getCurrentRepo().version());
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    for (IMod scannermod : ModSanner.customMods) {
                        if (!split[i].equals(scannermod.id())) continue;
                        modsToUse.add(scannermod);
                    }
                }
                CustomPacksTab.this.refresh();
            }
        });
        this.selectmods.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new SelectMods();
            }
        });
        this.repoVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ModSanner.loadCustomMods(CustomPacksTab.this.repoVersion.getSelectedItem().toString());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.refresh();
    }

    @Override
    public String getTitle() {
        return "Custom Pack";
    }

    @Override
    public String getIcon() {
        return "/assets/image/OldMinecraftIcon.png";
    }

    public void refresh() {
        this.ammoutOfMods.setText("Amount of mods in pack: " + modsToUse.size());
        this.repaint();
        this.topPanel.repaint();
        this.minecraftVersion.setText("Minecraft version:" + this.getCurrentRepo().minecraftVersion());
        this.forgeVersion.setText("Minecraft forge version: " + this.getCurrentRepo().forgeVersion());
    }

    public String getPackCode() {
        String code = "";
        code = code + this.getCurrentRepo().forgeVersion() + ":" + this.getCurrentRepo().version() + ":";
        for (int i = 0; i < modsToUse.size(); ++i) {
            IMod mod = modsToUse.get(i);
            code = code + mod.id() + ":";
        }
        code = code.substring(0, code.length() - 1);
        String url = "error";
        try {
            UploadPackCode.code = code;
            String result = App.TASKPOOL.submit(new UploadPackCode()).get();
            if (result.contains("http://rushmead.playat.ch/stikket/")) {
                result = result.replace("http://rushmead.playat.ch/stikket/view/", "");
                App.TOASTER.pop("Code uploaded and link copied to clipboard");
                LogManager.info("Code uploaded and link copied to clipboard: " + result);
                StringSelection text = new StringSelection(result);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(text, null);
                url = result;
            } else {
                App.TOASTER.popError("Code failed to upload!");
                LogManager.error("Code failed to upload: " + result);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        return url;
    }

    public IRepo getCurrentRepo() {
        return ModSanner.repoVersions.get(selectedrepo);
    }

    public static String getText(String url) throws Exception {
        String inputLine;
        URL website = new URL(url);
        URLConnection connection = website.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return response.toString();
    }
}

