/*
 * Decompiled with CFR 0.152.
 */
package modmuss50.mods.CustomPacks;

import com.atlauncher.App;
import com.atlauncher.data.Instance;
import com.atlauncher.data.Language;
import com.atlauncher.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import modmuss50.mods.CustomPacks.CustomPacksTab;
import modmuss50.mods.CustomPacks.GuiUtils;
import modmuss50.mods.CustomPacks.IMod;
import modmuss50.mods.CustomPacks.IModJCheckBox;
import modmuss50.mods.CustomPacks.ModSanner;

public class SelectMods
extends JDialog {
    private static final long serialVersionUID = 7004414192679481818L;
    private Instance instance;
    private JPanel bottomPanel;
    private JPanel enabledModsPanel;
    private JScrollPane scroller2;
    private JButton doneButton;
    private JLabel topLabelLeft;
    private ArrayList<IModJCheckBox> enabledMods;

    public SelectMods() {
        super(App.settings.getParent(), "Select mods", Dialog.ModalityType.APPLICATION_MODAL);
        this.setSize(550, 450);
        this.setLocationRelativeTo(App.settings.getParent());
        this.setLayout(new BorderLayout());
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                SelectMods.this.dispose();
            }
        });
        this.topLabelLeft = new JLabel(Language.INSTANCE.localize("instance.enabledmods"));
        this.topLabelLeft.setHorizontalAlignment(0);
        this.add((Component)this.topLabelLeft, "Center");
        this.enabledModsPanel = new JPanel();
        this.enabledModsPanel.setLayout(null);
        this.enabledModsPanel.setBackground(App.THEME.getModSelectionBackgroundColor());
        this.scroller2 = new JScrollPane(this.enabledModsPanel, 22, 31);
        this.scroller2.getVerticalScrollBar().setUnitIncrement(16);
        this.scroller2.setPreferredSize(new Dimension(275, 350));
        this.add(this.scroller2);
        this.bottomPanel = new JPanel();
        this.add((Component)this.bottomPanel, "South");
        this.doneButton = new JButton("Done");
        this.doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectMods.this.enableMods();
                GuiUtils.customPacksTab.refresh();
                SelectMods.this.dispose();
            }
        });
        this.bottomPanel.add(this.doneButton);
        this.loadMods();
        this.setVisible(true);
    }

    private void loadMods() {
        ArrayList<IMod> mods = ModSanner.customMods;
        this.enabledMods = new ArrayList();
        int eCount = 0;
        for (IMod mod : mods) {
            IModJCheckBox checkBox = null;
            int nameSize = this.getFontMetrics(Utils.getFont()).stringWidth(mod.name());
            checkBox = new IModJCheckBox(mod);
            checkBox.setBounds(0, eCount * 20, 400, 20);
            for (IMod iMod : CustomPacksTab.modsToUse) {
                if (!iMod.id().equals(mod.id())) continue;
                checkBox.setSelected(true);
            }
            this.enabledMods.add(checkBox);
            ++eCount;
        }
        for (int i = 0; i < this.enabledMods.size(); ++i) {
            IModJCheckBox checkBox = this.enabledMods.get(i);
            this.enabledModsPanel.add(checkBox);
        }
        this.enabledModsPanel.setPreferredSize(new Dimension(0, this.enabledMods.size() * 20));
    }

    private void enableMods() {
        ArrayList<IModJCheckBox> mods = new ArrayList<IModJCheckBox>(this.enabledMods);
        for (IModJCheckBox mod : mods) {
            if (mod.isSelected()) {
                if (CustomPacksTab.modsToUse.contains(mod.getMod())) continue;
                CustomPacksTab.modsToUse.add(mod.getMod());
                continue;
            }
            if (!CustomPacksTab.modsToUse.contains(mod.getMod())) continue;
            CustomPacksTab.modsToUse.remove(mod.getMod());
        }
        this.reloadPanels();
    }

    private void reloadPanels() {
        this.enabledModsPanel.removeAll();
        this.loadMods();
        this.enabledModsPanel.repaint();
    }
}

