﻿// Copyright (c) Strange Loop Games. All rights reserved.
// See LICENSE file in the project root for full license information.
// <auto-generated from AnimalTemplate.tt/>

namespace Eco.Mods.TechTree
{
    using System.Collections.Generic;
    using Eco.Core.Items;
    using Eco.Gameplay.Animals;
    using Eco.Simulation.Pathfinding.Internal;
    using Eco.Mods.Organisms;
    using Eco.Shared.Localization;
    using Eco.Shared.Math;
    using Vector3 = System.Numerics.Vector3;
    using Eco.Simulation.Agents;
    using Eco.Simulation.Types;
    using Eco.Shared.SharedTypes;
    using Eco.Shared.Items;
    using System.Linq;

    /// <summary>
    /// <para>Server side animal entity definition for "Elk".</para>
    /// <para>More information about AnimalEntity objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Animals.AnimalEntity.html</para>
    /// <remarks>
    /// This is an auto-generated class. Don't modify it! All your changes will be wiped with next update! Use Mods* partial methods instead for customization. 
    /// If you wish to modify this class, please create a new partial class or follow the instructions in the "UserCode" folder to override the entire file.
    /// </remarks>
    /// </summary>
    public partial class Elk : AnimalEntity
    {
        public Elk(Animal parent, Vector3 pos, bool corpse, bool sick, int herdId) : base(parent, pos, species, corpse, sick, herdId) { }
        static AnimalSpecies species;

        /// <summary>
        /// <para>Server side species definition for "Elk".</para>
        /// <para>More information about AnimalSpecies objects can be found at https://docs.play.eco/api/server/eco.simulation/Eco.Simulation.Types.AnimalSpecies.html</para>
        /// </summary>
        /// <inheritdoc/>
        [Ecopedia("Animals", "Mammals", createAsSubPage: true)]
        [Localized(false, true)]
        public class ElkSpecies : AnimalSpecies
        {
            public ElkSpecies() : base()
            {
                species = this; // Set the static species variable from our AnimalEntity instance to ourselves for lookup later
                this.InstanceType = typeof(Elk); // Define our instance type to be a typeof instance of our selves.

                // Define the species name, display name, and description here. These values will be used to represent the animal to the client user.
                this.Name = "Elk"; //noloc
                this.DisplayName = Localizer.DoStr("Elk");
                this.DisplayDescription = Localizer.DoStr("A majestic deer species found in forests and grasslands, characterized by its large antlers and brownish-gray coat. Male elk, also called bulls, grow and shed their antlers annually, which can reach up to 1.2 meters (4 feet) in length.");
                this.PathRegionType = PathRegionType.LargeAnimals;
                
                // Define what our species eats as object type representations as well as our calorie value.
                // If our species does not eat anything the FoodSources variable can represent an empty List object.
                this.FoodSources = new List<System.Type>()
                {
                    typeof(Huckleberry),
                    typeof(OceanSpray),
                    typeof(Fireweed),
                    typeof(Fern),
                    typeof(Beans),
                    typeof(Salal),
                    typeof(DeerLichen),
                };
                this.EatTags = "HerbivoreFeed";
                this.CalorieValue = 200;

                // Movement

                // Resources
                this.ResourceList = new List<SpeciesResource>()
                {
                    new SpeciesResource(typeof(ElkCarcassItem), new Range(1, 1)),
                };
                this.ResourceBonusAtGrowth = 0.9f;
                
                this.Health                      = 8.5f;
                this.PlayerDamage                = 200;
                this.AnimalDamage                = 1;
                this.MaxVisibilityDistance       = 25;
                this.TooCloseDistance            = 4;
                this.MinDistanceWithinHerd       = 2.5f;
                this.HerdRadius                  = 8;
                this.ChanceToAttack              = 0.4f;
                this.ChanceOfAlertNoise          = 0.25f;
                this.AttackRange                 = 1;
                this.AnimalSkittishness          = AnimalSkittishness.FleesCloseThreats;
                this.TolerateTramplePercent      = 0.2f;
                this.HerdSize                    = new (2,4);
                this.HeavyFootstep               = 0.5f;
                this.Flags                       |= SpeciesFlags.CanTakeFood;

                // Population Growth
                this.TimeTill50PercentCloserToMaxInHours = 24;
                this.MaxGrowthRatePerHour                = 0.3f;
                this.TimeToSpread1ToNeighborInHours      = 12;

                // Climate
                this.ReleasesCO2TonsPerDay = 0.02f;
            }
        }
    /*
/*

        */
    }
}
