﻿// Copyright (c) Strange Loop Games. All rights reserved.
// See LICENSE file in the project root for full license information.
// <auto-generated from AnimalTemplate.tt/>

namespace Eco.Mods.TechTree
{
    using System;
    using System.Collections.Generic;
    using Eco.Core.Items;
    using Eco.Gameplay.Animals;
    using Eco.Gameplay.GameActions;
    using Eco.Gameplay.Interactions;
    using Eco.Gameplay.Items;
    using Eco.Simulation.Pathfinding.Internal;
    using Eco.Mods.Organisms;
    using Eco.Shared.Localization;
    using Eco.Shared.Math;
    using Vector3 = System.Numerics.Vector3;
    using Eco.Shared.Networking;
    using Eco.Simulation.Agents;
    using Eco.Simulation.Types;
    using Range = Eco.Shared.Math.Range;
    using Eco.Shared.SharedTypes;
    using Eco.Shared.Items;
    using System.Linq;

    /// <summary>
    /// <para>Server side animal entity definition for "SnappingTurtle".</para>
    /// <para>More information about AnimalEntity objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Animals.AnimalEntity.html</para>
    /// <remarks>
    /// This is an auto-generated class. Don't modify it! All your changes will be wiped with next update! Use Mods* partial methods instead for customization. 
    /// If you wish to modify this class, please create a new partial class or follow the instructions in the "UserCode" folder to override the entire file.
    /// </remarks>
    /// </summary>
    public partial class SnappingTurtle : AnimalEntity
    {
        public SnappingTurtle(Animal parent, Vector3 pos, bool corpse, bool sick, int herdId) : base(parent, pos, species, corpse, sick, herdId) { }
        static AnimalSpecies species;

        /// <summary>
        /// <para>Server side species definition for "SnappingTurtle".</para>
        /// <para>More information about AnimalSpecies objects can be found at https://docs.play.eco/api/server/eco.simulation/Eco.Simulation.Types.AnimalSpecies.html</para>
        /// </summary>
        /// <inheritdoc/>
        [Ecopedia("Animals", "Reptiles", createAsSubPage: true)]
        [Localized(false, true)]
        public class SnappingTurtleSpecies : AnimalSpecies
        {
            public SnappingTurtleSpecies() : base()
            {
                species = this; // Set the static species variable from our AnimalEntity instance to ourselves for lookup later
                this.InstanceType = typeof(SnappingTurtle); // Define our instance type to be a typeof instance of our selves.

                // Define the species name, display name, and description here. These values will be used to represent the animal to the client user.
                this.Name = "SnappingTurtle"; //noloc
                this.DisplayName = Localizer.DoStr("Snapping Turtle");
                this.DisplayDescription = Localizer.DoStr("A freshwater turtle with a distinctive hooked beak and powerful jaws, known for their aggressive behavior and ability to live in a wide range of aquatic habitats.");
                this.PathRegionType = PathRegionType.LargeAnimals;
                
                // Define what our species eats as object type representations as well as our calorie value.
                // If our species does not eat anything the FoodSources variable can represent an empty List object.
                this.FoodSources = new List<System.Type>()
                {
                    typeof(Clam),
                    typeof(PeatMoss),
                    typeof(Bullrush),
                    typeof(FilmyFern),
                    typeof(Buttonbush),
                };
                this.EatTags = "";
                this.CalorieValue = 100;

                // Movement

                // Resources
                this.ResourceList = new List<SpeciesResource>()
                {
                    new SpeciesResource(typeof(SnappingTurtleCarcassItem), new Range(1, 1)),
                };
                this.ResourceBonusAtGrowth = 0.9f;
                
                this.Health                      = 4.5f;
                this.PlayerDamage                = 15;
                this.AnimalDamage                = 1;
                this.MaxVisibilityDistance       = 25;
                this.TooCloseDistance            = 4;
                this.MinDistanceWithinHerd       = 2.5f;
                this.HerdRadius                  = 8;
                this.AnimalSkittishness          = AnimalSkittishness.FleesCloseAnything;
                this.TolerateTramplePercent      = 0.2f;
                this.HerdSize                    = new (1,1);
                this.Flags                       |= SpeciesFlags.HidesInPlace;

                // Population Growth
                this.TimeTill50PercentCloserToMaxInHours = 24;
                this.MaxGrowthRatePerHour                = 0.3f;
                this.TimeToSpread1ToNeighborInHours      = 12;

                // Climate
                this.ReleasesCO2TonsPerDay = 0.02f;
            }
        }
    /*

        public override GameActionPack TryApplyDamage(GameActionPack pack, INetObject damager, float damage, InteractionTarget target, Item tool, out float damageReceived, Type damageDealer = null, float experienceMultiplier = 1f)
        {
            damage = Tortoise.BlockDamage(damager, damage, this);
            return base.TryApplyDamage(pack, damager, damage, target, tool, out damageReceived, damageDealer, experienceMultiplier);
        }

/*

        */
    }
}
