﻿
// Copyright (c) Strange Loop Games. All rights reserved.
// See LICENSE file in the project root for full license information.
// <auto-generated from BenefitTemplate.tt/>

namespace Eco.Mods.TechTree
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Linq;
    using Eco.Gameplay.Components;
    using Eco.Gameplay.Items;
    using Eco.Gameplay.Players;
    using Eco.Gameplay.Skills;
    using Eco.Mods.TechTree;
    using Eco.Shared.Items;
    using Eco.Shared.Localization;
    using Eco.Shared.Serialization;
    using Eco.Shared.Utils;
    using Eco.Shared.View;

    /// <summary>
    /// <para>Server side talent definition for "LavishWorkspace".</para>
    /// <para>More information about Talent objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.Talent.html</para>
    /// <remarks>
    /// This is an auto-generated class. Don't modify it! All your changes will be wiped with next update! Use Mods* partial methods instead for customization. 
    /// If you wish to modify this class, please create a new partial class or follow the instructions in the "UserCode" folder to override the entire file.
    /// </remarks>
    /// </summary>
    public partial class LavishWorkspaceTalent : Talent
    {
        public override bool Base => true;
        public override Type TalentType { get { return typeof(CraftingTalent); } }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: Composites")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class CompositesLavishWorkspaceTalentGroup : TalentGroup
    {
        public CompositesLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(CompositesLavishResourcesTalent),
                typeof(CompositesLavishReqTalent),
            };
            this.OwningSkill = typeof(CompositesSkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class CompositesLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(CompositesLavishWorkspaceTalentGroup); } }
        public CompositesLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class CompositesLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(CompositesLavishWorkspaceTalentGroup); } }
        public CompositesLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: AdvancedBaking")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class AdvancedBakingLavishWorkspaceTalentGroup : TalentGroup
    {
        public AdvancedBakingLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(AdvancedBakingLavishResourcesTalent),
                typeof(AdvancedBakingLavishReqTalent),
            };
            this.OwningSkill = typeof(AdvancedBakingSkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class AdvancedBakingLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(AdvancedBakingLavishWorkspaceTalentGroup); } }
        public AdvancedBakingLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class AdvancedBakingLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(AdvancedBakingLavishWorkspaceTalentGroup); } }
        public AdvancedBakingLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: CampfireCooking")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class CampfireCookingLavishWorkspaceTalentGroup : TalentGroup
    {
        public CampfireCookingLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(CampfireCookingLavishResourcesTalent),
                typeof(CampfireCookingLavishReqTalent),
            };
            this.OwningSkill = typeof(CampfireCookingSkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class CampfireCookingLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(CampfireCookingLavishWorkspaceTalentGroup); } }
        public CampfireCookingLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class CampfireCookingLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(CampfireCookingLavishWorkspaceTalentGroup); } }
        public CampfireCookingLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: AdvancedCooking")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class AdvancedCookingLavishWorkspaceTalentGroup : TalentGroup
    {
        public AdvancedCookingLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(AdvancedCookingLavishResourcesTalent),
                typeof(AdvancedCookingLavishReqTalent),
            };
            this.OwningSkill = typeof(AdvancedCookingSkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class AdvancedCookingLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(AdvancedCookingLavishWorkspaceTalentGroup); } }
        public AdvancedCookingLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class AdvancedCookingLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(AdvancedCookingLavishWorkspaceTalentGroup); } }
        public AdvancedCookingLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: AdvancedSmelting")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class AdvancedSmeltingLavishWorkspaceTalentGroup : TalentGroup
    {
        public AdvancedSmeltingLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(AdvancedSmeltingLavishResourcesTalent),
                typeof(AdvancedSmeltingLavishReqTalent),
            };
            this.OwningSkill = typeof(AdvancedSmeltingSkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class AdvancedSmeltingLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(AdvancedSmeltingLavishWorkspaceTalentGroup); } }
        public AdvancedSmeltingLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class AdvancedSmeltingLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(AdvancedSmeltingLavishWorkspaceTalentGroup); } }
        public AdvancedSmeltingLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: Baking")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class BakingLavishWorkspaceTalentGroup : TalentGroup
    {
        public BakingLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(BakingLavishResourcesTalent),
                typeof(BakingLavishReqTalent),
            };
            this.OwningSkill = typeof(BakingSkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class BakingLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(BakingLavishWorkspaceTalentGroup); } }
        public BakingLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class BakingLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(BakingLavishWorkspaceTalentGroup); } }
        public BakingLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: BasicEngineering")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class BasicEngineeringLavishWorkspaceTalentGroup : TalentGroup
    {
        public BasicEngineeringLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(BasicEngineeringLavishResourcesTalent),
                typeof(BasicEngineeringLavishReqTalent),
            };
            this.OwningSkill = typeof(BasicEngineeringSkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class BasicEngineeringLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(BasicEngineeringLavishWorkspaceTalentGroup); } }
        public BasicEngineeringLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class BasicEngineeringLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(BasicEngineeringLavishWorkspaceTalentGroup); } }
        public BasicEngineeringLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: Pottery")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class PotteryLavishWorkspaceTalentGroup : TalentGroup
    {
        public PotteryLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(PotteryLavishResourcesTalent),
                typeof(PotteryLavishReqTalent),
            };
            this.OwningSkill = typeof(PotterySkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class PotteryLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(PotteryLavishWorkspaceTalentGroup); } }
        public PotteryLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class PotteryLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(PotteryLavishWorkspaceTalentGroup); } }
        public PotteryLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: Butchery")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class ButcheryLavishWorkspaceTalentGroup : TalentGroup
    {
        public ButcheryLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(ButcheryLavishResourcesTalent),
                typeof(ButcheryLavishReqTalent),
            };
            this.OwningSkill = typeof(ButcherySkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class ButcheryLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(ButcheryLavishWorkspaceTalentGroup); } }
        public ButcheryLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class ButcheryLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(ButcheryLavishWorkspaceTalentGroup); } }
        public ButcheryLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: AdvancedMasonry")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class AdvancedMasonryLavishWorkspaceTalentGroup : TalentGroup
    {
        public AdvancedMasonryLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(AdvancedMasonryLavishResourcesTalent),
                typeof(AdvancedMasonryLavishReqTalent),
            };
            this.OwningSkill = typeof(AdvancedMasonrySkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class AdvancedMasonryLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(AdvancedMasonryLavishWorkspaceTalentGroup); } }
        public AdvancedMasonryLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class AdvancedMasonryLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(AdvancedMasonryLavishWorkspaceTalentGroup); } }
        public AdvancedMasonryLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: Cooking")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class CookingLavishWorkspaceTalentGroup : TalentGroup
    {
        public CookingLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(CookingLavishResourcesTalent),
                typeof(CookingLavishReqTalent),
            };
            this.OwningSkill = typeof(CookingSkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class CookingLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(CookingLavishWorkspaceTalentGroup); } }
        public CookingLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class CookingLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(CookingLavishWorkspaceTalentGroup); } }
        public CookingLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: CuttingEdgeCooking")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class CuttingEdgeCookingLavishWorkspaceTalentGroup : TalentGroup
    {
        public CuttingEdgeCookingLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(CuttingEdgeCookingLavishResourcesTalent),
                typeof(CuttingEdgeCookingLavishReqTalent),
            };
            this.OwningSkill = typeof(CuttingEdgeCookingSkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class CuttingEdgeCookingLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(CuttingEdgeCookingLavishWorkspaceTalentGroup); } }
        public CuttingEdgeCookingLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class CuttingEdgeCookingLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(CuttingEdgeCookingLavishWorkspaceTalentGroup); } }
        public CuttingEdgeCookingLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: Electronics")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class ElectronicsLavishWorkspaceTalentGroup : TalentGroup
    {
        public ElectronicsLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(ElectronicsLavishResourcesTalent),
                typeof(ElectronicsLavishReqTalent),
            };
            this.OwningSkill = typeof(ElectronicsSkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class ElectronicsLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(ElectronicsLavishWorkspaceTalentGroup); } }
        public ElectronicsLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class ElectronicsLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(ElectronicsLavishWorkspaceTalentGroup); } }
        public ElectronicsLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: Fertilizers")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class FertilizersLavishWorkspaceTalentGroup : TalentGroup
    {
        public FertilizersLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(FertilizersLavishResourcesTalent),
                typeof(FertilizersLavishReqTalent),
            };
            this.OwningSkill = typeof(FertilizersSkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class FertilizersLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(FertilizersLavishWorkspaceTalentGroup); } }
        public FertilizersLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class FertilizersLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(FertilizersLavishWorkspaceTalentGroup); } }
        public FertilizersLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: Glassworking")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class GlassworkingLavishWorkspaceTalentGroup : TalentGroup
    {
        public GlassworkingLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(GlassworkingLavishResourcesTalent),
                typeof(GlassworkingLavishReqTalent),
            };
            this.OwningSkill = typeof(GlassworkingSkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class GlassworkingLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(GlassworkingLavishWorkspaceTalentGroup); } }
        public GlassworkingLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class GlassworkingLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(GlassworkingLavishWorkspaceTalentGroup); } }
        public GlassworkingLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: Industry")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class IndustryLavishWorkspaceTalentGroup : TalentGroup
    {
        public IndustryLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(IndustryLavishResourcesTalent),
                typeof(IndustryLavishReqTalent),
            };
            this.OwningSkill = typeof(IndustrySkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class IndustryLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(IndustryLavishWorkspaceTalentGroup); } }
        public IndustryLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class IndustryLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(IndustryLavishWorkspaceTalentGroup); } }
        public IndustryLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: Mechanics")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class MechanicsLavishWorkspaceTalentGroup : TalentGroup
    {
        public MechanicsLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(MechanicsLavishResourcesTalent),
                typeof(MechanicsLavishReqTalent),
            };
            this.OwningSkill = typeof(MechanicsSkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class MechanicsLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(MechanicsLavishWorkspaceTalentGroup); } }
        public MechanicsLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class MechanicsLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(MechanicsLavishWorkspaceTalentGroup); } }
        public MechanicsLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: Milling")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class MillingLavishWorkspaceTalentGroup : TalentGroup
    {
        public MillingLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(MillingLavishResourcesTalent),
                typeof(MillingLavishReqTalent),
            };
            this.OwningSkill = typeof(MillingSkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class MillingLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(MillingLavishWorkspaceTalentGroup); } }
        public MillingLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class MillingLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(MillingLavishWorkspaceTalentGroup); } }
        public MillingLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: Masonry")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class MasonryLavishWorkspaceTalentGroup : TalentGroup
    {
        public MasonryLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(MasonryLavishResourcesTalent),
                typeof(MasonryLavishReqTalent),
            };
            this.OwningSkill = typeof(MasonrySkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class MasonryLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(MasonryLavishWorkspaceTalentGroup); } }
        public MasonryLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class MasonryLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(MasonryLavishWorkspaceTalentGroup); } }
        public MasonryLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: OilDrilling")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class OilDrillingLavishWorkspaceTalentGroup : TalentGroup
    {
        public OilDrillingLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(OilDrillingLavishResourcesTalent),
                typeof(OilDrillingLavishReqTalent),
            };
            this.OwningSkill = typeof(OilDrillingSkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class OilDrillingLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(OilDrillingLavishWorkspaceTalentGroup); } }
        public OilDrillingLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class OilDrillingLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(OilDrillingLavishWorkspaceTalentGroup); } }
        public OilDrillingLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: PaperMilling")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class PaperMillingLavishWorkspaceTalentGroup : TalentGroup
    {
        public PaperMillingLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(PaperMillingLavishResourcesTalent),
                typeof(PaperMillingLavishReqTalent),
            };
            this.OwningSkill = typeof(PaperMillingSkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class PaperMillingLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(PaperMillingLavishWorkspaceTalentGroup); } }
        public PaperMillingLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class PaperMillingLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(PaperMillingLavishWorkspaceTalentGroup); } }
        public PaperMillingLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: Smelting")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class SmeltingLavishWorkspaceTalentGroup : TalentGroup
    {
        public SmeltingLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(SmeltingLavishResourcesTalent),
                typeof(SmeltingLavishReqTalent),
            };
            this.OwningSkill = typeof(SmeltingSkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class SmeltingLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(SmeltingLavishWorkspaceTalentGroup); } }
        public SmeltingLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class SmeltingLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(SmeltingLavishWorkspaceTalentGroup); } }
        public SmeltingLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: Tailoring")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class TailoringLavishWorkspaceTalentGroup : TalentGroup
    {
        public TailoringLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(TailoringLavishResourcesTalent),
                typeof(TailoringLavishReqTalent),
            };
            this.OwningSkill = typeof(TailoringSkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class TailoringLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(TailoringLavishWorkspaceTalentGroup); } }
        public TailoringLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class TailoringLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(TailoringLavishWorkspaceTalentGroup); } }
        public TailoringLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: Farming")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class FarmingLavishWorkspaceTalentGroup : TalentGroup
    {
        public FarmingLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(FarmingLavishResourcesTalent),
                typeof(FarmingLavishReqTalent),
            };
            this.OwningSkill = typeof(FarmingSkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class FarmingLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(FarmingLavishWorkspaceTalentGroup); } }
        public FarmingLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class FarmingLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(FarmingLavishWorkspaceTalentGroup); } }
        public FarmingLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: Carpentry")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class CarpentryLavishWorkspaceTalentGroup : TalentGroup
    {
        public CarpentryLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(CarpentryLavishResourcesTalent),
                typeof(CarpentryLavishReqTalent),
            };
            this.OwningSkill = typeof(CarpentrySkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class CarpentryLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(CarpentryLavishWorkspaceTalentGroup); } }
        public CarpentryLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class CarpentryLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(CarpentryLavishWorkspaceTalentGroup); } }
        public CarpentryLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: Shipwright")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class ShipwrightLavishWorkspaceTalentGroup : TalentGroup
    {
        public ShipwrightLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(ShipwrightLavishResourcesTalent),
                typeof(ShipwrightLavishReqTalent),
            };
            this.OwningSkill = typeof(ShipwrightSkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class ShipwrightLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(ShipwrightLavishWorkspaceTalentGroup); } }
        public ShipwrightLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class ShipwrightLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(ShipwrightLavishWorkspaceTalentGroup); } }
        public ShipwrightLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: Blacksmith")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class BlacksmithLavishWorkspaceTalentGroup : TalentGroup
    {
        public BlacksmithLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(BlacksmithLavishResourcesTalent),
                typeof(BlacksmithLavishReqTalent),
            };
            this.OwningSkill = typeof(BlacksmithSkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class BlacksmithLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(BlacksmithLavishWorkspaceTalentGroup); } }
        public BlacksmithLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class BlacksmithLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(BlacksmithLavishWorkspaceTalentGroup); } }
        public BlacksmithLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }

    /// <summary>
    /// <para>Server side talent group definition for "LavishWorkspace".</para>
    /// <para>More information about TalentGroup objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Skills.TalentGroup.html</para>
    /// </summary>
    [Serialized]
    [LocDisplayName("Lavish Workspace: Painting")]
    [LocDescription("Increases the tier requirement of tables by 0.2, but reduces the resources needed by 5 percent.(Only applies to claimed workstations)")]
    public partial class PaintingLavishWorkspaceTalentGroup : TalentGroup
    {
        public PaintingLavishWorkspaceTalentGroup()
        {
            Talents = new Type[]
            {
                typeof(PaintingLavishResourcesTalent),
                typeof(PaintingLavishReqTalent),
            };
            this.OwningSkill = typeof(PaintingSkill);
            this.Level = 6;
        }
    }

    [Serialized]
    public partial class PaintingLavishResourcesTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(PaintingLavishWorkspaceTalentGroup); } }
        public PaintingLavishResourcesTalent()
        {
            this.Value = 0.95f;
        }
    }
    [Serialized]
    public partial class PaintingLavishReqTalent : LavishWorkspaceTalent
    {
        public override bool Base { get { return false; } }
        public override Type TalentGroupType { get { return typeof(PaintingLavishWorkspaceTalentGroup); } }
        public PaintingLavishReqTalent()
        {
            this.Value = 0.2f;
        }
    }
}
