﻿// Copyright (c) Strange Loop Games. All rights reserved.
// See LICENSE file in the project root for full license information.
// <auto-generated from BlockTemplate.tt/>

namespace Eco.Mods.TechTree
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using Eco.Gameplay.Blocks;
    using Eco.Gameplay.Components;
    using Eco.Gameplay.DynamicValues;
    using Eco.Gameplay.Items;
    using Eco.Gameplay.Objects;
    using Eco.Gameplay.Players;
    using Eco.Gameplay.Skills;
    using Eco.Gameplay.Systems;
    using Eco.Gameplay.Systems.TextLinks;
    using Eco.Core.Items;
    using Eco.Shared.Localization;
    using Eco.Shared.Serialization;
    using Eco.Shared.Utils;
    using Eco.Shared.SharedTypes;
    using Eco.World;
    using Eco.World.Blocks;
    using Eco.World.Water;
    using Eco.Gameplay.Pipes;
    using Eco.Core.Controller;
    using Eco.Gameplay.Items.Recipes;
    using Eco.Shared.Graphics;
    using Eco.World.Color;

    /// <summary>Auto-generated class. Don't modify it! All your changes will be wiped with next update! Use Mods* partial methods instead for customization.</summary>

    /// <summary>
    /// <para>Server side recipe definition for "HewnLog".</para>
    /// <para>More information about RecipeFamily objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Items.RecipeFamily.html</para>
    /// </summary>
    /// <remarks>
    /// This is an auto-generated class. Don't modify it! All your changes will be wiped with next update! Use Mods* partial methods instead for customization. 
    /// If you wish to modify this class, please create a new partial class or follow the instructions in the "UserCode" folder to override the entire file.
    /// </remarks>
    [RequiresSkill(typeof(LoggingSkill), 1)]
    [Ecopedia("Blocks", "Building Materials", subPageName: "Hewn Log Item")]
    public partial class HewnLogRecipe : RecipeFamily
    {
        public HewnLogRecipe()
        {
            var recipe = new Recipe();
            recipe.Init(
                name: "HewnLog",  //noloc
                displayName: Localizer.DoStr("Hewn Log"),

                // Defines the ingredients needed to craft this recipe. An ingredient items takes the following inputs
                // type of the item, the amount of the item, the skill required, and the talent used.
                ingredients: new List<IngredientElement>
                {
                    new IngredientElement(typeof(DowelItem), 2,typeof(LoggingSkill)),
                    new IngredientElement("Wood", 2,typeof(LoggingSkill)), //noloc
                },

                // Define our recipe output items.
                // For every output item there needs to be one CraftingElement entry with the type of the final item and the amount
                // to create.
                items: new List<CraftingElement>
                {
                    new CraftingElement<HewnLogItem>()
                });
            this.Recipes = new List<Recipe> { recipe };
            this.ExperienceOnCraft = 0.5f; // Defines how much experience is gained when crafted.
            
            // Defines the amount of labor required and the required skill to add labor
            this.LaborInCalories = CreateLaborInCaloriesValue(20,typeof(LoggingSkill));

            // Defines our crafting time for the recipe
            this.CraftMinutes = CreateCraftTimeValue(beneficiary: typeof(HewnLogRecipe), start: 0.16f, skillType: typeof(LoggingSkill));

            // Perform pre/post initialization for user mods and initialize our recipe instance with the display name "Hewn Log"
            this.ModsPreInitialize();
            this.Initialize(displayText: Localizer.DoStr("Hewn Log"), recipeType: typeof(HewnLogRecipe));
            this.ModsPostInitialize();

            // Register our RecipeFamily instance with the crafting system so it can be crafted.
            CraftingComponent.AddRecipe(tableType: typeof(CarpentryTableObject), recipeFamily: this);
        }

        /// <summary>Hook for mods to customize RecipeFamily before initialization. You can change recipes, xp, labor, time here.</summary>
        partial void ModsPreInitialize();

        /// <summary>Hook for mods to customize RecipeFamily after initialization, but before registration. You can change skill requirements here.</summary>
        partial void ModsPostInitialize();
    }

    [Serialized]
    [Solid, Wall, Constructed,BuildRoomMaterialOption]
    [BlockTier(2)]
    [RequiresSkill(typeof(LoggingSkill), 1)]
        public partial class HewnLogBlock :
        Block
        , IRepresentsItem
    {
        public virtual Type RepresentedItemType { get { return typeof(HewnLogItem); } }
    }

    [Serialized]
    [LocDisplayName("Hewn Log")]
    [LocDescription("A log hewn and shaped to be a building material. Hewing logs at a workbench will grant no experience.")]
    [MaxStackSize(15)]
    [Weight(10000)]
    [Fuel(4000)][Tag("Fuel")]
    [ResourcePile]
    [Ecopedia("Blocks", "Building Materials", createAsSubPage: true)]
    [Tag("HewnLog")]
    [Tag("Burnable Fuel")]
    [Tag("Constructable")]
    [Tier(2)]
    public partial class HewnLogItem :
 
    BlockItem<HewnLogBlock>
    {

        public override bool CanStickToWalls { get { return false; } }

        private static Type[] blockTypes = new Type[] {
            typeof(HewnLogStacked1Block),
            typeof(HewnLogStacked2Block),
            typeof(HewnLogStacked3Block)
        };
        
        public override Type[] BlockTypes { get { return blockTypes; } }
    }

    [Tag("HewnLog")]
    [Tag("Burnable Fuel")]
    [Tag("Constructable")]
    [Tag(BlockTags.PartialStack)]
    [Serialized, Solid] public class HewnLogStacked1Block : PickupableBlock, IWaterLoggedBlock { }
    [Tag("HewnLog")]
    [Tag("Burnable Fuel")]
    [Tag("Constructable")]
    [Tag(BlockTags.PartialStack)]
    [Serialized, Solid] public class HewnLogStacked2Block : PickupableBlock, IWaterLoggedBlock { }
    [Tag("HewnLog")]
    [Tag("Burnable Fuel")]
    [Tag("Constructable")]
    [Tag(BlockTags.FullStack)]
    [Serialized, Solid,Wall] public class HewnLogStacked3Block : PickupableBlock, IWaterLoggedBlock { } //Only a wall if it's all 4 HewnLog
}
