﻿// Copyright (c) Strange Loop Games. All rights reserved.
// See LICENSE file in the project root for full license information.
// <auto-generated from BlockTemplate.tt/>

namespace Eco.Mods.TechTree
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using Eco.Gameplay.Blocks;
    using Eco.Gameplay.Components;
    using Eco.Gameplay.DynamicValues;
    using Eco.Gameplay.Items;
    using Eco.Gameplay.Objects;
    using Eco.Gameplay.Players;
    using Eco.Gameplay.Skills;
    using Eco.Gameplay.Systems;
    using Eco.Gameplay.Systems.TextLinks;
    using Eco.Core.Items;
    using Eco.Shared.Localization;
    using Eco.Shared.Serialization;
    using Eco.Shared.Utils;
    using Eco.Shared.SharedTypes;
    using Eco.World;
    using Eco.World.Blocks;
    using Eco.World.Water;
    using Eco.Gameplay.Pipes;
    using Eco.Core.Controller;
    using Eco.Gameplay.Items.Recipes;
    using Eco.Shared.Graphics;
    using Eco.World.Color;

    /// <summary>Auto-generated class. Don't modify it! All your changes will be wiped with next update! Use Mods* partial methods instead for customization.</summary>

    [Serialized]
    [Solid, Wall, Constructed,BuildRoomMaterialOption]
    [RequiresSkill(typeof(TailoringSkill), 3)]
        public partial class NylonCurtainsBlock :
        Block
        , IRepresentsItem
    {
        public virtual Type RepresentedItemType { get { return typeof(NylonCurtainsItem); } }
    }

    [Serialized]
    [LocDisplayName("Nylon Curtains")]
    [LocDescription("Curtains made out of plastic? \n\n (Only cosmetic does not impact room value.)")]
    [MaxStackSize(20)]
    [Weight(5000)]
    [Ecopedia("Blocks", "Building Materials", createAsSubPage: true)]
    [Tag("Constructable")]
    public partial class NylonCurtainsItem :
 
    BlockItem<NylonCurtainsBlock>
    {
        public override LocString DisplayNamePlural { get { return Localizer.DoStr("Nylon Curtains"); } }

        public override bool IgnoreRooms     { get { return true;  } }

        private static Type[] blockTypes = new Type[] {
            typeof(NylonCurtainsStacked1Block),
            typeof(NylonCurtainsStacked2Block),
            typeof(NylonCurtainsStacked3Block),
            typeof(NylonCurtainsStacked4Block)
        };
        
        public override Type[] BlockTypes { get { return blockTypes; } }
    }

    [Tag("Constructable")]
    [Tag(BlockTags.PartialStack)]
    [Serialized, Solid] public class NylonCurtainsStacked1Block : PickupableBlock, IWaterLoggedBlock { }
    [Tag("Constructable")]
    [Tag(BlockTags.PartialStack)]
    [Serialized, Solid] public class NylonCurtainsStacked2Block : PickupableBlock, IWaterLoggedBlock { }
    [Tag("Constructable")]
    [Tag(BlockTags.PartialStack)]
    [Serialized, Solid] public class NylonCurtainsStacked3Block : PickupableBlock, IWaterLoggedBlock { }
    [Tag("Constructable")]
    [Tag(BlockTags.FullStack)]
    [Serialized, Solid,Wall] public class NylonCurtainsStacked4Block : PickupableBlock, IWaterLoggedBlock { } //Only a wall if it's all 4 NylonCurtains
}
