﻿// Copyright (c) Strange Loop Games. All rights reserved.
// See LICENSE file in the project root for full license information.
// <auto-generated from BlockTemplate.tt/>

namespace Eco.Mods.TechTree
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using Eco.Gameplay.Blocks;
    using Eco.Gameplay.Components;
    using Eco.Gameplay.DynamicValues;
    using Eco.Gameplay.Items;
    using Eco.Gameplay.Objects;
    using Eco.Gameplay.Players;
    using Eco.Gameplay.Skills;
    using Eco.Gameplay.Systems;
    using Eco.Gameplay.Systems.TextLinks;
    using Eco.Core.Items;
    using Eco.Shared.Localization;
    using Eco.Shared.Serialization;
    using Eco.Shared.Utils;
    using Eco.Shared.SharedTypes;
    using Eco.World;
    using Eco.World.Blocks;
    using Eco.World.Water;
    using Eco.Gameplay.Pipes;
    using Eco.Gameplay.Pipes.LiquidComponents;
    using Eco.Core.Controller;
    using Eco.Gameplay.Items.Recipes;
    using Eco.Shared.Graphics;
    using Eco.World.Color;

    /// <summary>Auto-generated class. Don't modify it! All your changes will be wiped with next update! Use Mods* partial methods instead for customization.</summary>

    /// <summary>
    /// <para>Server side recipe definition for "Petroleum".</para>
    /// <para>More information about RecipeFamily objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Items.RecipeFamily.html</para>
    /// </summary>
    /// <remarks>
    /// This is an auto-generated class. Don't modify it! All your changes will be wiped with next update! Use Mods* partial methods instead for customization. 
    /// If you wish to modify this class, please create a new partial class or follow the instructions in the "UserCode" folder to override the entire file.
    /// </remarks>
    [RequiresSkill(typeof(OilDrillingSkill), 1)]
    [Ecopedia("Blocks", "Liquids", subPageName: "Petroleum Item")]
    public partial class PetroleumRecipe : RecipeFamily
    {
        public PetroleumRecipe()
        {
            var recipe = new Recipe();
            recipe.Init(
                name: "Petroleum",  //noloc
                displayName: Localizer.DoStr("Petroleum"),

                // Defines the ingredients needed to craft this recipe. An ingredient items takes the following inputs
                // type of the item, the amount of the item, the skill required, and the talent used.
                ingredients: new List<IngredientElement>
                {
                    new IngredientElement(typeof(BarrelItem), 1, true),
                },

                // Define our recipe output items.
                // For every output item there needs to be one CraftingElement entry with the type of the final item and the amount
                // to create.
                items: new List<CraftingElement>
                {
                    new CraftingElement<PetroleumItem>()
                });
            this.Recipes = new List<Recipe> { recipe };
            this.ExperienceOnCraft = 0.5f; // Defines how much experience is gained when crafted.
            
            // Defines the amount of labor required and the required skill to add labor
            this.LaborInCalories = CreateLaborInCaloriesValue(60, typeof(OilDrillingSkill));

            // Defines our crafting time for the recipe
            this.CraftMinutes = new MultiDynamicValue(MultiDynamicOps.Multiply,
                CreateCraftTimeValue(beneficiary: typeof(PetroleumRecipe), start: 30, skillType: typeof(OilDrillingSkill), typeof(OilDrillingFocusedSpeedTalent), typeof(OilDrillingParallelSpeedTalent)),
                new LayerModifiedValue(Eco.Simulation.WorldLayers.LayerNames.Oilfield,3)
            );

            // Perform pre/post initialization for user mods and initialize our recipe instance with the display name "Petroleum"
            this.ModsPreInitialize();
            this.Initialize(displayText: Localizer.DoStr("Petroleum"), recipeType: typeof(PetroleumRecipe));
            this.ModsPostInitialize();

            // Register our RecipeFamily instance with the crafting system so it can be crafted.
            CraftingComponent.AddRecipe(tableType: typeof(PumpJackObject), recipeFamily: this);
        }

        /// <summary>Hook for mods to customize RecipeFamily before initialization. You can change recipes, xp, labor, time here.</summary>
        partial void ModsPreInitialize();

        /// <summary>Hook for mods to customize RecipeFamily after initialization, but before registration. You can change skill requirements here.</summary>
        partial void ModsPostInitialize();
    }

    [Serialized]
    [Solid]
    [RequiresSkill(typeof(OilDrillingSkill), 1)]
        public partial class PetroleumBlock :
        PickupableBlock
        , IRepresentsItem
    {
        public virtual Type RepresentedItemType { get { return typeof(PetroleumItem); } }
    }

    [Serialized]
    [LocDisplayName("Petroleum")]
    [LocDescription("A fossil fuel essential for manufacturing gasoline, plastics, and asphalt. Its extraction, transport, and burning all have environmental impacts.")]
    [MaxStackSize(10)]
    [Weight(10000)]
    [Ecopedia("Blocks", "Liquids", createAsSubPage: true)]
    public partial class PetroleumItem :
 
    BlockItem<PetroleumBlock>
    {
        public override LocString DisplayNamePlural { get { return Localizer.DoStr("Petroleum"); } }

        public override bool CanStickToWalls { get { return false; } }
    }

}
