﻿// Copyright (c) Strange Loop Games. All rights reserved.
// See LICENSE file in the project root for full license information.
// <auto-generated from BlockTemplate.tt/>

namespace Eco.Mods.TechTree
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using Eco.Gameplay.Blocks;
    using Eco.Gameplay.Components;
    using Eco.Gameplay.DynamicValues;
    using Eco.Gameplay.Items;
    using Eco.Gameplay.Objects;
    using Eco.Gameplay.Players;
    using Eco.Gameplay.Skills;
    using Eco.Gameplay.Systems;
    using Eco.Gameplay.Systems.TextLinks;
    using Eco.Core.Items;
    using Eco.Shared.Localization;
    using Eco.Shared.Serialization;
    using Eco.Shared.Utils;
    using Eco.Shared.SharedTypes;
    using Eco.World;
    using Eco.World.Blocks;
    using Eco.World.Water;
    using Eco.Gameplay.Pipes;
    using Eco.Core.Controller;
    using Eco.Gameplay.Items.Recipes;
    using Eco.Shared.Graphics;
    using Eco.World.Color;

    /// <summary>Auto-generated class. Don't modify it! All your changes will be wiped with next update! Use Mods* partial methods instead for customization.</summary>

    [Serialized]
    [Solid, Wall, Constructed, Minable(4)]
        public partial class SlagBlock :
        Block
        , IRepresentsItem
    {
        public virtual Type RepresentedItemType { get { return typeof(SlagItem); } }
    }

    [Serialized]
    [LocDisplayName("Slag")]
    [LocDescription("A glass-like byproduct that is created when smelting ore. Crushed Slag is often used in the production of Concrete.")]
    [MaxStackSize(20)]
    [Weight(6000)]
    [ResourcePile]
    [Ecopedia("Blocks", "Byproducts", createAsSubPage: true)]
    [Tag("Excavatable")]
    [Tag("Waste Product")]
    public partial class SlagItem :
 
    BlockItem<SlagBlock>
    {
        public override LocString DisplayNamePlural { get { return Localizer.DoStr("Slag"); } }

        public override bool CanStickToWalls { get { return false; } }

        private static Type[] blockTypes = new Type[] {
            typeof(SlagStacked1Block),
            typeof(SlagStacked2Block),
            typeof(SlagStacked3Block),
            typeof(SlagStacked4Block)
        };
        
        public override Type[] BlockTypes { get { return blockTypes; } }
    }

    [Tag("Excavatable")]
    [Tag("Waste Product")]
    [Tag(BlockTags.PartialStack)]
    [Serialized, Solid] public class SlagStacked1Block : PickupableBlock, IWaterLoggedBlock { }
    [Tag("Excavatable")]
    [Tag("Waste Product")]
    [Tag(BlockTags.PartialStack)]
    [Serialized, Solid] public class SlagStacked2Block : PickupableBlock, IWaterLoggedBlock { }
    [Tag("Excavatable")]
    [Tag("Waste Product")]
    [Tag(BlockTags.PartialStack)]
    [Serialized, Solid] public class SlagStacked3Block : PickupableBlock, IWaterLoggedBlock { }
    [Tag("Excavatable")]
    [Tag("Waste Product")]
    [Tag(BlockTags.FullStack)]
    [Serialized, Solid,Wall] public class SlagStacked4Block : PickupableBlock, IWaterLoggedBlock { } //Only a wall if it's all 4 Slag
}
