﻿// Copyright (c) Strange Loop Games. All rights reserved.
// See LICENSE file in the project root for full license information.
// <auto-generated from BlockTemplate.tt/>

namespace Eco.Mods.TechTree
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using Eco.Gameplay.Blocks;
    using Eco.Gameplay.Components;
    using Eco.Gameplay.DynamicValues;
    using Eco.Gameplay.Items;
    using Eco.Gameplay.Objects;
    using Eco.Gameplay.Players;
    using Eco.Gameplay.Skills;
    using Eco.Gameplay.Systems;
    using Eco.Gameplay.Systems.TextLinks;
    using Eco.Core.Items;
    using Eco.Shared.Localization;
    using Eco.Shared.Serialization;
    using Eco.Shared.Utils;
    using Eco.Shared.SharedTypes;
    using Eco.World;
    using Eco.World.Blocks;
    using Eco.World.Water;
    using Eco.Gameplay.Pipes;
    using Eco.Core.Controller;
    using Eco.Gameplay.Items.Recipes;
    using Eco.Shared.Graphics;
    using Eco.World.Color;

    /// <summary>Auto-generated class. Don't modify it! All your changes will be wiped with next update! Use Mods* partial methods instead for customization.</summary>

    [Serialized]
    [Solid, Wall, Minable(1)]
        public partial class StoneBlock :
        Block
        , IRepresentsItem
    {
        public virtual Type RepresentedItemType { get { return typeof(StoneItem); } }
    }

    [Serialized]
    [LocDisplayName("Stone")]
    [LocDescription("A pile of stones.")]
    [MaxStackSize(20)]
    [Weight(7000)]
    [Category("Hidden")]
    [ResourcePile]
    [Tag("Rock")]
    public partial class StoneItem :
 
    BlockItem<StoneBlock>
    {
        public override LocString DisplayNamePlural { get { return Localizer.DoStr("Stone"); } }


        private static Type[] blockTypes = new Type[] {
            typeof(StoneStacked1Block),
            typeof(StoneStacked2Block),
            typeof(StoneStacked3Block),
            typeof(StoneStacked4Block)
        };
        
        public override Type[] BlockTypes { get { return blockTypes; } }
    }

    [Tag("Rock")]
    [Tag(BlockTags.PartialStack)]
    [Serialized, Solid] public class StoneStacked1Block : PickupableBlock, IWaterLoggedBlock { }
    [Tag("Rock")]
    [Tag(BlockTags.PartialStack)]
    [Serialized, Solid] public class StoneStacked2Block : PickupableBlock, IWaterLoggedBlock { }
    [Tag("Rock")]
    [Tag(BlockTags.PartialStack)]
    [Serialized, Solid] public class StoneStacked3Block : PickupableBlock, IWaterLoggedBlock { }
    [Tag("Rock")]
    [Tag(BlockTags.FullStack)]
    [Serialized, Solid,Wall] public class StoneStacked4Block : PickupableBlock, IWaterLoggedBlock { } //Only a wall if it's all 4 Stone
}
