﻿// Copyright (c) Strange Loop Games. All rights reserved.
// See LICENSE file in the project root for full license information.
// <auto-generated from FertilizerTemplate.tt/>

namespace Eco.Mods.TechTree
{
    using System;
    using System.Collections.Generic;
    using Eco.Core.Items;
    using Eco.Gameplay.Blocks;
    using Eco.Gameplay.Components;
    using Eco.Gameplay.DynamicValues;
    using Eco.Gameplay.Items;
    using Eco.Gameplay.Players;
    using Eco.Gameplay.Skills;
    using Eco.Gameplay.Systems.TextLinks;
    using Eco.Shared.Localization;
    using Eco.Shared.Serialization;
    using Eco.Shared.Utils;
    using Eco.World;
    using Eco.World.Blocks;
    using System.ComponentModel;
    using Eco.Core.Controller;
    using Eco.Gameplay.Items.Recipes;


    /// <summary>
    /// <para>Server side recipe definition for "CompostFertilizer".</para>
    /// <para>More information about RecipeFamily objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Items.RecipeFamily.html</para>
    /// </summary>
    /// <remarks>
    /// This is an auto-generated class. Don't modify it! All your changes will be wiped with next update! Use Mods* partial methods instead for customization. 
    /// If you wish to modify this class, please create a new partial class or follow the instructions in the "UserCode" folder to override the entire file.
    /// </remarks>
    [RequiresSkill(typeof(FertilizersSkill), 5)]
    [Ecopedia("Items", "Fertilizers", subPageName: "Compost Fertilizer Item")]
    public partial class CompostFertilizerRecipe : RecipeFamily
    {
        public CompostFertilizerRecipe()
        {
            var recipe = new Recipe();
            recipe.Init(
                name: "CompostFertilizer",  //noloc
                displayName: Localizer.DoStr("Compost Fertilizer"),

                // Defines the ingredients needed to craft this recipe. An ingredient items takes the following inputs
                // type of the item, the amount of the item, the skill required, and the talent used.
                ingredients: new List<IngredientElement>
                {
                    new IngredientElement(typeof(CompostItem), 1, typeof(FertilizersSkill), typeof(FertilizersLavishResourcesTalent)),
                    new IngredientElement("FertilizerFiller", 1, typeof(FertilizersSkill), typeof(FertilizersLavishResourcesTalent)), //noloc
                },

                // Define our recipe output items.
                // For every output item there needs to be one CraftingElement entry with the type of the final item and the amount
                // to create.
                items: new List<CraftingElement>
                {
                    new CraftingElement<CompostFertilizerItem>()
                });
            this.Recipes = new List<Recipe> { recipe };
            
            // Defines the amount of labor required and the required skill to add labor
            this.LaborInCalories = CreateLaborInCaloriesValue(15, typeof(FertilizersSkill));

            // Defines our crafting time for the recipe
            this.CraftMinutes = CreateCraftTimeValue(beneficiary: typeof(CompostFertilizerRecipe), start: 0.3f, skillType: typeof(FertilizersSkill), typeof(FertilizersFocusedSpeedTalent), typeof(FertilizersParallelSpeedTalent));

            // Perform pre/post initialization for user mods and initialize our recipe instance with the display name "Compost Fertilizer"
            this.ModsPreInitialize();
            this.Initialize(displayText: Localizer.DoStr("Compost Fertilizer"), recipeType: typeof(CompostFertilizerRecipe));
            this.ModsPostInitialize();

            // Register our RecipeFamily instance with the crafting system so it can be crafted.
            CraftingComponent.AddRecipe(tableType: typeof(FarmersTableObject), recipeFamily: this);
        }

        /// <summary>Hook for mods to customize RecipeFamily before initialization. You can change recipes, xp, labor, time here.</summary>
        partial void ModsPreInitialize();

        /// <summary>Hook for mods to customize RecipeFamily after initialization, but before registration. You can change skill requirements here.</summary>
        partial void ModsPostInitialize();
    }
    
    /// <summary>
    /// <para>Server side fertilizer item definition for the "CompostFertilizer" item.</para>
    /// <para>More information about Item objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Items.FertilizerItem-1.html.</para>
    /// <remarks>
    /// This is an auto-generated class. Don't modify it! All your changes will be wiped with next update! Use Mods* partial methods instead for customization. 
    /// If you wish to modify this class, please create a new partial class or follow the instructions in the "UserCode" folder to override the entire file.
    /// </remarks>
    /// </summary>
    [Serialized] // Tells the save/load system this object needs to be serialized. 
    [LocDisplayName("Compost Fertilizer")] // Defines the localized name of the item.
    [LocDescription("Compost fertilizer is a classic, low effort fertilizer.")] //The tooltip description for the item.
    [Weight(500)] // Defines how heavy CompostFertilizer is.
    [Category("Tool")] // Gives this item the category of "Tool" for organization
    [Tag("Fertilizer")] // Gives this item the Fertilizer tag for use in recipes
    [Ecopedia("Items", "Fertilizers", createAsSubPage: true)]
        public partial class CompostFertilizerItem : FertilizerItem
    {

        /// <summary>Defines the amount of nutrients in this fertilizer item.</summary>
        public override FertilizerNutrients Nutrients => new FertilizerNutrients(2, 1, 3.7f);
    }
}
