﻿// Copyright (c) Strange Loop Games. All rights reserved.
// See LICENSE file in the project root for full license information.
// <auto-generated from FormsTemplate.tt/>

namespace Eco.Mods.TechTree
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using Eco.Gameplay.Blocks;
    using Eco.Gameplay.Components;
    using Eco.Gameplay.DynamicValues;
    using Eco.Gameplay.Items;
    using Eco.Gameplay.Objects;
    using Eco.Gameplay.Players;
    using Eco.Gameplay.Skills;
    using Eco.Gameplay.Systems.TextLinks;
    using Eco.Shared.Serialization;
    using Eco.Shared.Utils;
    using Eco.World;
    using Eco.World.Water;
    using Eco.World.Blocks;
    using Eco.Gameplay.Pipes;
    using Tag = Eco.Core.Items.TagAttribute;
    using Eco.World.Color;

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(FloorFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleFloorBlock :
        Block, IRepresentsItem, IColoredBlock
    {
        public Type RepresentedItemType { get { return typeof(AshlarShaleItem); } }
    }
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(FullWallFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleFullWallBlock :
        Block, IRepresentsItem, IColoredBlock
    {
        public Type RepresentedItemType { get { return typeof(AshlarShaleItem); } }
    }
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(FlatRoofFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleFlatRoofBlock :
        Block, IRepresentsItem, IColoredBlock
    {
        public Type RepresentedItemType { get { return typeof(AshlarShaleItem); } }
    }
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(CubeFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleCubeBlock :
        Block, IRepresentsItem, IColoredBlock
    {
        public Type RepresentedItemType { get { return typeof(AshlarShaleItem); } }
    }
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(RoofCubeFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleRoofCubeBlock :
        Block, IRepresentsItem, IColoredBlock
    {
        public Type RepresentedItemType { get { return typeof(AshlarShaleItem); } }
    }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(ChimneyFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleChimneyBlock :
        Block, IRepresentsItem, IWaterLoggedBlock, IColoredBlock
    {
        public Type RepresentedItemType { get { return typeof(AshlarShaleItem); } }
    }
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(WallFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleWallBlock :
        Block, IRepresentsItem, IWaterLoggedBlock, IColoredBlock
    {
        public Type RepresentedItemType { get { return typeof(AshlarShaleItem); } }
    }
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(ColumnFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleColumnBlock :
        Block, IRepresentsItem, IWaterLoggedBlock, IColoredBlock
    {
        public Type RepresentedItemType { get { return typeof(AshlarShaleItem); } }
    }
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(WindowFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleWindowBlock :
        Block, IRepresentsItem, IWaterLoggedBlock, IColoredBlock
    {
        public Type RepresentedItemType { get { return typeof(AshlarShaleItem); } }
    }
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(FenceFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleFenceBlock :
        Block, IRepresentsItem, IWaterLoggedBlock, IColoredBlock
    {
        public Type RepresentedItemType { get { return typeof(AshlarShaleItem); } }
    }
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(DoubleWindowFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleDoubleWindowBlock :
        Block, IRepresentsItem, IWaterLoggedBlock, IColoredBlock
    {
        public Type RepresentedItemType { get { return typeof(AshlarShaleItem); } }
    }
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(UnderPeakSetFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderPeakSetBlock :
        Block, IRepresentsItem, IWaterLoggedBlock, IColoredBlock
    {
        public Type RepresentedItemType { get { return typeof(AshlarShaleItem); } }
    }
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(PeakSetFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShalePeakSetBlock :
        Block, IRepresentsItem, IWaterLoggedBlock, IColoredBlock
    {
        public Type RepresentedItemType { get { return typeof(AshlarShaleItem); } }
    }
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(RoofPeakSetFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleRoofPeakSetBlock :
        Block, IRepresentsItem, IWaterLoggedBlock, IColoredBlock
    {
        public Type RepresentedItemType { get { return typeof(AshlarShaleItem); } }
    }





    [RotatedVariants(typeof(AshlarShaleRampABlock), typeof(AshlarShaleRampA90Block), typeof(AshlarShaleRampA180Block), typeof(AshlarShaleRampA270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(RampAFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleRampABlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleRampA90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleRampA180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleRampA270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleRampBBlock), typeof(AshlarShaleRampB90Block), typeof(AshlarShaleRampB180Block), typeof(AshlarShaleRampB270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(RampBFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleRampBBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleRampB90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleRampB180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleRampB270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleRampCBlock), typeof(AshlarShaleRampC90Block), typeof(AshlarShaleRampC180Block), typeof(AshlarShaleRampC270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(RampCFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleRampCBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleRampC90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleRampC180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleRampC270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleRampDBlock), typeof(AshlarShaleRampD90Block), typeof(AshlarShaleRampD180Block), typeof(AshlarShaleRampD270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(RampDFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleRampDBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleRampD90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleRampD180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleRampD270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleLadderBlock), typeof(AshlarShaleLadder90Block), typeof(AshlarShaleLadder180Block), typeof(AshlarShaleLadder270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(LadderFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleLadderBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleLadder90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleLadder180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleLadder270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleStairsBlock), typeof(AshlarShaleStairs90Block), typeof(AshlarShaleStairs180Block), typeof(AshlarShaleStairs270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(StairsFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleStairsBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleStairs90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleStairs180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleStairs270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleUnderStairsBlock), typeof(AshlarShaleUnderStairs90Block), typeof(AshlarShaleUnderStairs180Block), typeof(AshlarShaleUnderStairs270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(UnderStairsFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderStairsBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderStairs90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderStairs180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderStairs270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleFloatStairsBlock), typeof(AshlarShaleFloatStairs90Block), typeof(AshlarShaleFloatStairs180Block), typeof(AshlarShaleFloatStairs270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(FloatStairsFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleFloatStairsBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleFloatStairs90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleFloatStairs180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleFloatStairs270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleBraceBlock), typeof(AshlarShaleBrace90Block), typeof(AshlarShaleBrace180Block), typeof(AshlarShaleBrace270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(BraceFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleBraceBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleBrace90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleBrace180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleBrace270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleUnderBraceBlock), typeof(AshlarShaleUnderBrace90Block), typeof(AshlarShaleUnderBrace180Block), typeof(AshlarShaleUnderBrace270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(UnderBraceFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderBraceBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderBrace90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderBrace180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderBrace270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleSideBraceBlock), typeof(AshlarShaleSideBrace90Block), typeof(AshlarShaleSideBrace180Block), typeof(AshlarShaleSideBrace270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(SideBraceFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleSideBraceBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleSideBrace90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleSideBrace180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleSideBrace270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleBasicSlopeSideBlock), typeof(AshlarShaleBasicSlopeSide90Block), typeof(AshlarShaleBasicSlopeSide180Block), typeof(AshlarShaleBasicSlopeSide270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(BasicSlopeSideFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleBasicSlopeSideBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleBasicSlopeSide90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleBasicSlopeSide180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleBasicSlopeSide270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleBasicSlopeCornerBlock), typeof(AshlarShaleBasicSlopeCorner90Block), typeof(AshlarShaleBasicSlopeCorner180Block), typeof(AshlarShaleBasicSlopeCorner270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(BasicSlopeCornerFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleBasicSlopeCornerBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleBasicSlopeCorner90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleBasicSlopeCorner180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleBasicSlopeCorner270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleBasicSlopeTurnBlock), typeof(AshlarShaleBasicSlopeTurn90Block), typeof(AshlarShaleBasicSlopeTurn180Block), typeof(AshlarShaleBasicSlopeTurn270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(BasicSlopeTurnFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleBasicSlopeTurnBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleBasicSlopeTurn90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleBasicSlopeTurn180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleBasicSlopeTurn270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleBasicSlopePointBlock), typeof(AshlarShaleBasicSlopePoint90Block), typeof(AshlarShaleBasicSlopePoint180Block), typeof(AshlarShaleBasicSlopePoint270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(BasicSlopePointFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleBasicSlopePointBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleBasicSlopePoint90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleBasicSlopePoint180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleBasicSlopePoint270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleFloatStairsCornerBlock), typeof(AshlarShaleFloatStairsCorner90Block), typeof(AshlarShaleFloatStairsCorner180Block), typeof(AshlarShaleFloatStairsCorner270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(FloatStairsCornerFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleFloatStairsCornerBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleFloatStairsCorner90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleFloatStairsCorner180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleFloatStairsCorner270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleFloatStairsTurnBlock), typeof(AshlarShaleFloatStairsTurn90Block), typeof(AshlarShaleFloatStairsTurn180Block), typeof(AshlarShaleFloatStairsTurn270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(FloatStairsTurnFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleFloatStairsTurnBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleFloatStairsTurn90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleFloatStairsTurn180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleFloatStairsTurn270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleStairsCornerBlock), typeof(AshlarShaleStairsCorner90Block), typeof(AshlarShaleStairsCorner180Block), typeof(AshlarShaleStairsCorner270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(StairsCornerFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleStairsCornerBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleStairsCorner90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleStairsCorner180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleStairsCorner270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleStairsTurnBlock), typeof(AshlarShaleStairsTurn90Block), typeof(AshlarShaleStairsTurn180Block), typeof(AshlarShaleStairsTurn270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(StairsTurnFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleStairsTurnBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleStairsTurn90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleStairsTurn180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleStairsTurn270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleUnderBraceCornerBlock), typeof(AshlarShaleUnderBraceCorner90Block), typeof(AshlarShaleUnderBraceCorner180Block), typeof(AshlarShaleUnderBraceCorner270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(UnderBraceCornerFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderBraceCornerBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderBraceCorner90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderBraceCorner180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderBraceCorner270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleBraceCornerBlock), typeof(AshlarShaleBraceCorner90Block), typeof(AshlarShaleBraceCorner180Block), typeof(AshlarShaleBraceCorner270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(BraceCornerFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleBraceCornerBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleBraceCorner90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleBraceCorner180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleBraceCorner270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleUnderSlopeSideBlock), typeof(AshlarShaleUnderSlopeSide90Block), typeof(AshlarShaleUnderSlopeSide180Block), typeof(AshlarShaleUnderSlopeSide270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(UnderSlopeSideFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderSlopeSideBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderSlopeSide90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderSlopeSide180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderSlopeSide270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleUnderSlopeCornerBlock), typeof(AshlarShaleUnderSlopeCorner90Block), typeof(AshlarShaleUnderSlopeCorner180Block), typeof(AshlarShaleUnderSlopeCorner270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(UnderSlopeCornerFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderSlopeCornerBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderSlopeCorner90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderSlopeCorner180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderSlopeCorner270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleUnderSlopeTurnBlock), typeof(AshlarShaleUnderSlopeTurn90Block), typeof(AshlarShaleUnderSlopeTurn180Block), typeof(AshlarShaleUnderSlopeTurn270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(UnderSlopeTurnFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderSlopeTurnBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderSlopeTurn90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderSlopeTurn180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderSlopeTurn270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleUnderSlopePeakBlock), typeof(AshlarShaleUnderSlopePeak90Block), typeof(AshlarShaleUnderSlopePeak180Block), typeof(AshlarShaleUnderSlopePeak270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(UnderSlopePeakFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderSlopePeakBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderSlopePeak90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderSlopePeak180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderSlopePeak270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleRoofSideBlock), typeof(AshlarShaleRoofSide90Block), typeof(AshlarShaleRoofSide180Block), typeof(AshlarShaleRoofSide270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(RoofSideFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleRoofSideBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleRoofSide90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleRoofSide180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleRoofSide270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleRoofTurnBlock), typeof(AshlarShaleRoofTurn90Block), typeof(AshlarShaleRoofTurn180Block), typeof(AshlarShaleRoofTurn270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(RoofTurnFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleRoofTurnBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleRoofTurn90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleRoofTurn180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleRoofTurn270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleRoofCornerBlock), typeof(AshlarShaleRoofCorner90Block), typeof(AshlarShaleRoofCorner180Block), typeof(AshlarShaleRoofCorner270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(RoofCornerFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleRoofCornerBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleRoofCorner90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleRoofCorner180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleRoofCorner270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleRoofPeakBlock), typeof(AshlarShaleRoofPeak90Block), typeof(AshlarShaleRoofPeak180Block), typeof(AshlarShaleRoofPeak270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(RoofPeakFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleRoofPeakBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleRoofPeak90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleRoofPeak180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleRoofPeak270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleUnderInnerPeakBlock), typeof(AshlarShaleUnderInnerPeak90Block), typeof(AshlarShaleUnderInnerPeak180Block), typeof(AshlarShaleUnderInnerPeak270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(UnderInnerPeakFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderInnerPeakBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderInnerPeak90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderInnerPeak180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderInnerPeak270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleBraceTurnBlock), typeof(AshlarShaleBraceTurn90Block), typeof(AshlarShaleBraceTurn180Block), typeof(AshlarShaleBraceTurn270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(BraceTurnFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleBraceTurnBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleBraceTurn90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleBraceTurn180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleBraceTurn270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleUnderBraceTurnBlock), typeof(AshlarShaleUnderBraceTurn90Block), typeof(AshlarShaleUnderBraceTurn180Block), typeof(AshlarShaleUnderBraceTurn270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(UnderBraceTurnFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderBraceTurnBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderBraceTurn90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderBraceTurn180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleUnderBraceTurn270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleHalfSlopeABlock), typeof(AshlarShaleHalfSlopeA90Block), typeof(AshlarShaleHalfSlopeA180Block), typeof(AshlarShaleHalfSlopeA270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(HalfSlopeAFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleHalfSlopeABlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleHalfSlopeA90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleHalfSlopeA180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleHalfSlopeA270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(AshlarShaleHalfSlopeBBlock), typeof(AshlarShaleHalfSlopeB90Block), typeof(AshlarShaleHalfSlopeB180Block), typeof(AshlarShaleHalfSlopeB270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [IsForm(typeof(HalfSlopeBFormType), typeof(AshlarShaleItem))]
    [Tag("Constructable")]
    public partial class AshlarShaleHalfSlopeBBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleHalfSlopeB90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleHalfSlopeB180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(5)]
    [Tag("Constructable")]
    public partial class AshlarShaleHalfSlopeB270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

}