﻿// Copyright (c) Strange Loop Games. All rights reserved.
// See LICENSE file in the project root for full license information.
// <auto-generated from FormsTemplate.tt/>

namespace Eco.Mods.TechTree
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using Eco.Gameplay.Blocks;
    using Eco.Gameplay.Components;
    using Eco.Gameplay.DynamicValues;
    using Eco.Gameplay.Items;
    using Eco.Gameplay.Objects;
    using Eco.Gameplay.Players;
    using Eco.Gameplay.Skills;
    using Eco.Gameplay.Systems.TextLinks;
    using Eco.Shared.Serialization;
    using Eco.Shared.Utils;
    using Eco.World;
    using Eco.World.Water;
    using Eco.World.Blocks;
    using Eco.Gameplay.Pipes;
    using Tag = Eco.Core.Items.TagAttribute;
    using Eco.World.Color;

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(FloorFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickFloorBlock :
        Block, IRepresentsItem, IColoredBlock
    {
        public Type RepresentedItemType { get { return typeof(BrickItem); } }
    }
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(CubeFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickCubeBlock :
        Block, IRepresentsItem, IColoredBlock
    {
        public Type RepresentedItemType { get { return typeof(BrickItem); } }
    }
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(AqueductFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickAqueductBlock :
        Block, IRepresentsItem, IColoredBlock
    {
        public Type RepresentedItemType { get { return typeof(BrickItem); } }
    }
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(RoofCubeFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickRoofCubeBlock :
        Block, IRepresentsItem, IColoredBlock
    {
        public Type RepresentedItemType { get { return typeof(BrickItem); } }
    }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(WallFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickWallBlock :
        Block, IRepresentsItem, IWaterLoggedBlock, IColoredBlock
    {
        public Type RepresentedItemType { get { return typeof(BrickItem); } }
    }
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(RoofFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickRoofBlock :
        Block, IRepresentsItem, IWaterLoggedBlock, IColoredBlock
    {
        public Type RepresentedItemType { get { return typeof(BrickItem); } }
    }
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(ColumnFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickColumnBlock :
        Block, IRepresentsItem, IWaterLoggedBlock, IColoredBlock
    {
        public Type RepresentedItemType { get { return typeof(BrickItem); } }
    }
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(RoofPeakSetFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickRoofPeakSetBlock :
        Block, IRepresentsItem, IWaterLoggedBlock, IColoredBlock
    {
        public Type RepresentedItemType { get { return typeof(BrickItem); } }
    }
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(ThinFloorBottomFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickThinFloorBottomBlock :
        Block, IRepresentsItem, IWaterLoggedBlock, IColoredBlock
    {
        public Type RepresentedItemType { get { return typeof(BrickItem); } }
    }
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(ThinFloorTopFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickThinFloorTopBlock :
        Block, IRepresentsItem, IWaterLoggedBlock, IColoredBlock
    {
        public Type RepresentedItemType { get { return typeof(BrickItem); } }
    }





    [RotatedVariants(typeof(BrickStairsBlock), typeof(BrickStairs90Block), typeof(BrickStairs180Block), typeof(BrickStairs270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(StairsFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickStairsBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickStairs90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickStairs180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickStairs270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(BrickRoofSideBlock), typeof(BrickRoofSide90Block), typeof(BrickRoofSide180Block), typeof(BrickRoofSide270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(RoofSideFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickRoofSideBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickRoofSide90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickRoofSide180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickRoofSide270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(BrickRoofTurnBlock), typeof(BrickRoofTurn90Block), typeof(BrickRoofTurn180Block), typeof(BrickRoofTurn270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(RoofTurnFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickRoofTurnBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickRoofTurn90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickRoofTurn180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickRoofTurn270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(BrickRoofCornerBlock), typeof(BrickRoofCorner90Block), typeof(BrickRoofCorner180Block), typeof(BrickRoofCorner270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(RoofCornerFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickRoofCornerBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickRoofCorner90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickRoofCorner180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickRoofCorner270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(BrickRoofPeakBlock), typeof(BrickRoofPeak90Block), typeof(BrickRoofPeak180Block), typeof(BrickRoofPeak270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(RoofPeakFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickRoofPeakBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickRoofPeak90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickRoofPeak180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickRoofPeak270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(BrickBasicSlopeSideBlock), typeof(BrickBasicSlopeSide90Block), typeof(BrickBasicSlopeSide180Block), typeof(BrickBasicSlopeSide270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(BasicSlopeSideFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickBasicSlopeSideBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickBasicSlopeSide90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickBasicSlopeSide180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickBasicSlopeSide270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(BrickBasicSlopePointBlock), typeof(BrickBasicSlopePoint90Block), typeof(BrickBasicSlopePoint180Block), typeof(BrickBasicSlopePoint270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(BasicSlopePointFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickBasicSlopePointBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickBasicSlopePoint90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickBasicSlopePoint180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickBasicSlopePoint270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(BrickUnderSlopeSideBlock), typeof(BrickUnderSlopeSide90Block), typeof(BrickUnderSlopeSide180Block), typeof(BrickUnderSlopeSide270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(UnderSlopeSideFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickUnderSlopeSideBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickUnderSlopeSide90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickUnderSlopeSide180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickUnderSlopeSide270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(BrickUnderSlopePeakBlock), typeof(BrickUnderSlopePeak90Block), typeof(BrickUnderSlopePeak180Block), typeof(BrickUnderSlopePeak270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(UnderSlopePeakFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickUnderSlopePeakBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickUnderSlopePeak90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickUnderSlopePeak180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickUnderSlopePeak270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(BrickBraceBlock), typeof(BrickBrace90Block), typeof(BrickBrace180Block), typeof(BrickBrace270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(BraceFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickBraceBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickBrace90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickBrace180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickBrace270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(BrickBraceCornerBlock), typeof(BrickBraceCorner90Block), typeof(BrickBraceCorner180Block), typeof(BrickBraceCorner270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(BraceCornerFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickBraceCornerBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickBraceCorner90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickBraceCorner180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickBraceCorner270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(BrickBraceTurnBlock), typeof(BrickBraceTurn90Block), typeof(BrickBraceTurn180Block), typeof(BrickBraceTurn270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(BraceTurnFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickBraceTurnBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickBraceTurn90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickBraceTurn180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickBraceTurn270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(BrickSideBraceBlock), typeof(BrickSideBrace90Block), typeof(BrickSideBrace180Block), typeof(BrickSideBrace270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(SideBraceFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickSideBraceBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickSideBrace90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickSideBrace180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickSideBrace270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(BrickSmallCornerBraceBlock), typeof(BrickSmallCornerBrace90Block), typeof(BrickSmallCornerBrace180Block), typeof(BrickSmallCornerBrace270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(SmallCornerBraceFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickSmallCornerBraceBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickSmallCornerBrace90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickSmallCornerBrace180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickSmallCornerBrace270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(BrickThinWallEdgeBlock), typeof(BrickThinWallEdge90Block), typeof(BrickThinWallEdge180Block), typeof(BrickThinWallEdge270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(ThinWallEdgeFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickThinWallEdgeBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickThinWallEdge90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickThinWallEdge180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickThinWallEdge270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(BrickUnderBraceBlock), typeof(BrickUnderBrace90Block), typeof(BrickUnderBrace180Block), typeof(BrickUnderBrace270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(UnderBraceFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickUnderBraceBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickUnderBrace90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickUnderBrace180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickUnderBrace270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(BrickUnderBraceCornerBlock), typeof(BrickUnderBraceCorner90Block), typeof(BrickUnderBraceCorner180Block), typeof(BrickUnderBraceCorner270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(UnderBraceCornerFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickUnderBraceCornerBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickUnderBraceCorner90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickUnderBraceCorner180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickUnderBraceCorner270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(BrickUnderBraceTurnBlock), typeof(BrickUnderBraceTurn90Block), typeof(BrickUnderBraceTurn180Block), typeof(BrickUnderBraceTurn270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(UnderBraceTurnFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickUnderBraceTurnBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickUnderBraceTurn90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickUnderBraceTurn180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickUnderBraceTurn270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(BrickWindowBlock), typeof(BrickWindow90Block), typeof(BrickWindow180Block), typeof(BrickWindow270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(WindowFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickWindowBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickWindow90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickWindow180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickWindow270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(BrickWindowEdgeBlock), typeof(BrickWindowEdge90Block), typeof(BrickWindowEdge180Block), typeof(BrickWindowEdge270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(WindowEdgeFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickWindowEdgeBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickWindowEdge90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickWindowEdge180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickWindowEdge270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(BrickWindowGrillesBlock), typeof(BrickWindowGrilles90Block), typeof(BrickWindowGrilles180Block), typeof(BrickWindowGrilles270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(WindowGrillesFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickWindowGrillesBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickWindowGrilles90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickWindowGrilles180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickWindowGrilles270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(BrickWindowGrillesEdgeBlock), typeof(BrickWindowGrillesEdge90Block), typeof(BrickWindowGrillesEdge180Block), typeof(BrickWindowGrillesEdge270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(WindowGrillesEdgeFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickWindowGrillesEdgeBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickWindowGrillesEdge90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickWindowGrillesEdge180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickWindowGrillesEdge270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(BrickRampABlock), typeof(BrickRampA90Block), typeof(BrickRampA180Block), typeof(BrickRampA270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(RampAFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickRampABlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickRampA90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickRampA180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickRampA270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(BrickRampBBlock), typeof(BrickRampB90Block), typeof(BrickRampB180Block), typeof(BrickRampB270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(RampBFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickRampBBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickRampB90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickRampB180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickRampB270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(BrickRampCBlock), typeof(BrickRampC90Block), typeof(BrickRampC180Block), typeof(BrickRampC270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(RampCFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickRampCBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickRampC90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickRampC180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickRampC270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }
    [RotatedVariants(typeof(BrickRampDBlock), typeof(BrickRampD90Block), typeof(BrickRampD180Block), typeof(BrickRampD270Block))]
    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [IsForm(typeof(RampDFormType), typeof(BrickItem))]
    [Tag("Constructable")]
    public partial class BrickRampDBlock : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickRampD90Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickRampD180Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

    [Serialized]
    [Wall, Constructed, Solid, BuildRoomMaterialOption]
    [BlockTier(3)]
    [Tag("Constructable")]
    public partial class BrickRampD270Block : Block, IWaterLoggedBlock, IColoredBlock
    { }

}