﻿// Copyright (c) Strange Loop Games. All rights reserved.
// See LICENSE file in the project root for full license information.
// <auto-generated from ItemTemplate.tt/>

namespace Eco.Mods.TechTree
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using Eco.Gameplay.Blocks;
    using Eco.Gameplay.Components;
    using Eco.Gameplay.DynamicValues;
    using Eco.Gameplay.Items;
    using Eco.Gameplay.Objects;
    using Eco.Gameplay.Players;
    using Eco.Gameplay.Skills;
    using Eco.Gameplay.Settlements;
    using Eco.Gameplay.Systems;
    using Eco.Gameplay.Systems.TextLinks;
    using Eco.Shared.Localization;
    using Eco.Shared.Serialization;
    using Eco.Shared.Utils;
    using Eco.Core.Items;
    using Eco.World;
    using Eco.World.Blocks;
    using Eco.Gameplay.Pipes;
    using Eco.Core.Controller;
    using Eco.Gameplay.Items.Recipes;
	using Eco.Gameplay.Housing.PropertyValues;

        
    /// <summary>
    /// <para>Server side recipe definition for "IronSawBlade".</para>
    /// <para>More information about RecipeFamily objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Items.RecipeFamily.html</para>
    /// </summary>
    /// <remarks>
    /// This is an auto-generated class. Don't modify it! All your changes will be wiped with next update! Use Mods* partial methods instead for customization. 
    /// If you wish to modify this class, please create a new partial class or follow the instructions in the "UserCode" folder to override the entire file.
    /// </remarks>
    [RequiresModule(typeof(BloomeryObject))]
    [RequiresSkill(typeof(BlacksmithSkill), 2)]
    [Ecopedia("Items", "Products", subPageName: "Iron Saw Blade Item")]
    public partial class IronSawBladeRecipe : RecipeFamily
    {
        public IronSawBladeRecipe()
        {
            var recipe = new Recipe();
            recipe.Init(
                name: "IronSawBlade",  //noloc
                displayName: Localizer.DoStr("Iron Saw Blade"),

                // Defines the ingredients needed to craft this recipe. An ingredient items takes the following inputs
                // type of the item, the amount of the item, the skill required, and the talent used.
                ingredients: new List<IngredientElement>
                {
                    new IngredientElement(typeof(IronBarItem), 6, typeof(BlacksmithSkill), typeof(BlacksmithLavishResourcesTalent)),
                },

                // Define our recipe output items.
                // For every output item there needs to be one CraftingElement entry with the type of the final item and the amount
                // to create.
                items: new List<CraftingElement>
                {
                    new CraftingElement<IronSawBladeItem>()
                });
            this.Recipes = new List<Recipe> { recipe };
            this.ExperienceOnCraft = 2; // Defines how much experience is gained when crafted.
            
            // Defines the amount of labor required and the required skill to add labor
            this.LaborInCalories = CreateLaborInCaloriesValue(60, typeof(BlacksmithSkill));

            // Defines our crafting time for the recipe
            this.CraftMinutes = CreateCraftTimeValue(beneficiary: typeof(IronSawBladeRecipe), start: 1.2f, skillType: typeof(BlacksmithSkill), typeof(BlacksmithFocusedSpeedTalent), typeof(BlacksmithParallelSpeedTalent));

            // Perform pre/post initialization for user mods and initialize our recipe instance with the display name "Iron Saw Blade"
            this.ModsPreInitialize();
            this.Initialize(displayText: Localizer.DoStr("Iron Saw Blade"), recipeType: typeof(IronSawBladeRecipe));
            this.ModsPostInitialize();

            // Register our RecipeFamily instance with the crafting system so it can be crafted.
            CraftingComponent.AddRecipe(tableType: typeof(AnvilObject), recipeFamily: this);
        }

        /// <summary>Hook for mods to customize RecipeFamily before initialization. You can change recipes, xp, labor, time here.</summary>
        partial void ModsPreInitialize();

        /// <summary>Hook for mods to customize RecipeFamily after initialization, but before registration. You can change skill requirements here.</summary>
        partial void ModsPostInitialize();
    }
    
    /// <summary>
    /// <para>Server side item definition for the "IronSawBlade" item.</para>
    /// <para>More information about PartItem objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Items.PartItem.html</para>
    /// </summary>
    /// <remarks>
    /// This is an auto-generated class. Don't modify it! All your changes will be wiped with next update! Use Mods* partial methods instead for customization. 
    /// If you wish to modify this class, please create a new partial class or follow the instructions in the "UserCode" folder to override the entire file.
    /// </remarks>
    [Serialized] // Tells the save/load system this object needs to be serialized. 
    [LocDisplayName("Iron Saw Blade")] // Defines the localized name of the item.
    [Weight(100)] // Defines how heavy IronSawBlade is.
    [RepairRequiresSkill(typeof(BlacksmithSkill), 0)]
    [Ecopedia("Items", "Products", createAsSubPage: true)]
    [LocDescription("A disc shaped iron saw that can be attached to rotary machines to shape wood products.")] //The tooltip description for the item.
    public partial class IronSawBladeItem : PartItem    {
        private static SkillModifiedValue skilledRepairCost = new SkillModifiedValue(2, BlacksmithSkill.MultiplicativeStrategy, typeof(BlacksmithSkill), typeof(IronSawBladeItem), Localizer.DoStr("repair cost"), DynamicValueType.Efficiency);

        public override IDynamicValue SkilledRepairCost => skilledRepairCost;
        public override int FullRepairAmount            => 2;
        public float ReduceMaxDurabilityByPercent       => 0.05f;
        

        // This handles multiple repair elements and how much reduction in cost of the material type
        // meaning 1 = full cost and .1 = 10% of the total cost for 100% repair.
        public override IEnumerable<RepairingItem> RepairItems {get
        {
                    yield return new() { Item = Item.Get("CoarseStoneItem"), MaterialMult = 2 };
            yield return new() { Item = Item.Get("SharpeningSteelItem"), MaterialMult = 1 };
            yield return new() { Item = Item.Get("WhetstoneItem"), MaterialMult = 2 };
            yield return new() { Item = Item.Get("PolishingPasteItem"), MaterialMult = 0.5f };
        } }
    }
}