﻿// Copyright (c) Strange Loop Games. All rights reserved.
// See LICENSE file in the project root for full license information.
// <auto-generated from ItemTemplate.tt/>

namespace Eco.Mods.TechTree
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using Eco.Gameplay.Blocks;
    using Eco.Gameplay.Components;
    using Eco.Gameplay.DynamicValues;
    using Eco.Gameplay.Items;
    using Eco.Gameplay.Objects;
    using Eco.Gameplay.Players;
    using Eco.Gameplay.Skills;
    using Eco.Gameplay.Settlements;
    using Eco.Gameplay.Systems;
    using Eco.Gameplay.Systems.TextLinks;
    using Eco.Shared.Localization;
    using Eco.Shared.Serialization;
    using Eco.Shared.Utils;
    using Eco.Core.Items;
    using Eco.World;
    using Eco.World.Blocks;
    using Eco.Gameplay.Pipes;
    using Eco.Core.Controller;
    using Eco.Gameplay.Items.Recipes;
	using Eco.Gameplay.Housing.PropertyValues;

            
    /// <summary>
    /// <para>Server side item definition for the "WoodPulp" item.</para>
    /// <para>More information about Item objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Items.Item.html</para>
    /// </summary>
    /// <remarks>
    /// This is an auto-generated class. Don't modify it! All your changes will be wiped with next update! Use Mods* partial methods instead for customization. 
    /// If you wish to modify this class, please create a new partial class or follow the instructions in the "UserCode" folder to override the entire file.
    /// </remarks>
    [Serialized] // Tells the save/load system this object needs to be serialized. 
    [LocDisplayName("Wood Pulp")] // Defines the localized name of the item.
    [Compostable] // Defines if the object is compostable
    [Weight(50)] // Defines how heavy WoodPulp is.
    [Fuel(50)][Tag("Fuel")] // Marks WoodPulp as fuel item.
    [Ecopedia("Items", "Products", createAsSubPage: true)]
    [Tag("NaturalFiber")]
    [Tag("Burnable Fuel")]
    [LocDescription("A byproduct of processing lumber, wood pulp can be burned for Mortar or pressed into paper.")] //The tooltip description for the item.
    public partial class WoodPulpItem : Item    {

        /// <summary>The plural localization name for the item.</summary>
        public override LocString DisplayNamePlural { get { return Localizer.DoStr("Wood Pulp"); } }
        

    }
}