﻿// Copyright (c) Strange Loop Games. All rights reserved.
// See LICENSE file in the project root for full license information.
// <auto-generated from ToolTemplate.tt/>

namespace Eco.Mods.TechTree
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using Eco.Core.Items;
    using Eco.Gameplay.Blocks;
    using Eco.Gameplay.Components;
    using Eco.Gameplay.DynamicValues;
    using Eco.Gameplay.Items;
    using Eco.Gameplay.Items.Internal;
    using Eco.Gameplay.Players;
    using Eco.Gameplay.Skills;
    using Eco.Gameplay.Systems;
    using Eco.Gameplay.Systems.TextLinks;
    using Eco.Shared.Localization;
    using Eco.Shared.Serialization;
    using Eco.Shared.Utils;
    using Eco.World;
    using Eco.World.Blocks;
    using Eco.Gameplay.Pipes;
    using Eco.Shared.Math;
    using Eco.Core.Controller;
    using Eco.Gameplay.Interactions.Interactors;
    using Eco.Gameplay.Items.Recipes;


    /// <summary>
    /// <para>Server side recipe definition for "NorseAxe".</para>
    /// <para>More information about RecipeFamily objects can be found at https://docs.play.eco/api/server/eco.gameplay/Eco.Gameplay.Items.RecipeFamily.html</para>
    /// </summary>
    /// <remarks>
    /// This is an auto-generated class. Don't modify it! All your changes will be wiped with next update! Use Mods* partial methods instead for customization. 
    /// If you wish to modify this class, please create a new partial class or follow the instructions in the "UserCode" folder to override the entire file.
    /// </remarks>
    [RequiresModule(typeof(BlacksmithTableObject))]
    [RequiresSkill(typeof(BlacksmithSkill), 3)]
    [ForceCreateView]
    [Ecopedia("Items", "Tools", subPageName: "Norse Axe Item")]
    public partial class NorseAxeRecipe : Recipe
    {
        public NorseAxeRecipe()
        {
            this.Init(
                name: "NorseAxe",  //noloc
                displayName: Localizer.DoStr("Norse Axe"),

                // Defines the ingredients needed to craft this recipe. An ingredient items takes the following inputs
                // type of the item, the amount of the item, the skill required, and the talent used.
                ingredients: new List<IngredientElement>
                {
                    new IngredientElement(typeof(SteelBarItem), 20, typeof(BlacksmithSkill)),
                    new IngredientElement(typeof(LeatherHideItem), 8, typeof(BlacksmithSkill)),
                    new IngredientElement("Lumber", 5, typeof(BlacksmithSkill)), //noloc
                },

                // Define our recipe output items.
                // For every output item there needs to be one CraftingElement entry with the type of the final item and the amount
                // to create.
                items: new List<CraftingElement>
                {
                    new CraftingElement<NorseAxeItem>()
                });
            // Perform post initialization steps for user mods and initialize our recipe instance as a tag product with the crafting system
            this.ModsPostInitialize();
            CraftingComponent.AddTagProduct(typeof(PowerHammerObject), typeof(SteelAxeRecipe), this);
        }


        /// <summary>Hook for mods to customize RecipeFamily after initialization, but before registration. You can change skill requirements here.</summary>
        partial void ModsPostInitialize();
    }

    [Serialized]
    [LocDisplayName("Norse Axe")]
    [LocDescription("A Steel axe made for cutting down trees.")]
    [Tier(3)]
    [RepairRequiresSkill(typeof(BlacksmithSkill), 0)]
    [Weight(1000)]
    [Category("Tool")]
    [Tag("Tool")]
    [Ecopedia("Items", "Tools", createAsSubPage: true)]
    public partial class NorseAxeItem : AxeItem
    {

                                                                                                                                                                                                                                           // Static values
        private static IDynamicValue caloriesBurn           = new MultiDynamicValue(MultiDynamicOps.Multiply, new TalentModifiedValue(typeof(NorseAxeItem), typeof(LoggingToolEfficiencyTalent)), CreateCalorieValue(20, typeof(LoggingSkill), typeof(NorseAxeItem)));
        private static IDynamicValue damage                 = new MultiDynamicValue(MultiDynamicOps.Sum, new TalentModifiedValue(typeof(NorseAxeItem), typeof(LoggingToolStrengthTalent), 0), CreateDamageValue(2, typeof(LoggingSkill), typeof(NorseAxeItem)));
        private static IDynamicValue exp                    = new MultiDynamicValue(MultiDynamicOps.Multiply, new ConstantValue(0.1f), damage);
        private static IDynamicValue tier                   = new ConstantValue(3);
        private static IDynamicValue perkDamage             = new MultiDynamicValue(MultiDynamicOps.Sum, new ConstantValue(0), new TalentModifiedValue(typeof(NorseAxeItem), typeof(LoggingToolStrengthTalent), 0));
        private static SkillModifiedValue skilledRepairCost = new SkillModifiedValue(2, BlacksmithSkill.MultiplicativeStrategy, typeof(BlacksmithSkill), typeof(NorseAxeItem), Localizer.DoStr("repair cost"), DynamicValueType.Efficiency);


        // Tool overrides

        public override IDynamicValue CaloriesBurn      => caloriesBurn;
        public override IDynamicValue Damage            => damage;
        public override Type ExperienceSkill            => typeof(LoggingSkill);
        public override IDynamicValue ExperienceRate    => exp;
        public override IDynamicValue Tier              => tier;
        public override IDynamicValue SkilledRepairCost => skilledRepairCost;
        public override float OriginalMaxDurability     => 2500f;
        public override int FullRepairAmount            => 2;

        // This handles multiple repair elements and how much reduction in cost of the material type
        // meaning 1 = full cost and .1 = 10% of the total cost for 100% repair.
        public override IEnumerable<RepairingItem> RepairItems {get
        {
                yield return new() { Item = Item.Get<CoarseStoneItem>(), MaterialMult = 2 };
        yield return new() { Item = Item.Get<SharpeningSteelItem>(), MaterialMult = 1 };
        yield return new() { Item = Item.Get<WhetstoneItem>(), MaterialMult = 2 };
        yield return new() { Item = Item.Get<PolishingPasteItem>(), MaterialMult = 0.5f };
        } }
    }
}
